#ifndef _HELP._H_
#define _HELP._H_

/** @page help Help
 * This is the on-line help system. It provides access to the complete 
 * reference manual and the program tutorial.  The left sidebar contains a 
 * complete table of contents, with links to all of the main sections of the 
 * on-line documentation. 
 * 
 * This help window contains some basic navigation features.  There are
 * buttons for traversing the history stack and searching the text in the
 * help window itself.  There are also key bindings
 * within the help window itself:
 * 
 * @arg @b s Search forward.  Searches forward in the text for the next
 * occurrence of the specified text.
 * @arg @b r Search backward.  Searches backward in the text for the next
 * occurrence of the specified text.
 * @arg @b f History forward.  Goes to the next page in the history stack.
 * @arg @b b History backward. Goes to the previous page in the history
 * stack.
 * @arg @b Tab Next link. Goes to the next hyper link.
 * @arg @b Control-Tab Previous link. Goes to the previous hyper link.
 * 
 */



#endif /* _HELP._H_ */

