#* 
#* ------------------------------------------------------------------
#* Upsidedown Mouse 0.0.0 by Deepwoods Software
#* ------------------------------------------------------------------
#* UpSideDownMouse.tcl - Main program
#* Created by Robert Heller on Sun Aug 21 11:47:03 2011
#* ------------------------------------------------------------------
#* $Id$
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Upsidedown Mouse -- A program to draw stuff with the mouse 'upsidedown'.
#* 
#*     Copyright (C) 2011  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

## @defgroup UpSideDownMouse UpSideDownMouse
# @brief A program to draw stuff with the mouse 'upsidedown'.
#
# @section SYNOPSIS
#
# UpSideDownMouse [X11 Resource Options]
#
# @section DESCRIPTION
#
#
# @section AUTHOR
# Robert Heller \<heller\@deepsoft.com\>

set argv0 [file join [file dirname [info nameofexecutable]] UpSideDownMouse]

package require Version
package require Tk
package require BWidget
package require BWStdMenuBar
package require HTMLHelp

namespace eval UpSideDownMouse {
  variable ImageDir [file join [file dirname \
				     [file dirname \
					   [file dirname [info script]]]] \
			       Images]

  variable HelpDir  [file join [file dirname \
				     [file dirname \
					   [file dirname [info script]]]] \
			       Help]
  variable Main
  variable FocusNowhere
  variable DrawingArea
}

package require UpsidedownCanvas

proc UpSideDownMouse::GetTopLevelOfFocus {} {
  if {[catch {winfo toplevel [focus -displayof .]} tl]} {
    return {}
  } else {
    return $tl
  }
}

proc UpSideDownMouse::ShowMainWindow {} {
  wm deiconify .
  raise .
}

proc UpSideDownMouse::CreateMainWindow {} {
  variable ImageDir
  variable HelpDir
  variable Main
  variable FocusNowhere
  variable StatusBar {}
  variable Progress 0

  wm protocol . WM_DELETE_WINDOW {UpSideDownMouse::ExitApplication}
  wm title . "Upsidedown Mouse"

  set FocusNowhere [canvas .focusNowhere]

  set filemenu {"&File" menu:file file 0 {
			{command "&New"     {file:new} "New drawing" {Ctrl n}
					-command {UpSideDownMouse::NewDrawing}}
			{command "&Print..." {file:print}
					"Print current drawing" {Ctrl p} 
				-command {UpSideDownMouse::PrintDrawing}}
			{command "&Quit"    {file:exit} "Exit the application"
					{Ctrl q} 
				-command {UpSideDownMouse::ExitApplication}}
		}}
  
  pack [set Main [MainFrame .main \
	-menu [StdMenuBar::MakeMenu \
		-file $filemenu] \
	-textvariable UpSideDownMouse::StatusBar \
	-progressvar  UpSideDownMouse::Progress \
	-progressmax  100]] -expand yes -fill both
  variable DrawingArea [UpsidedownCanvas [$Main getframe].drawingArea \
			-borderwidth {2} -relief {ridge}]
  pack $DrawingArea -expand yes -fill both

  wm withdraw .
  update idle
  set x [expr {[winfo screenwidth .]/2 - [winfo reqwidth .]/2 \
		- [winfo vrootx .]}]
  set y [expr {[winfo screenheight .]/2 - [winfo reqheight .]/2 \
		- [winfo vrooty .]}]
      # Make sure that the window is on the screen and set the maximum
  # size of the window is the size of the screen.  That'll let things
  # fail fairly gracefully when very large messages are used. [Bug 827535]
  if {$x < 0} {
      set x 0
  }
  if {$y < 0} {
      set y 0
  }
  wm geom .  +$x+$y

  set helpmenu [$Main getmenu help]

  $helpmenu delete "On Keys..."
  $helpmenu delete "Index..."
  $helpmenu delete "Tutorial..."
  $helpmenu entryconfigure "On Help..." \
		-command "::HTMLHelp::HTMLHelp help Help"
  $helpmenu entryconfigure "On Version" \
		-command "::HTMLHelp::HTMLHelp help Version"
  $helpmenu entryconfigure "Copying" \
	-command "::HTMLHelp::HTMLHelp help Copying"
  $helpmenu entryconfigure "Warranty" \
	-command "::HTMLHelp::HTMLHelp help Warranty"
  $helpmenu add command -label "About" \
	-command "::HTMLHelp::HTMLHelp help About"

  ::HTMLHelp::HTMLHelp setDefaults "$HelpDir" UserManualli1.html

  wm deiconify .

}

proc UpSideDownMouse::NewDrawing {} {
  variable DrawingArea

  $DrawingArea clear
}

proc UpSideDownMouse::PrintDrawing {} {
  variable DrawingArea

  $DrawingArea print
}

proc UpSideDownMouse::ExitApplication {} {
  if {[tk_messageBox -icon question -default no -message "Really Exit?" \
	-title "Really Exit?" -type yesno]} {
    destroy .
  }
}

UpSideDownMouse::CreateMainWindow

