#* 
#* ------------------------------------------------------------------
#* Upsidedown Mouse 0.0.0 by Deepwoods Software
#* ------------------------------------------------------------------
#* UpsidedownCanvas.tcl - Upsidedown Canvas -- all mouse operations are reversed
#* Created by Robert Heller on Sun Aug 21 14:03:23 2011
#* ------------------------------------------------------------------
#* $Id$
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Upsidedown Mouse -- A program to draw stuff with the mouse 'upsidedown'.
#* 
#*     Copyright (C) 2011  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

package require snit
package require pdf4tcl

snit::widgetadaptor UpsidedownCanvas {

  delegate option * to hull except {-cursor}
  delegate method * to hull except {canvasx canvasy}

  method canvasx {mx} {
    set cx [$hull canvasx $mx]
    return [expr {[winfo width $win] - $cx}]
  }
  method canvasy {my} {
    set cy [$hull canvasy $my]
    return [expr {[winfo height $win] - $cy}]
  }

  variable lastX 0
  variable lastY 0
  variable pendown no

  constructor {args} {
    installhull using canvas
    $self configurelist $args

    set bg [$self cget -bg]
    $hull configure -cursor [list dot $bg]
    set tags [bindtags $self]
    set i [lsearch -exact $tags Canvas]
    set tags [lreplace $tags $i $i UpsidedownCanvas]
    bindtags $self $tags
  }
  typevariable PointerImage
  typeconstructor {
    set PointerImage [image create photo -file [file join $::UpSideDownMouse::ImageDir pointer.gif]]

    bind UpsidedownCanvas <Motion> [mytypemethod _motion %W %x %y]
    bind UpsidedownCanvas <ButtonPress-1> [mytypemethod _b1down %W %x %y]
    bind UpsidedownCanvas <B1-Motion> [mytypemethod _motion1 %W %x %y]
    bind UpsidedownCanvas <ButtonRelease-1> [mytypemethod _b1up %W %x %y]
    bind UpsidedownCanvas <Enter> [mytypemethod _enter %W %x %y]
    bind UpsidedownCanvas <Leave> [mytypemethod _leave %W %x %y]
  }

  typemethod _motion {W x y} {
    $W motion $x $y
  }
  typemethod _b1down {W x y} {
    $W b1down $x $y
  }
  typemethod _motion1 {W x y} {
    $W motion1 $x $y
  }
  typemethod _b1up {W x y} {
    $W b1up $x $y
  }
  typemethod _enter {W x y} {
    $W enter $x $y
  }
  typemethod _leave {W x y} {
    $W leave $x $y
  }

  method motion {mx my} {
    $self coords Cursor [$self canvasx $mx] [$self canvasy $my]
  }

  method b1down {mx my} {
    set lastX [$self canvasx $mx]
    set lastY [$self canvasy $my]
    set pendown yes
    $self coords Cursor $lastX $lastY
  }

  method motion1 {mx my} {
    set newX [$self canvasx $mx]
    set newY [$self canvasy $my]
    $self create line $lastX $lastY $newX $newY
    set lastX $newX
    set lastY $newY
    $self coords Cursor $lastX $lastY
  }
  
  method b1up {mx my} {
    set newX [$self canvasx $mx]
    set newY [$self canvasy $my]
    $self create line $lastX $lastY $newX $newY
    set lastX $newX
    set lastY $newY
    set pendown no
    $self coords Cursor $lastX $lastY
  }

  method enter {mx my} {
    set enterX [$self canvasx $mx]
    set enterY [$self canvasy $my]
    $self create image $enterX $enterY -anchor nw -image $PointerImage -tag Cursor
  }

  method leave {mx my} {
    $self delete Cursor
  }

  method clear {} {
    set pCoords [$self coords Cursor]
    $self delete all
    if {[llength $pCoords] > 0} {
      $self create image $pCoords -anchor nw -image $PointerImage -tag Cursor
    }
  }

  method print {} {
    set outfile [tk_getSaveFile -filetypes { {PDF .pdf PDF} {{All Files} *} } \
				-defaultextension .pdf \
				-initialfile Upsidedown.pdf \
				-parent [winfo toplevel $self] \
				-title "Print to PDF file"]
    if {"$outfile" eq ""} {return}

    set pCoords [$self coords Cursor]
    $self delete Cursor
    
    set output [::pdf4tcl::new %AUTO% -paper letter -file $outfile -margin 36]

    $output startPage
    $output canvas $self
    $output endPage
    $output finish
    $output write
    $output destroy

    if {[llength $pCoords] > 0} {
      $self create image $pCoords -anchor nw -image $PointerImage -tag Cursor
    }

  }

}


package provide UpsidedownCanvas 1.0
