#* 
#* ------------------------------------------------------------------
#* Printer.tcl - Printer Support code
#* Created by Robert Heller on Fri May 25 10:26:12 2007
#* ------------------------------------------------------------------
#* Modification History: $Log: headerfile.text,v $
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Generic Project
#*     Copyright (C) 2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

namespace eval Printer {
  snit::type PrinterDialog {
    pragma -hastypeinfo    no
    pragma -hastypedestroy no
    pragma -hasinstances   no

    typecomponent dialog;#			Dialog widget
    typecomponent   printerOrFileTF;#		Printer or file title frame
    typecomponent     printerRadio;#		printer radiobutton
    typecomponent     printerLF;#		printer label frame
    typecomponent       printerCB;#		printer ComboBox
    typecomponent     fileRadio;#		file radiobutton
    typecomponent     fileLF;#			file label frame
    typecomponent       fileE;#			file entry
    typecomponent       fileB;#			file browse button
    typecomponent   landscapeCheck;#		landscape mode checkbutton
    typecomponent   pageSizeTF;#		pagesize title frame
    typecomponent     pageWidthLF;#		page width label frame
    typecomponent       pageWidthSB;#		page width spinbox
    typecomponent	pageWidthUnitsCB;#	page width units ComboBox
    typecomponent     pageHeightLF;#		page height label frame
    typecomponent       pageHeightSB;#		page width spinbox
    typecomponent       pageHeightUnitsCB;#	page height units ComboBox

    typevariable _Options -array {
      -title "Print Dialog"
      -parent .
      -pageheight 10i
      -pagewidth   8i
      -landscape   no
      -printerpath {}      
    }
    typevariable _phUnits i
    typevariable _pwUnits i
    typevariable _printerOrFile printer
    typeconstructor {
      set dialog [Dialog::create .printerDialog -anchor c -bitmap questhead \
				-cancel 1 -default 0 -modal local \
				-parent $_Options(-parent) -side bottom \
				-title "$_Options(-title)" -transient yes]
      $dialog add -name print  -text "Print"  -command [mytypemethod _Print]
      $dialog add -name cancel -text "Cancel" -command [mytypemethod _Cancel]
      $dialog add -name help   -text "Help"   -command "BWHelp::HelpTopic {Print Dialog}"
      set dframe [$dialog getframe]
      set printerOrFileTF [TitleFrame::create $dframe.printerOrFileTF \
				-text "Printer or File" \
				-side left]
      pack $printerOrFileTF -fill both -expand yes
      set printerOrFileTFfr [$printerOrFileTF getframe]
      set printerRadio [radiobutton $printerOrFileTFfr.printerRadio \
				-command [mytypemethod _TogglePF] \
				-indicatoron yes -value printer -text {} \
				-variable [mytypevar _printerOrFile]]
      grid $printerRadio -row 0 -column 0 -sticky wns
      set printerLF [LabelFrame::create $printerOrFileTFfr.printerLF \
				-text "Printer:" -width 10]
      grid $printerLF -row 0 -column 1 -sticky news
      set printerCB [ComboBox::create [$printerLF getframe].printerCB \
			-editable no]
      pack $printerCB -fill x -expand yes
      set fileRadio [radiobutton $printerOrFileTFfr.fileRadio \
				-command [mytypemethod _TogglePF] \
				-indicatoron yes -value file -text {} \
				-variable [mytypevar _printerOrFile]]
      grid $fileRadio -row 1 -column 0 -sticky wns
      set fileLF [LabelFrame::create $printerOrFileTFfr.fileLF \
				-text "File:" -width 10 -state disabled]
      set fileE [Entry::create [$fileLF getframe].fileE -state disabled \
				-text "printout.ps"]
      pack $fileE -expand yes -fill x -side left
      set fileB [Button::create [$fileLF getframe].fileB -text "Browse" \
		 	-command [mytypemethod _FileBrowsePS] -state disabled]
      pack $fileB -side right
      grid $fileLF -row 1 -column 1 -sticky news
      set landscapeCheck [checkbutton $dframe.landscapeCheck \
				-text "Landscape mode?" \
				-indicatoron yes -onvalue yes -offvalue no \
				-variable [mytypevar _Options(-landscape)]]
      pack $landscapeCheck -expand yes -fill x
      set pageSizeTF [TitleFrame::create $dframe.pageSizeTF \
			-text "Page Size" -side left]
      pack $pageSizeTF -fill both -expand yes
      set pageSizeTFfr [$pageSizeTF getframe]
      set pageWidthLF [LabelFrame::create $pageSizeTFfr.pageWidthLF \
			-text "Width:" -width 15]
      pack $pageWidthLF -fill x
      set pageWidthSB [SpinBox::create [$pageWidthLF getframe].pageWidthSB \
			-range {1.0 3000.0 1.0} -editable yes]
      pack $pageWidthSB -expand yes -fill x -side left
      set pageWidthUnitsCB [ComboBox::create \
			[$pageWidthLF getframe].pageWidthUnitsCB \
			-values {c i m p} -editable no -width 1 \
			-textvariable _pwUnits]
      pack $pageWidthUnitsCB -side right
      set pageHeightLF [LabelFrame::create $pageSizeTFfr.pageHeightLF \
			-text "Height:" -width 15]
      pack $pageHeightLF -fill x
      set pageHeightSB [SpinBox::create [$pageHeightLF getframe].pageHeightSB \
			-range {1.0 3000.0 1.0} -editable yes]
      pack $pageHeightSB -expand yes -fill x -side left
      set pageHeightUnitsCB [ComboBox::create \
			[$pageHeightLF getframe].pageHeightUnitsCB \
			-values {c i m p} -editable no -width 1 \
			-textvariable _phUnits]
      pack $pageHeightUnitsCB -side right
    }
    typemethod _TogglePF {} {
      switch $_printerOrFile {
	printer {
	  $printerLF configure -state normal
	  $printerCB configure -state normal
	  $fileLF    configure -state disabled
	  $fileE     configure -state disabled
	  $fileB     configure -state disabled
	}
	file {
	  $printerLF configure -state disabled
	  $printerCB configure -state disabled
	  $fileLF    configure -state normal
	  $fileE     configure -state normal
	  $fileB     configure -state normal
	}
      }
    }
    typemethod _FileBrowsePS {} {
      set file "[$fileE cget -text]"
      set newfile [tk_getSaveFile \
	-filetypes { {{Postscript Files} .ps TEXT} {{All Files} * TEXT}}\
	-defaultextension .ps -initialdir "[file dirname $file]" \
	-initialfile "$file" -parent $dialog \
	-title "Postscript file to print to"]
      if {[string length "$newfile"] > 0} {
	$fileE configure -text "$newfile"
      }
    }
    typemethod _Cancel {} {
      $dialog withdraw
      $dialog enddialog cancel
    }
    typemethod _Print {} {
      switch $_printerOrFile {
	printer {
	  set lp [auto_execok lp]
	  set lpr [auto_execok lpr]
	  if {[string length "$lpr"] > 0} {
	    set _Options(-printerpath) "|$lpr -P[$printerCB cget -text]"
	  } elseif {[string length "$lp"] > 0} {
	    set _Options(-printerpath) "|$lp -d [$printerCB cget -text]"
	  } else {
	    tk_messageBox -type ok -icon warning "Print spool command not available, please print to a file."
	    return
  	  }
	}
	file {
	  set _Options(-printerpath) "[$fileE cget -text]"
	}
      }
      set _Options(-pageheight) "[$pageHeightSB cget -text][$pageHeightUnitsCB cget -text]"
      set _Options(-pagewidth) "[$pageWidthSB cget -text][$pageWidthUnitsCB cget -text]"
      $dialog withdraw
      $dialog enddialog print
    }
    typemethod cget {option} {
      return $_Options($option)
    }
    typemethod draw {args} {
#      puts stderr "$type draw $args"
      foreach o [array names _Options] {
	set _Options($o) [from args $o $_Options($o)]
      }
#      parray _Options
      $dialog configure -parent $_Options(-parent)
      $dialog configure -title  "$_Options(-title)"
      wm transient [winfo toplevel $dialog] $_Options(-parent)
      set ph 10
      regexp {^([0-9.-]+)([cimp]*)$} "$_Options(-pageheight)" -> ph _phUnits
      $pageHeightSB configure -text "$ph"
      switch [string length "$_phUnits"] {
        0 {set _phUnits p}
	1 {}
	default {
	  set _phUnits [string range "$_phUnits" 0 0]
	}
      }
      $pageHeightUnitsCB configure -text "$_phUnits"
      set pw 8
      regexp {^([0-9.-]+)([cimp]*)$} "$_Options(-pagewidth)" -> pw _pwUnits
      $pageWidthSB configure -text "$pw"
      switch [string length "$_pwUnits"] {
        0 {set _pwUnits p}
	1 {}
	default {
	  set _pwUnits [string range "$_pwUnits" 0 0]
	}
      }
      $pageWidthUnitsCB configure -text "$_pwUnits"
      set lpstat [auto_execok lpstat]
      if {[string length "$lpstat"] > 0} {
	set printers {}
	if {![catch {open "|$lpstat -a" r} lpstatFP]} {
	  while {[gets $lpstatFP line] >= 0} {
	    if {[regexp {^(.+)[[:space:]]accepting} "$line" -> printer] > 0} {
	      lappend printers $printer
	    }
	  }
	  close $lpstatFP
	}
	$printerCB configure -values [lsort -dictionary $printers]
	if {![catch {open "|$lpstat -d" r} lpstatFP]} {
	  set defprinter {}
	  while {[gets $lpstatFP line] >= 0} {
	    if {[regexp {destination:[[:space:]](.*)$} "$line" -> defprinter] > 0} {
	      break
	    }
	  }
	  close $lpstatFP
	  $printerCB configure -text "$defprinter"
	}
      }
      return [$dialog draw]
    }
  }
}

proc Printer::OpenPrinter {title parent pageheightvar pagewidthvar 
			   landscapevar} {
  upvar $pageheightvar pageheight
  upvar $pagewidthvar  pagewidth
  upvar $landscapevar  landscape

  set button [Printer::PrinterDialog draw -title "$title" -parent $parent \
					  -pageheight $pageheight \
					  -pagewidth $pagewidth \
					  -landscape $landscape]
  switch $button {
    cancel {return {}}
    print  {
      set pageheight [Printer::PrinterDialog cget -pageheight]
      set pagewidth  [Printer::PrinterDialog cget -pagewidth]
      set landscape  [Printer::PrinterDialog cget -landscape]
      set printerpath [Printer::PrinterDialog cget -printerpath]
      if {[catch {open "$printerpath" w} prfp]} {
	tk_messageBox -type ok -icon error -message "$parent: Printer::OpenPrinter: $prfp"
        return {}
      }
      return $prfp
    }
  }
}


package provide Printer 1.0
