#* 
#* ------------------------------------------------------------------
#* ReportPages.tcl - Report Pages Widget
#* Created by Robert Heller on Fri May 25 13:07:24 2007
#* ------------------------------------------------------------------
#* Modification History: $Log: headerfile.text,v $
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Generic Project
#*     Copyright (C) 2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

namespace eval ReportPages {
  snit::widget RadioBox {
    delegate option * to hull
    delegate method * to hull
    option -side -default top
    option -variable
    variable rbs -array {}
    variable rbindex -1
    constructor {args} {$self configurelist $args}
    method add {args} {
      incr rbindex
      set name [from args -name $rbindex]
      from args -variable
      set bn rb$rbindex
      set button [eval [list radiobutton $win.$bn -variable "$options(-variable)"] $args]
      set rbs($name) $button
      pack $button -side $options(-side)
    }
    method delete {index} {
      if {[catch {set rbs($index)} button]} {
	if {[catch {lindex [winfo children $win] $index} button]} {
	  error "Bad button index: $index"
	} else {
	  foreach i [array names rbs] {
	    if {[string equal "$button" "$rbs($i)"]} {
	      unset rbs($i)
	      break
	    }
	  }
	  destroy $button
 	}
      } else {
	destroy $button
	unset rbs($index)
      }
    }
    method itemcget {index option} {
      if {[catch {set rbs($index)} button]} {
	if {[catch {lindex [winfo children $win] $index} button]} {
	  error "Bad button index: $index"
	} else {
	  return [$button cget $option]
	}
      } else {
	return [$button cget $option]
      }
    }
    method itemconfigure {index args} {
      if {[catch {set rbs($index)} button]} {
	if {[catch {lindex [winfo children $win] $index} button]} {
	  error "Bad button index: $index"
	} else {
	  return [eval [list $button configure] $args]
	}
      } else {
	return [eval [list $button configure] $args]
      }
    }
  }
  snit::widget ReportPages {

    option -height -default 1
    option -width  -default 1

    # Frame components
    component pageScrollWindow;#	Scroll window for the pages
    component   pageScrollFrame;#	Scroll frame for the pages
    component     pageManager;#		Page manager for the pages
    component pageNumberFrame;#		Page number frame
    component   pageUp;#		Page up (previous page)
    component   pnSW;#			Page number scroll window
    component     pnSF;#		Page number scroll frame
    component       pnBB;#		Page number button box
    component   pageDown;#		Page up (next page)

    variable curpage {}
    variable pagelist {}
    constructor {args} {
#      puts stderr "*** $type constructor $args"
      $self configurelist $args
      $win configure -height $options(-height) -width $options(-width)
      install pageScrollWindow using \
			ScrolledWindow::create $win.pageScrollWindow \
				-scrollbar both -auto both
      pack $pageScrollWindow -side left -expand yes -fill both
      install pageScrollFrame using \
			ScrollableFrame::create \
					$pageScrollWindow.pageScrollFrame \
				-height [expr {$options(-height) - 20}]
      pack $pageScrollFrame -expand yes -fill both
      $pageScrollWindow setwidget $pageScrollFrame
      install pageManager using PagesManager::create \
				[$pageScrollFrame getframe].pageManager
      pack $pageManager -expand yes -fill both

      install pageNumberFrame using frame $win.pageNumberFrame -height $options(-height)
      pack $pageNumberFrame -side right -fill y
      install pageUp using ArrowButton::create $pageNumberFrame.pageUp \
			-dir top -command [mymethod _PreviousPage] \
			-type arrow
      pack $pageUp 
      install pnSW using ScrolledWindow::create $pageNumberFrame.pnSW \
				-scrollbar vertical -auto none
      pack $pnSW -expand yes -fill y
      install pnSF using ScrollableFrame::create $pnSW.pnSF \
					-constrainedwidth yes -width 20 \
					-height [expr {$options(-height) - 40}]
      pack $pnSF -expand yes -fill y
      $pnSW setwidget $pnSF
      install pnBB using ReportPages::RadioBox [$pnSF getframe].pnBB \
				-side top -variable [myvar curpage]
      pack $pnBB -fill y -expand yes
      install pageDown using ArrowButton::create $pageNumberFrame.pageDown \
			-dir bottom -command [mymethod _NextPage] \
			-type arrow
      pack $pageDown
#      update idle
#      puts stderr "*** $type constructor: winfo reqheight pageScrollWindow = [winfo reqheight $pageScrollWindow], winfo height pageScrollWindow = [winfo height $pageScrollWindow]"
#      foreach c [winfo children $pageScrollWindow] {
#	puts stderr "*** $type constructor: winfo reqheight pageScrollWindow.[winfo name $c] = [winfo reqheight $c], winfo height pageScrollWindow.[winfo name $c] = [winfo height $c]"
#      }
#      puts stderr "*** $type constructor: winfo reqheight pageNumberFrame = [winfo reqheight $pageNumberFrame], winfo height pageNumberFrame = [winfo height $pageNumberFrame]"
#      foreach c [winfo children $pageNumberFrame] {
#	puts stderr "*** $type constructor: winfo reqheight pageNumberFrame.[winfo name $c] = [winfo reqheight $c], winfo height pageNumberFrame.[winfo name $c] = [winfo height $c]"
#      }
#      puts stderr "*** $type constructor: winfo reqheight hull = [winfo reqheight $win], winfo height hull = [winfo height $win]"
    }
    method gotopage {index} {
      set oldpage [$pageManager raise]
      if {[catch {$pageManager raise $index}]} {return}
      set curpage $index
    }
    method addpage {index} {
      if {[catch {$pageManager add $index} fr]} {
#	puts stderr "*** $type addpage: fr = $fr"
	return [$self getpage $index]
      }
#      puts stderr "*** $type addpage: fr = $fr"
      canvas $fr.page -height 11i -width 8.5i -background white -relief flat \
			-borderwidth 0
      pack $fr.page
      $pageManager compute_size
      lappend pagelist $index
      $pnBB add -name page$index -text "$index" -value "$index" \
			-command [mymethod gotopage $index] \
			-indicatoron no
      $self gotopage $index
      return $fr.page
    }
    method getpage {index} {
      if {[llength $pagelist] ==  0} {return}
      if {[lsearch -exact $pagelist $index] < 0} {return}
      set fr [$pageManager getframe $index]
      return $fr.page
    }
    method deletepage {index} {
      if {[llength $pagelist] ==  0} {return}
      set ind [lsearch -exact $pagelist $index]
      if {$ind < 0} {return}
      catch {$pageManager delete $index}
      $pnBB delete page$index
      if {$ind == 0} {
	set pagelist [lrange $pagelist 1 end]
      } else {
	set pagelist [lreplace $pagelist $ind $ind]
      }
      set curpage {}
    }
    method deleteallpages {} {
      $self deletepages $pagelist
    }
    method deletepages {plist} {
      foreach i $plist {$self deletepage $i}
    } 
    method allpages {} {return $pagelist}
    method currentpage {} {return [$pageManager raise]}
    method _PreviousPage {} {
      if {[llength $pagelist] ==  0} {return}
      set ind [lsearch -exact $pagelist [$pageManager raise]]
      if {$ind > 0} {
	incr ind -1
	$self gotopage [lindex $pagelist $ind]
      }
    }
    method _NextPage {} {
      if {[llength $pagelist] ==  0} {return}
      set ind [lsearch -exact $pagelist [$pageManager raise]]
      incr ind
      if {$ind < [llength $pagelist]} {
	$self gotopage [lindex $pagelist $ind]
      }
    }
  }
}



package provide ReportPages 1.0
