1 Reference
The TkNewsII program is a multi-protocol news / EchoMail client. It
supports a local USENET news-feed access, NNTP access, and QWK access.

TkNewsII is started from the command line and takes one (optional)
command like option: [-iconic].  If this option is present on the
command line, the application starts up iconified.  TkNewsII is
configured with a resource file named <.TkNewsRc>. TkNewsII won't start
with out this file.

The TkNewsII's GUI consists of a <Main Window> and zero or more 
<Spool Window>s.  

2 Main Window

{MainWindow.gif}

The [Main Window] consists of the menu bar and a list of QWK files in
the QWK spool directory.

The [Main Window's] file menu provides these 6 main functions:

  * <Open QWK File>
  * <Get QWK File>
  * <Get All QWK Files>
  * <Review Spool>
  * <Rescan>
  * <Make QWK Reply>

Double clicking on a QWK file in the QWK spool directory listing opens
the selected QWK file (see <Open QWK File>).

3 Open QWK File

  Open the selected QWK file and import its messages into its spool. 

3 Get QWK File

  Get a QWK file for a selected spool.  This generally involves running
a user-supplied script that connects to the BBS or server in question
and downloading a QWK file.  The QWK file is then imported into the
spool.  Any out going messages are collected into a QWK reply file and
uploaded.

3 Get All QWK Files

  Get QWK files for all spools that define a QWK spool script.

3 Review Spool

  (Re-)open a spool window and load its current state.

3 Rescan

  Rescan the QWK spool directory and look for fresh QWK files.

3 Make QWK Reply

  Collect out going messages for a spool into a QWK reply file.

2 Spool Window

{SpoolWindow.gif}

Each [Spool Window] contains a menu bar, a group list, and a group level
button menu.  The file menu provides three main functions:

  * <Read Group>
  * <Post>
  * <Clean>

The group list displays the groups subscribed you are subscribed to and
also contains a saved message areas as well.

The group menu buttons include:

  * <Unread Group>
  * <Read Group>
  * <Close Group>
  * <Catch Up Group>
  * <Unsubscribe Group>
  * <Directory of all Groups>
  * <Refresh Group List>

Double clicking on a group listed in the group list does a <Read Group>
on the selected group.

When a group is open an article list button menu, an article list, and
an article button menu is added.

The article list button menu contains buttons that:

  * <Compose>
  * <List/Search Articles>
  * <Read Article>
  * <Refresh Article List>
  * <Manage Saved Articles>

Double clicking on an article in the article list does a <Read Article>
on the selected article.

The article button menu contains buttons that:

  * <Reply To All> OR <Followup>
  * <Mail Reply To Sender>
  * <Save>
  * <File>

3 Read Group

The selected group is opened and a list of available articles is shown
in the article list.

3 Post

The system opens an article edit window or starts an external editor
process. 

3 Clean

This function 'cleans' messages from a group directory.  This function
only makes sense for downloaded spools, that is QWK-based spools.

3 Unread Group

Mark all messages in the group unread.

3 Close Group

Close the group.

3 Catch Up Group

Mark all messages in the group as read.

3 Unsubscribe Group

Unsubscribe from the group.  For QWK spools this only effects TkNewsII
and you will need to log onto the BBS and update your profile there.

3 Directory of all Groups

Produce a directory listing of all known groups that match a specified
pattern. 

3 Refresh Group List

Rescan the group list, updating the message counts.

3 Compose
  See <Post>.
3 List/Search Articles

Produce a listing off all articles that match a specified pattern.

3 Read Article

Read a selected article.  An <Article Read Window> is displayed showing
the selected article

4 Article Read Window
3 Refresh Article List

Refresh the article listing.

3 Manage Saved Articles

(Only for saved articles).  A <Manage Saved Articles Menu> is displayed,

4 Manage Saved Articles Menu

3 Reply To All

For E-Mail groups, initiate a reply, using all addresses in From:,
Reply-To:, To: and Cc: header lines.

3 Followup

For groups that are not email based, reply to the newsgroup.

3 Mail Reply To Sender

Send a private E-Mail to the sender of the current article.

3 Save

Save (append) the current message to a flat file of messages.

3 File

File the current message in a saved messages directory.

2 .TkNewsRc

This is the TkNewsII resource file.  It is in standard X11 option
database format and consists of key pattern value lines.  Lines starting
with a '#' are comments.  Otherwise lines consist of option name
patterns containing either names or class names of components or window
pathname elements the wild cards (*) or periods separating these
elements.  There is a colon at the end of the pattern and there is a
value after that.

  The TkNewsII top level window has a class name of [Tknewsii], so this
should be used to introduce resources in the global X11 option database,
that is in [.Xdefaults] or [.Xresources] files.  In the [.TkNewsRc],
this is not needed.  For spool and group based resources, including the
name of the spool or group (with periods replaced with underscores) name
(all lower case) or class (first character capitalized, the rest lower
case) will specialize the resource to the specific spool or group
within the spool.  Spool windows are always children of the main
top level and group windows are always children of the spool window they
are part of.  Article read windows are also children of the spool window
as well.  More specialized resources take precedence over less
specialized resources.
 
Resources:

  Global, matched against the <MainWindow>:
  * <spoolList>
  * <autoSpools>
  * <iconic>
  * <tocGeometry>
  * <qwkInSpool>
  * <qwkOutSpool>
  * <qwkWorkDir>
  * <qwkArchiver>
  * <qwkUnarchiver>
  * <printCommand>
  Per Spool, matched against each <SpoolWindow>:
  * <qwkGetMailCommand>
  * <spoolNumGroups>
  * <activeFile>
  * <cleanFunction>
  * <newsRc>
  * <savedNews>
  * <drafts>
  * <serverName>
  * <spellChecker>
  * <externalEditor>
  * <spoolDirectory>
  * <useServer>
  * <spoolGeometry>
  * <spoolNumArticles>
  Per Group, matched against a (fake) group window:
  * <isEmail>
  * <signatureFile>
  * <followupWithXCommentTo>
  * <followupEmailTo>
  * <organization>
  * <from>
  * <ccSelf>
  * <injectProgram>
  * <emailProgram>
  Per Article, match against each <Article Read Window>
  * <articleGeometry>

  Additional general resources can be specified, such as foreground and
background colors as well as fonts and other appearance related
resources. 


3 spoolList

  Name:  spoolList
  Class: SpoolList
  Value: space separated list of spool names.
  Default: empty list.

  This is the list of defined spools.  Each spool is for a single news server
or QWK BBS.

3 autoSpools

  Name:  autoSpools
  Class: AutoSpools
  Value: space separated list of spool names.
  Default: empty list.

  This is the list of spools to load on startup.

3 iconic

  Name:  iconic
  Class: Iconic
  Value: boolean flag
  Default: 0 (false)

  This flag corresponds to the [-iconic] option.  If true, the main
window and the auto spool windows come up iconified.
3 tocGeometry

  Name:  tocGeometry
  Class: TocGeometry
  Value: X11 Geometry specification.
  Default: empty string.

  This is the initial geometry setting for the Main Window.
3 qwkInSpool

  Name:  qwkInSpool
  Class: QwkInSpool
  Value: Directory pathname.
  Default: ~/spool

  This is the directory where inbound QWK files land.
3 qwkOutSpool

  Name:  qwkOutSpool
  Class: QwkOutSpool
  Value: Directory pathname.
  Default: ~/spool

  This is the directory where outbound QWK rep files are placed.
3 qwkWorkDir

  Name:  qwkWorkDir
  Class: QwkWorkDir
  Value: Directory pathname.
  Default: ~/TkNewsWork

  This is the directory where QWK files are unpacked and processed. Also
where QWK Reply packages are built.

3 qwkArchiver

  Name:  qwkArchiver
  Class: QwkArchiver
  Value: Command line.
  Default: zip -j

  This is the command line used to create a reply file.  The name of the
reply file and the names of the files going into it are appended to this
command string.
3 qwkUnarchiver

  Name:  qwkUnarchiver
  Class: QwkUnarchiver
  Value: Command line.
  Default: unzip -jo

  This is the command line used to unpack a QWK file.  The name of the
QWK packet is appended to the command like.
3 printCommand

  Name:  printCommand
  Class: PrintCommand
  Value: Command line.
  Default: lpr -

  This is the command used to send articles to the printer.  The
articles are passed as a piped data string to stdin of this command.
3 qwkGetMailCommand

  Name:  qwkGetMailCommand
  Class: QwkGetMailCommand
  Value: Command line.
  Default: empty string.

  This is the command (script) used to fetch a QWK packet.  If empty for
a given spool, that spool does not use QWK to get articles.
3 spoolNumGroups

  Name:  spoolNumGroups
  Class: SpoolNumGroups
  Value: Integer, positive non-zero.
  Default: 20

  Number of group lines to display in the group list.
3 activeFile

  Name:  activeFile
  Class: ActiveFile
  Value: Pathname to active file.
  Default: /var/lib/news/active

  This is the name of the active file.  It is a local file in the spool
area when the spool is fed via QWK packets.  It is not used when a NNTP
server is being used.
3 cleanFunction

  Name:  cleanFunction
  Class: CleanFunction
  Value: Boolean value.
  Default: no

  If set to yes, the [clean] menu option is enabled, which allows
flushing all of the local copies of the articles in a group.  Should
only be used with QWK-based spools.
3 newsRc

  Name:  newsRc
  Class: NewsRc
  Value: File pathname.
  Default: ~/.newsrc

  This is the name of the file to keep track of read and unread articles
and subscribed groups.
3 savedNews

  Name:  savedNews
  Class: SavedNews
  Value: Directory pathname.
  Default: ~/News

  This is the directory where news articles are saved via the File
article button.
3 drafts

  Name:  drafts
  Class: Drafts
  Value: Directory pathname.
  Default: ~/Drafts

  This is the directory where unsent drafts are stored.
3 serverName

  Name:  serverName
  Class: ServerName
  Value: Hostname.
  Default: localhost

  Name of the NNTP server to use.  Only used if <useServer> is true.
3 spellChecker

  Name:  spellChecker
  Class: SpellChecker
  Value: Command line.
  Default: /usr/bin/X11/xterm -e ispell

  This is the command line to start up a spell checker.  A file name is
appended to this command.
3 externalEditor

  Name:  externalEditor
  Class: ExternalEditor
  Value: Command line.
  Default: /usr/local/bin/emacs
3 spoolDirectory

  Name:  spoolDirectory
  Class: SpoolDirectory
  Value: Directory pathname.
  Default: /var/spool/news

  This is the directory where news articles live.  Not used if
<useServer> is true.
3 useServer

  Name:  useServer
  Class: UseServer
  Value: Boolean flag.
  Default: no

  If this flag is true, news articles are fetched via a NNTP server.
3 spoolGeometry

  Name:  spoolGeometry
  Class: SpoolGeometry
  Value: X11 Geometry
  Default: empty string.

  This is the geometry of <Spool Window>s.
3 spoolNumArticles

  Name:  spoolNumArticles
  Class: SpoolNumArticles
  Value: Positive, non-zero integer.
  Default: 10

  This is the number of articles to show in the article list box.
3 isEmail

  Name:  isEmail
  Class: IsEmail
  Value: Boolean value.
  Default: no

  If set true, the group is really an E-Mail group or area.
3 signatureFile

  Name:  signatureFile
  Class: SignatureFile
  Value: File pathname.
  Default: empty string.

  This is the name of a file containing a signature or tag message.
3 followupWithXCommentTo

  Name:  followupWithXCommentTo
  Class: FollowupWithXCommentTo
  Value: Boolean value.
  Default: no

  If set to true, followups include a 'X-Comment-To:' header line
(needed / used by ifgate / fidonet echo mail).
3 followupEmailTo

  Name:  followupEmailTo
  Class: FollowupEmailTo
  Value: E-Mail address to send followups to (moderated newsgroups).
  Default: empty string.

  If not empty, followups are E-Mailed to this address instead of posted.
3 organization

  Name:  organization
  Class: Organization
  Value: String.
  Default: Yoyodyne

  This is the name of the organization to use withe the Organization:
header line.
3 from

  Name:  from
  Class: From
  Value: String.
  Default: John Bigbooty

  This is the text to include in the From: header line.
3 ccSelf

  Name:  ccSelf
  Class: CcSelf
  Value: Boolean value.
  Default: yes

  If set true, the Cc: header include your address.
3 injectProgram

  Name:  injectProgram
  Class: InjectProgram
  Value: Command line.
  Default: /usr/bin/inews -h

  This program is used to inject a news article.  The article text is
piped to this program's stdin.
3 emailProgram

  Name:  emailProgram
  Class: EmailProgram
  Value: Command line.
  Default: /usr/lib/sendmail -em -i -t

  This program is used to send an E-Mail message.  The message is piped
to this program's stdin.
3 articleGeometry

  Name:  articleGeometry
  Class: ArticleGeometry
  Value: X11 Geometry.
  Default: empty string.

  This is the geometry used for <Article Read Window>s.


