#!/usr/bin/tclsh

global ChatPort
set ChatPort 9999

global Connections

proc StartConnection {channel address clientport} {
  global Connections
  fconfigure $channel -buffering line -buffersize 2048 -translation auto
  if {[catch [list gets $channel] HELOmessage]} {
    catch "close $channel"
    return
  }
  if {[regexp {^HELO: (.*)$} "$HELOmessage" whole handle] < 1} {
    catch "close $channel"
    return
  }
  set Connections($channel) "$handle"
  fileevent $channel readable "ReadFromClient $channel"
  foreach ch [array names Connections] {
    puts $ch "$handle has joined the chat"
  }
}

proc ReadFromClient {channel} {
  global Connections
  if {[eof $channel]} {
    set left "$Connections($channel)"
    foreach ch [array names Connections] {
      if {$ch == $channel} {continue}
      puts $ch "$left has left the chat"
    }
    catch "close $channel"
    catch "unset Connections($channel)"
    return
  }
  set line "$Connections($channel): [gets $channel]"
  foreach ch [array names Connections] {
    puts $ch "$line"
  }
}

proc bgerror {message} {error $message}

socket -server StartConnection $ChatPort

vwait forever
