#!/usr/bin/wish -f
# Program: Client
# Tcl version: 8.0 (Tcl/Tk/XF)
# Tk version: 8.0
# XF version: 4.0
#

source [file join [file dirname [info script]] StdMenuBar.tcl]

global ChatPort
set ChatPort 9999

# procedure to show window .
proc MainWindow {args} {# xf ignore me 7

  # Window manager configurations
  wm positionfrom . user
  wm sizefrom . ""
  wm maxsize . 1265 994
  wm minsize . 1 1
  wm protocol . WM_DELETE_WINDOW {CarefulExit 1}
  wm title . {Tcl Chat}


  MakeStandardMenuBar

  set fm [GetMenuByName File]
  $fm entryconfigure Exit -command {CarefulExit 1}
  $fm entryconfigure Close -command {CarefulExit 1}
  $fm entryconfigure New -state disabled
  $fm entryconfigure {Open...} -state disabled
  $fm entryconfigure Save -state disabled
  $fm entryconfigure {Print...} -state disabled
  $fm entryconfigure {Save As...} -state disabled
  set em [GetMenuByName Edit]
  set lastem [$em index end]
  for {set i 0} {$i <= $lastem} {incr i} {
    $em entryconfigure $i -state disabled
  }
  set hm [GetMenuByName Help]
  set lasthm [$hm index end]
  for {set i 0} {$i <= $lasthm} {incr i} {
    $hm entryconfigure $i -state disabled
  }
  
  # build widget .textFrame
  frame .textFrame \
    -relief {raised}

  # build widget .textFrame.scrollbar1
  scrollbar .textFrame.scrollbar1 \
    -command {.textFrame.theText yview} \
    -relief {raised}

  # build widget .textFrame.theText
  text .textFrame.theText \
    -relief {sunken} \
    -wrap {word} \
    -yscrollcommand {.textFrame.scrollbar1 set}
  # bindings
  bind .textFrame.theText <Key> {break}
  

  # build widget .entryFrame
  frame .entryFrame \
    -borderwidth {2}

  # build widget .entryFrame.label1
  label .entryFrame.label1 \
    -text {Enter your message:}

  # build widget .entryFrame.message
  entry .entryFrame.message
  bind .entryFrame.message <Return> {.entryFrame.button3 invoke;break}

  # build widget .entryFrame.button3
  button .entryFrame.button3 \
    -padx {9} \
    -pady {3} \
    -text {Send} \
    -command {SendMessageToServer .entryFrame.message}

  # pack master .textFrame
  pack configure .textFrame.scrollbar1 \
    -fill y \
    -side right
  pack configure .textFrame.theText \
    -expand 1 \
    -fill both

  # pack master .entryFrame
  pack configure .entryFrame.label1 \
    -side left
  pack configure .entryFrame.message \
    -expand 1 \
    -fill x \
    -side left
  pack configure .entryFrame.button3 \
    -side right

  # pack master .
  pack configure .textFrame \
    -expand 1 \
    -fill both
  pack configure .entryFrame \
    -expand 1 \
    -fill x

  .textFrame.theText insert end {}
  .entryFrame.message insert end {}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }

  

}

wm withdraw .

global ConnectionInfo

proc MakeConnection {} {
  global ConnectionInfo argc argv argv0

# .top4
# The above line makes pasting MUCH easier for me.
# It contains the pathname of the cutted widget.
# Tcl version: 8.0 (Tcl/Tk/XF)
# Tk version: 8.0
# XF version: 4.0
#

  # build widget .top4
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top4"
  } {
    catch "destroy .top4"
  }
  toplevel .top4 

  # Window manager configurations
  wm positionfrom .top4 ""
  wm sizefrom .top4 ""
  wm maxsize .top4 1000 1000
  wm minsize .top4 10 10
  wm protocol .top4 WM_DELETE_WINDOW {.top4.buttons.button17 invoke}
  wm title .top4 {Enter chat host and your handle}


  # build widget .top4.top
  frame .top4.top \
    -borderwidth {2}

  # build widget .top4.top.label8
  label .top4.top.label8 \
    -bitmap {questhead}

  # build widget .top4.top.message9
  message .top4.top.message9 \
    -aspect {1500} \
    -padx {5} \
    -pady {2} \
    -text {Enter chat host and your handle.}

  # build widget .top4.middle
  frame .top4.middle \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .top4.middle.hostnameFrame
  frame .top4.middle.hostnameFrame \
    -borderwidth {2}

  # build widget .top4.middle.hostnameFrame.label12
  label .top4.middle.hostnameFrame.label12 \
    -text {Host:name:}

  # build widget .top4.middle.hostnameFrame.hostname
  entry .top4.middle.hostnameFrame.hostname

  # build widget .top4.middle.handleFrame
  frame .top4.middle.handleFrame \
    -borderwidth {2}

  # build widget .top4.middle.handleFrame.label14
  label .top4.middle.handleFrame.label14 \
    -text {Your handle:}

  # build widget .top4.middle.handleFrame.handle
  entry .top4.middle.handleFrame.handle

  # build widget .top4.buttons
  frame .top4.buttons \
    -borderwidth {2}

  # build widget .top4.buttons.button16
  button .top4.buttons.button16 \
    -padx {9} \
    -pady {3} \
    -text {Connect} \
    -command {global ConnectButton;set ConnectButton 1}

  # build widget .top4.buttons.button17
  button .top4.buttons.button17 \
    -padx {9} \
    -pady {3} \
    -text {Cancel} \
    -command {global ConnectButton;set ConnectButton 0}

  # pack master .top4.top
  pack configure .top4.top.label8 \
    -side left
  pack configure .top4.top.message9 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .top4.middle
  pack configure .top4.middle.hostnameFrame \
    -expand 1 \
    -fill x
  pack configure .top4.middle.handleFrame \
    -expand 1 \
    -fill x

  # pack master .top4.middle.hostnameFrame
  pack configure .top4.middle.hostnameFrame.label12 \
    -side left
  pack configure .top4.middle.hostnameFrame.hostname \
    -expand 1 \
    -fill x \
    -side right

  # pack master .top4.middle.handleFrame
  pack configure .top4.middle.handleFrame.label14 \
    -side left
  pack configure .top4.middle.handleFrame.handle \
    -expand 1 \
    -fill x \
    -side right

  # pack master .top4.buttons
  pack configure .top4.buttons.button16 \
    -expand 1 \
    -fill x \
    -side left
  pack configure .top4.buttons.button17 \
    -expand 1 \
    -fill x \
    -side right

  # pack master .top4
  pack configure .top4.top \
    -expand 1 \
    -fill x
  pack configure .top4.middle \
    -expand 1 \
    -fill both
  pack configure .top4.buttons \
    -expand 1 \
    -fill x

  if {$argc > 0} {
    .top4.middle.hostnameFrame.hostname insert end "[lindex $argv 0]"
  } else {
    .top4.middle.hostnameFrame.hostname insert end {localhost}
  }
  if {$argc > 1} {
    .top4.middle.handleFrame.handle insert end "[lindex $argv 1]"
  } else {
    global env
    if {[catch [set env(USER)] user]} {
      set user {}
    }
    .top4.middle.handleFrame.handle insert end "$user"
  }

# end of widget tree

  wm withdraw .top4
  update idletasks
  set x [expr {[winfo screenwidth .top4]/2 - [winfo reqwidth .top4]/2 \
        - [winfo vrootx .]}]
  set y [expr {[winfo screenheight .top4]/2 - [winfo reqheight .top4]/2 \
        - [winfo vrooty .]}]
  wm geom .top4 +$x+$y
  wm deiconify .top4

  set w .top4
  set oldFocus [focus]
  set oldGrab [grab current $w]
  if {$oldGrab != ""} {
      set grabStatus [grab status $oldGrab]
  }
  grab $w
  focus $w.middle.hostnameFrame.hostname
  global ConnectButton
  set ConnectButton -1
  tkwait variable ConnectButton
  catch {focus $oldFocus}
  if {$oldGrab != ""} {
      if {$grabStatus == "global"} {
            grab -global $oldGrab
      } else {
            grab $oldGrab
      }
  }

  if {$ConnectButton < 1} {exit}

  set ConnectionInfo(hostname) "[.top4.middle.hostnameFrame.hostname get]"
  set ConnectionInfo(handle) "[.top4.middle.handleFrame.handle get]"

  destroy $w

  global ChatPort

  if {[catch [list socket "$ConnectionInfo(hostname)" $ChatPort] channel]} {
    error "$argv0: MakeConnection: socket $ConnectionInfo(hostname) $ChatPort: $channel"
  }
  set ConnectionInfo(socket) $channel
  fconfigure $channel -buffering line -buffersize 2048 -translation auto
  fileevent $channel readable ReadChatLineFromServer
  puts $channel "HELO: $ConnectionInfo(handle)"
}

proc ReadChatLineFromServer {} {
  global ConnectionInfo
  if {[eof $ConnectionInfo(socket)]} {CarefulExit}
  set line "[gets $ConnectionInfo(socket)]"
  .textFrame.theText insert end "$line\n"
}

proc SendMessageToServer {entry} {
  global ConnectionInfo
  set line "[$entry get]"
  puts $ConnectionInfo(socket) "$line"
  $entry delete 0 end
}

proc CarefulExit {{ask 0}} {
  if {[tk_messageBox -default no \
		     -icon question \
		     -message {Are you sure you want to exit?} \
		     -parent . \
		     -title {Careful Edit} \
		     -type  yesno] == "no"} {return}
  global ConnectionInfo
  if {![catch [list set ConnectionInfo(socket)] socket]} {
    close $socket
  }
  exit
}

MainWindow
MakeConnection
update idletasks
set x [expr {[winfo screenwidth .]/2 - [winfo reqwidth .]/2 \
        - [winfo vrootx .]}]
set y [expr {[winfo screenheight .]/2 - [winfo reqheight .]/2 \
        - [winfo vrooty .]}]
wm geom . +$x+$y
wm deiconify .

