#* 
#* ------------------------------------------------------------------
#* PowerFrame.tcl - Power Frame
#* Created by Robert Heller on Sat Jul 28 10:15:12 2007
#* ------------------------------------------------------------------
#* Modification History: $Log: PowerFrame.tcl,v $
#* Modification History: Revision 1.1  2007/07/28 15:09:00  heller
#* Modification History: Second Lockdown
#* Modification History:
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Generic Project
#*     Copyright (C) 2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

namespace eval PowerFrame {
  snit::widget PowerFrame {
    component left
    component fill
    component state
    component userframe
    method getframe {} {return $userframe}
    typevariable plug
    typevariable notplug
    typeconstructor {
      set plug [image create photo -file [file join $::ImageDir plug.gif]]
      set notplug [image create photo -file [file join $::ImageDir notplug.gif]]
    }
    option -acpidirectory -default {} -configuremethod _ConfigureAcpidirectory \
				      -validatemethod _ValidateDirectory
    method _ConfigureAcpidirectory {option value} {
      set options($option) "$value"
      $self readstate
    }
    method _ValidateDirectory {option value} {
      if {[file exists "$value"] && [file readable "$value"] && 
	  [file isdirectory "$value"]} {
	return "$value"
      } else {
	error "Expected a readable directory for $option, got $value"
      }
    }
    option -updateinterval -default 0 -configuremethod _ConfigureUpdate \
				      -validatemethod _ValidatePosInteger
    variable updateId 0
    method _ConfigureUpdate {option value} {
      set options($option) "$value"
      if {$updateId != 0} {
	after cancel $updateId
	set updateId 0
      }
      if {$value > 0} {
	after $options($option) [mymethod _AutoUpdate]
      }
    }
    method _ValidatePosInteger {option value} {
      if {![string is integer -strict "$value"] || $value < 0} {
	error "Expected a positive integer for $option, got $value"
      }
    }
    method _AutoUpdate {} {
      $self readstate
      after $options(-updateinterval) [mymethod _AutoUpdate]
    }
    constructor {args} {
      install left using frame $win.left -borderwidth 0
      pack $left -side left -fill y -expand yes
      install state using Label $left.state -image $notplug
      pack $state
      install fill using frame $left.fill -borderwidth 0
      pack $fill -fill y -expand yes
      install userframe using frame $win.userframe
      pack $userframe -side right -fill both -expand yes
      $self configurelist $args
    }
    method readstate {} {
      if {[catch {open [file join "$options(-acpidirectory)" state] r} fp]} {
	return
      }
      set line [gets $fp]
      close $fp
      if {[regexp {^state:[[:space:]]+(on|off)-line$} "$line" -> thestate] > 0} {
	if {$thestate} {
	  $state configure -image $plug
	} else {
	  $state configure -image $notplug
	}
      }
    }
  }
}



package provide PowerFrame 1.0
