#* 
#* ------------------------------------------------------------------
#* BatteryBar.tcl - Battery Bar widget
#* Created by Robert Heller on Wed Jul 25 11:31:28 2007
#* ------------------------------------------------------------------
#* Modification History: $Log: BatteryBar.tcl,v $
#* Modification History: Revision 1.2  2007/07/28 15:09:00  heller
#* Modification History: Second Lockdown
#* Modification History:
#* Modification History: Revision 1.1  2007/07/25 16:55:59  heller
#* Modification History: Initial Version
#* Modification History:
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Generic Project
#*     Copyright (C) 2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

package require Tk
package require BWidget
package require snit

namespace eval BatteryBar {
  snit::widget BatteryBar {
    component lframe
    component state
    component percent
    component progbar
    typevariable battery
    typevariable notbattery
    typeconstructor {
      set battery [image create photo -file [file join $::ImageDir battery.gif]]
      set notbattery [image create photo -file [file join $::ImageDir notbattery.gif]]
    }
    delegate option -capacity to progbar as -maximum
    delegate option -label to lframe as -text
    option -charge -default 0 -configuremethod _ConfigureCharge \
		   -cgetmethod _CGetCharge -validatemethod _ValidateCharge
    variable _charge 0
    method _ValidateCharge {option value} {
      if {![string is integer -strict "$value"] ||
	  $value < 0} {
	error "Expected a positive integer for $option, got $value"
      }
    }
    method _ConfigureCharge {option value} {
      set _charge $value
      if {[$progbar cget -maximum] < .01} {
	$percent configure -text [format {%3d%%} 0]
      } else {
	$percent configure \
	-text [format {%3d%%} \
		      [expr {int((double($value) / 
				  double([$progbar cget -maximum]))*100)}]]
      }
    }
    method _CGetCharge {option} {return $_charge}
    option -acpidirectory -default {} -configuremethod _ConfigureAcpidirectory \
				      -validatemethod _ValidateDirectory
    method _ConfigureAcpidirectory {option value} {
      set options($option) "$value"
      $self readbatteryinfo
      $self readbatterystate
    }
    method _ValidateDirectory {option value} {
      if {[file exists "$value"] && [file readable "$value"] && 
	  [file isdirectory "$value"]} {
	return "$value"
      } else {
	error "Expected a readable directory for $option, got $value"
      }
    }
    option -updateinterval -default 0 -configuremethod _ConfigureUpdate \
				      -validatemethod _ValidatePosInteger
    variable updateId 0
    method _ConfigureUpdate {option value} {
      set options($option) "$value"
      if {$updateId != 0} {
	after cancel $updateId
	set updateId 0
      }
      if {$value > 0} {
	after $options($option) [mymethod _AutoUpdate]
      }
    }
    method _ValidatePosInteger {option value} {
      if {![string is integer -strict "$value"] || $value < 0} {
	error "Expected a positive integer for $option, got $value"
      }
    }
    method _AutoUpdate {} {
      $self readbatteryinfo
      $self readbatterystate
      after $options(-updateinterval) [mymethod _AutoUpdate]
    }
    constructor {args} {
      install lframe using LabelFrame $win.lframe -side left \
      			-font Courier
      pack $lframe -fill x
      set lff [$lframe getframe]
      install state using Label $lff.state -image $notbattery
      pack $state -side left
      install percent using Label $lff.percent -font Courier
      pack $percent -side left
      install progbar using ProgressBar $lff.progbar -orient horizontal \
						     -type normal \
						     -variable [myvar _charge]
      pack $progbar -side left -fill x -expand yes
      $self configure -capacity 1
      $self configure -charge 0
      $self configurelist $args
    }
    method setstate {chargingstate capacitystate presentstate} {
      if {!$presentstate} {
	$state configure -image $notbattery
        return
      } else {
	$state configure -image $battery
      }
      switch -exact "$chargingstate" {
	charging {
	  $progbar configure -fg green
	}
	charged {
	  $progbar configure -fg green
	}
	discharging {
	  $progbar configure -fg yellow
	}
      }
      switch -exact "$capacitystate" {
	critical {
	  $progbar configure -fg red
	}
      }
    }
    variable _infoArray -array {}
    method readbatteryinfo {} {
      set filename [file join "$options(-acpidirectory)" info]
      if {![file exists $filename]} {return}
      if {[catch {open $filename r} fp]} {return}
      array unset _infoArray
      while {[gets $fp line] >= 0} {
	if {[regexp {^([^:]+):[[:space:]]+(.*)$} "$line" -> key value] > 0} {
	  regsub -all {[[:space:]]+} "$key" {_} key
	  regsub -all {[[:space:]]+mWh$} "$value" {} value
	  regsub -all {[[:space:]]+mV$} "$value" {} value
	  regsub -all {[[:space:]]+mW$} "$value" {} value
	  set _infoArray($key) "$value"
	  if {[string equal "$key" last_full_capacity]} {
	    if {$value < 1} {
	      set value 1
	      set _infoArray($key) "$value"
	    }
	    catch {$self configure -capacity $value}
	  }
	}
      }
      close $fp
    }
    variable _stateArray -array {}
    method readbatterystate {} {
      set filename [file join "$options(-acpidirectory)" state]
      if {![file exists $filename]} {return}
      if {[catch {open $filename r} fp]} {return}
      array unset _stateArray
      set _stateArray(capacity_state) unknown
      set _stateArray(charging_state) unknown
      while {[gets $fp line] >= 0} {
	if {[regexp {^([^:]+):[[:space:]]+(.*)$} "$line" -> key value] > 0} {
	  regsub -all {[[:space:]]+} "$key" {_} key
	  regsub -all {[[:space:]]+mWh$} "$value" {} value
	  regsub -all {[[:space:]]+mV$} "$value" {} value
	  regsub -all {[[:space:]]+mW$} "$value" {} value
	  set _stateArray($key) "$value"
	  if {[string equal "$key" remaining_capacity]} {
	    catch {$self configure -charge $value}
	  }
	}
      }
      $self setstate "$_stateArray(charging_state)" "$_stateArray(capacity_state)" "$_stateArray(present)"
      close $fp
    }
  }
}




package provide BatteryBar 1.0
