#* 
#* ------------------------------------------------------------------
#* TkBattery.tcl - Tcl/Tk script to monitor /proc/acpi/battery/* and /proc/acpi/ac_adapter/*
#* Created by Robert Heller on Wed Jul 25 11:01:57 2007
#* ------------------------------------------------------------------
#* Modification History: $Log: TkBattery.tcl,v $
#* Modification History: Revision 1.2  2007/07/28 15:09:00  heller
#* Modification History: Second Lockdown
#* Modification History:
#* Modification History: Revision 1.1  2007/07/25 16:55:59  heller
#* Modification History: Initial Version
#* Modification History:
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Generic Project
#*     Copyright (C) 2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

set argv0 [info nameofexecutable]

if {![file exists /proc/acpi/battery] || 
    ![file isdirectory /proc/acpi/battery] ||
    ![file exists /proc/acpi/ac_adapter/AC/state]} {
  puts stderr "$argv0: No ACPI Battery or ac_adapter support!"
  exit 99
}

package require Tk;#                    Base GUI Toolkit
package require BWidget;#               BWidget toolkit
package require BWHelp;#                BWidget help package
package require snit;#                  Snit package

# Image Directory setup
global ImageDir 
set ImageDir [file join [file dirname [file dirname [info script]]] \
                        Common]
# Help Directory setup
global HelpDir
set HelpDir [file join [file dirname [file dirname [file dirname \
                                                        [info script]]]] Help]

package require BatteryBar
package require PowerFrame

namespace eval TkBattery {
  variable PowerFrame [PowerFrame::PowerFrame .powerFrame \
				-updateinterval 1000 \
				-acpidirectory /proc/acpi/ac_adapter/AC/]
  pack $PowerFrame -fill both -expand yes
  set frame [$PowerFrame getframe]
  
  variable BatteryBars
  foreach battery [lsort -dictionary [glob -nocomplain \
					[file join /proc/acpi/battery/ *]]] {
    set batteryname [file tail $battery]
    set BatteryBars($batteryname) [BatteryBar::BatteryBar $frame.battery$batteryname \
						-acpidirectory $battery \
						-label $batteryname\
						-updateinterval 1000]
    pack $BatteryBars($batteryname) -fill x
  }
  variable ControlMenu [menu .control -tearoff no]
  $ControlMenu add command -accelerator "Ctl-Q" -command exit \
			   -label "Quit" -underline 0
  bind all <Button-3> "::TkBattery::PostMenu %X %Y"
  bind all <Control-q> exit
  bind all <Control-Q> exit
  bind $ControlMenu <Escape> "$ControlMenu unpost"
}

proc TkBattery::PostMenu {x_Root y_Root} {
  variable ControlMenu

  $ControlMenu post $x_Root $y_Root
}
  


