#* 
#* ------------------------------------------------------------------
#* NetTrafficGraph.tcl - Net traffic Graph
#* Created by Robert Heller on Thu Dec  6 13:49:59 2007
#* ------------------------------------------------------------------
#* Modification History: $Log: headerfile.text,v $
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Generic Project
#*     Copyright (C) 2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id$

global argv0
set argv0 [info nameofexecutable]

package require Tk
package require BWidget
package require snit
package require BWHelp

namespace eval NetTrafficGraph {
  variable Status {}
  variable MainWindow [MainFrame::create .main \
	-menu {
	    "&File" {file:menu} {file} 0 {
		{command "&Add"  {file:add}  "Add Interface" {Ctrl a} 
				-command NetTrafficGraph::AddInterface}
		{command "&Delete"  {file:delete}  "Delete Interface" {Ctrl d} 
				-command NetTrafficGraph::DeleteInterface}
		{command "E&xit" {file:exit} "Exit the application" {Ctrl q} \
				-command exit}
	     }
	    "&Help" {help:menu} {help} 0 {
		{command "On &Context..." {help:context} "Help on context" {} -command BWHelp::HelpContext}
		{command "On &Help..." {help:help} "Help on help" {} -command "BWHelp::HelpTopic Help"}
		{command "On &Window..." {help:window} "Help on the current window" {} -command "BWHelp::HelpWindow"}
		{command "On &Keys..." {help:keys} "Help on keyboard accelerators" {} -command "BWHelp::HelpTopic Keys"}
		{command "&Index..." {help:index} "Help index" {} -command "BWHelp::HelpTopic Index"}
		{command "&Tutorial..." {help:tutorial} "Tutorial" {}  -command "BWHelp::HelpTopic Tutorial"}
		{command "On &Version" {help:version} "Version" {} -command "BWHelp::HelpTopic Version"}
		{command "Warranty" {help:warranty} "Warranty" {} -command "BWHelp::HelpTopic Warranty"}
		{command "Copying" {help:copying} "Copying" {} -command "BWHelp::HelpTopic Copying"}
	    }
	} \
	-textvariable NetTrafficGraph::Status \
	-progressvar no]
  pack $MainWindow -expand yes -fill both
  $MainWindow showstatusbar status
  set frame [$MainWindow getframe]
}
namespace eval NetTrafficGraph {
  snit::widget TrafficGraph {
    option -background -default black -configuremethod _ConfigureCanvasOptions
    method _ConfigureCanvasOptions {option value} {
      set options($option) $value
      catch {$graph configure $option $value}
      catch {$lframe configure $option $value}
    }
    option -transmitcolor -default red \
			  -configuremethod _ConfigureColor
    option -receivecolor  -default green \
			  -configuremethod _ConfigureColor
    option -labelcolor    -default white \
			  -configuremethod _ConfigureColor
    method _ConfigureColor {option value} {
      set options($option) $value
      catch {$graph itemconfigure color$option -fill $value}
      catch {$lframe itemconfigure color$option -fill $value}
    }
    component scrollwindow
    component   graph
    component lframe

    variable  interfaces -array {}
    variable  workid {}
    variable blipTime 0
    variable right 500
    variable lfright 100

    constructor {args} {
      install scrollwindow using ScrolledWindow::create $win.sw \
						-scrollbar vertical \
						-auto vertical
      pack $scrollwindow -expand yes -fill both -side right
      install graph using canvas $scrollwindow.graph -background black \
					-borderwidth 0 -width $right \
					-relief flat -height 0 \
					-scrollregion [list 0 0 $right 0]
      bind $graph <Configure> [mymethod _GraphResize %w]
      pack $graph -fill both
      $scrollwindow setwidget $graph
      install lframe using canvas $win.lFrame -borderwidth 0 -width $lfright \
					 -relief flat -height 0 \
					 -background black
      pack $lframe -fill y -side left -anchor n
      $self configurelist $args
    }
    method _GraphResize {newW} {
#      puts stderr "*** $self _GraphResize $newW"
      set deltaX [expr {$newW - $right}]
#      puts stderr "*** $self _GraphResize: deltaX = $deltaX"
      set right $newW
      $graph move all $deltaX 0
      set sr [$graph cget -scrollregion]
      lset sr 2 $right
      $graph configure -scrollregion $sr
      foreach d [array names interfaces *,yTransmit] {
        set maxTransmit([regsub {,yTransmit} "$d" {}]) 4000
        set maxReceive([regsub {,yTransmit} "$d" {}]) 4000
      }
      foreach i [$graph find all] {
	set tags [$graph itemcget $i -tag]
	if {[lsearch $tags Receive] >= 0} {
	  set tag Receive
	} else {
	  set tag Transmit
	}
	set iface [regsub -- "-$tag" [lsearch -inline -glob $tags "*-$tag"] {}]
	set c [$graph coords $i]
	if {[lindex $c 0] < 0} {
	  $graph delete $i
	  unset interfaces($iface,throughput$tag,$i)
	} else {
	  if {$interfaces($iface,throughput$tag,$i) > [set max${tag}($iface)]} {
	    set max${tag}($iface) $interfaces($iface,throughput$tag,$i)
	  }
	  foreach iface [array names maxTransmit] {
	    if {$maxTransmit($iface) != 0 && $maxTransmit($iface) != $interfaces($iface,maxTransmit)} {
	      set interfaces($iface,maxTransmit) $maxTransmit($iface)
	      set interfaces($iface,scaleTransmit) [expr {20.0 / double($maxTransmit($iface))}]
	      foreach i [$graph find withtag $iface-Transmit] {
		set c [$graph coords $i]
		set height [expr {double($interfaces($iface,throughputTransmit,$i)) * double($interfaces($iface,scaleTransmit))}]
		lset c 3 [expr {[lindex $c 1] - $height}]
		$graph coords $i $c
	      }
	    }
	  }
	  foreach iface [array names maxReceive] {
	    if {$maxReceive($iface) != 0 && $maxReceive($iface) != $interfaces($iface,maxReceive)} {
	      set interfaces($iface,maxReceive) $maxReceive($iface)
	      set interfaces($iface,scaleReceive) [expr {20.0 / double($maxReceive($iface))}]
	      foreach i [$graph find withtag $iface-Receive] {
		set c [$graph coords $i]
		set height [expr {double($interfaces($iface,throughputReceive,$i)) * double($interfaces($iface,scaleReceive))}]
		lset c 3 [expr {[lindex $c 1] - $height}]
		$graph coords $i $c
	      }
	    }
	  }
	}
      }
    }
    method addInterface {iface} {
      puts stderr "*** $self addInterface $iface"
      if {![catch {set interfaces($iface,yTransmit)}]} {return}
      set sr [$graph cget  -scrollregion]
      set bottom [lindex $sr 3]
      $graph configure -height $bottom
      $lframe configure -height $bottom
      puts stderr "*** $self addInterface: sr = $sr, bottom = $bottom"
      set interfaces($iface,yReceive) [expr {$bottom + 20}]
      set interfaces($iface,lastReceive) 0
      set interfaces($iface,scaleReceive) [expr {20.0 / 4000.0}]
      set interfaces($iface,maxReceive) 0
      set interfaces($iface,yTransmit) [expr {$bottom + 40}]
      set interfaces($iface,lastTransmit) 0
      set interfaces($iface,scaleTransmit) [expr {20.0 / 4000.0}]
      set interfaces($iface,maxTransmit) 0
      lset sr 3 $interfaces($iface,yTransmit)
      $graph configure -height [expr {$interfaces($iface,yTransmit) + 10}]  -scrollregion $sr
      $lframe configure -height [expr {$interfaces($iface,yTransmit) + 10}]
      $lframe create text 2 $interfaces($iface,yReceive) -anchor w\
			-text "$iface" -fill $options(-labelcolor) \
			-tags [list Label Label$iface color-labelcolor]
      $lframe create text $lfright $interfaces($iface,yReceive) -anchor se \
			-text {} -fill $options(-receivecolor) \
			-tags [list ReceiveSpeed ReceiveSpeed$iface color-receivecolor]
      $lframe create text $lfright $interfaces($iface,yTransmit) -anchor se \
			-text {} -fill $options(-transmitcolor) \
			-tags [list -TransmitSpeed TransmitSpeed$iface color-transmitcolor]
      set w [lindex [$lframe bbox all] 2]
      if {$w > [winfo width $lframe]} {$lframe configure -width $w}
      $self GetThroughPut $iface dummy1 dummy2
      puts stderr "*** $self addInterface: workid = $workid"
      if {[string equal $workid {}]} {
	$self _GetStats
      }
    }
    method deleteInterface {iface} {
      if {[catch {set interfaces($iface,yTransmit)}]} {return}
    }
    method _GetStats {} {
      set workid [after 1000 [mymethod _GetStats]]
      incr blipTime
      set devices {}
      foreach d [array names interfaces *,yTransmit] {
	lappend devices [regsub {,yTransmit} "$d" {}]
      }
#      puts stderr "*** $self _GetStats: blipTime = $blipTime, devices = $devices"
      foreach device $devices {
	$self GetThroughPut $device value1 value2
	if {$value1 < 1024} {
	  $lframe itemconfigure ReceiveSpeed$device -text "[format {%d B} $value1]"
	} elseif {$value1 < [expr {1024 * 1024}]} {
	  $lframe itemconfigure ReceiveSpeed$device -text "[format {%.1fkB} [expr {double($value1) / 1024.0}]]"
	} else {
	  $lframe itemconfigure ReceiveSpeed$device -text "[format {%.1fmB} [expr {double($value1) / (1024.0 * 1024.0)}]]"
	}
	if {$value2 < 1024} {
	  $lframe itemconfigure TransmitSpeed$device -text "[format {%d B} $value2]"
	} elseif {$value2 < [expr {1024 * 1024}]} {
	  $lframe itemconfigure TransmitSpeed$device -text "[format {%.1fkB} [expr {double($value2) / 1024.0}]]"
	} else {
	  $lframe itemconfigure TransmitSpeed$device -text "[format {%.1fmB} [expr {double($value2) / (1024.0 * 1024.0)}]]"
	}
	set height1 [expr {double($value1) * double($interfaces($device,scaleReceive))}]
	set height2 [expr {double($value2) * double($interfaces($device,scaleTransmit))}]
#	puts stderr "*** $self _GetStats: height1 = $height1, height2 = $height2"
	$graph move $device -2 0
	set y1 $interfaces($device,yReceive)
	set y2 $interfaces($device,yTransmit)
#        puts stderr "*** $self _GetStats: y1 = $y1, y2 = $y2"
	set interfaces($device,throughputReceive,[$graph create line [expr {$right - 1}] $y1 [expr {$right - 1}] [expr {$y1 - $height1}] -fill $options(-receivecolor) -tags [list $device $device-Receive Receive color-receivecolor] -width 2]) $value1
	set interfaces($device,throughputTransmit,[$graph create line [expr {$right - 1}] $y2 [expr {$right - 1}] [expr {$y2 - $height2}] -fill $options(-transmitcolor) -tags [list $device $device-Transmit Transmit color-transmitcolor] -width 2]) $value2
	set maxsend 4000
	set maxrecv 4000
#        puts stderr "*** $self _GetStats: [$graph find withtag $device] blips for $device"
	foreach i [$graph find withtag $device] {
	  set c [$graph coords $i]
#	  puts stderr "*** $self _GetStats: coords for $i = $c" 
	  set tags [$graph itemcget $i -tag]
	  if {[lsearch $tags Receive] >= 0} {
	    if {[lindex $c 0] < 0} {
	      unset interfaces($device,throughputReceive,$i)
	      $graph delete $i
	    } elseif {$interfaces($device,throughputReceive,$i) > $maxrecv} {
	      set maxrecv $interfaces($device,throughputReceive,$i)
	    }
	  } elseif {[lsearch $tags Transmit] >= 0} {
	    if {[lindex $c 0] < 0} {
	      unset interfaces($device,throughputTransmit,$i)
	      $graph delete $i
	    } elseif {$interfaces($device,throughputTransmit,$i) > $maxsend} {
	      set maxsend $interfaces($device,throughputTransmit,$i)
	    }
	  }
	}
	if {$maxsend != 0 && $maxsend != $interfaces($device,maxTransmit)} {
	  set interfaces($device,maxTransmit) $maxsend
	  set interfaces($device,scaleTransmit) [expr {20.0 / double($maxsend)}]
	  foreach i [$graph find withtag $device-Transmit] {
	    set c [$graph coords $i]
	    set height [expr {double($interfaces($device,throughputTransmit,$i)) * double($interfaces($device,scaleTransmit))}]
	    lset c 3 [expr {[lindex $c 1] - $height}]
	    $graph coords $i $c
	  }
	}
	if {$maxrecv != 0 && $maxrecv != $interfaces($device,maxReceive)} {
	  set interfaces($device,maxReceive) $maxrecv
	  set interfaces($device,scaleReceive) [expr {20.0 / double($maxrecv)}]
	  foreach i [$graph find withtag $device-Receive] {
	    set c [$graph coords $i]
	    set height [expr {double($interfaces($device,throughputReceive,$i)) * double($interfaces($device,scaleReceive))}]
	    lset c 3 [expr {[lindex $c 1] - $height}]
	    $graph coords $i $c
	  }
	}
      }
#      puts stderr "*** $self _GetStats: $graph bbox all = [$graph bbox all]"
#      puts stderr "*** $self _GetStats: $graph cget -scrollregion = [$graph cget -scrollregion]"
      $graph configure -scrollregion [$graph bbox all]
    }
    method GetThroughPut {dev receivedReturn sendReturn} {
      upvar $receivedReturn received
      upvar $sendReturn     send
      if {![info exists interfaces($dev,lastTransmit)]} {
	set  interfaces($dev,lastTransmit) 0
      }
      if {![info exists interfaces($dev,lastReceive)]} {
	set  interfaces($dev,lastReceive) 0
      }
      set received 0
      set send     0
      if {[catch [list open "/proc/net/dev" r] dfp]} {return}
      while {[gets $dfp line] >= 0} {
	if {[regexp {^[ ]*([^:]*):[ ]*([0-9]*)[ ]*[0-9]*[ ]*[0-9]*[ ]*[0-9]*[ ]*[0-9]*[ ]*[0-9]*[ ]*[0-9]*[ ]*[0-9]*[ ]*([0-9]*)} \
		"$line" -> thisDev drecv dsend] > 0} {
#	  puts stderr "$self GetThroughPut: thisDev = $thisDev, drecv = $drecv, dsend = $dsend"
	  if {[string equal "$dev" "$thisDev"]} {
	    set received [expr {$drecv - $interfaces($dev,lastReceive)}]
	    set send     [expr {$dsend - $interfaces($dev,lastTransmit)}]
	    set interfaces($dev,lastReceive) $drecv
	    set interfaces($dev,lastTransmit) $dsend
#	    puts stderr "$self GetThroughPut: dev = $dev, received = $received, send = $send"
	    break
	  }
	}
      }
      close $dfp
    }
  }
}
namespace eval NetTrafficGraph {
  variable Graph [TrafficGraph create $frame.graph]
  pack $Graph -expand yes -fill both

  snit::type SelectInterfaceDialog {
    pragma -hastypedestroy no
    pragma -hasinstances no
    pragma -hastypeinfo no

    typecomponent dialog
    typecomponent   devlbs
    typecomponent     devlb
    typecomponent   devle

    typeconstructor {
      set dialog {}
    }
    typemethod _CreateDialog {} {
      if {[string equal "$dialog" {}] ||
	  ![winfo exists $dialog]} {
	set dialog [Dialog::create .selectInterfaceDialog \
			-bitmap questhead -default 0 \
			-cancel 1 -modal local -transient yes -parent . \
			-side bottom -title {Select Interface}]
	$dialog add -name ok -text OK -command [mytypemethod _OK]
	$dialog add -name cancel -text Cancel -command [mytypemethod _Cancel]
	wm protocol [winfo toplevel $dialog] WM_DELETE_WINDOW [mytypemethod _Cancel]
	set frame [$dialog getframe]
	set devlbs [ScrolledWindow::create $frame.devlbs -scrollbar vertical \
							-auto vertical]
	pack $devlbs -expand yes -fill both
        set devlb [ListBox::create $devlbs.devlb -selectmode single]
	pack $devlb -expand yes -fill both
	$devlbs setwidget $devlb
	set devle [LabelEntry::create $frame.devle -label "Device:"]
	pack $devle -fill x
	$devlb bindText <1> [mytypemethod _ListSelect]
	$devlb bindText <Double-1> [mytypemethod _ListSelect2]
      }
    }
    typemethod draw {args} {
      $type _CreateDialog
      set parent [from args -parent .]
      set title  [from args -title .]
      set oktext [from args -oktext OK]
      $dialog configure -parent $parent -title $title
      wm transient [winfo toplevel $dialog] $parent
      $dialog itemconfigure 0 -text "$oktext"
      if {[catch {open /proc/net/dev r} devfp]} {
	error "No network interfaces!"
      }
      $devlb delete [$devlb items]
      while {[gets $devfp line] >= 0} {
	if {[regexp {^[[:space:]]*([^:]*):} "$line" => iface] > 0} {
	  $devlb insert end $iface -text $iface -data $iface
	}
      }
      close $devfp
      return [$dialog draw]
    }
    typemethod _ListSelect {item} {
      $devlb selection set $item
      $devle configure -text [$devlb itemcget $item -text]
    }
    typemethod _ListSelect2 {item} {
      $devlb selection set $item
      $devle configure -text [$devlb itemcget $item -text]
      $type _OK
    }
    typemethod _Cancel {} {
      $dialog withdraw
      return [$dialog enddialog {}]
    }
    typemethod _OK {} {
      $dialog withdraw
      return [$dialog enddialog [$devle cget -text]]
    }
  }
}

proc NetTrafficGraph::AddInterface {} {
  variable Graph

  set iface [NetTrafficGraph::SelectInterfaceDialog draw \
		-parent . -title "Select Interface To Add" -oktext Add]
  puts stderr "*** NetTrafficGraph::AddInterface: iface = $iface"
  $Graph addInterface $iface
}

proc NetTrafficGraph::DeleteInterface {} {
}


