#!/usr/bin/tclsh

global argv0

proc FormLaTeXFileName {} {
  set fn [clock format [clock scan now] -format {Invoices%b-%d-%Y-1.tex}]
  while {[file exists $fn]} {
    regexp -- {-([0-9]+)\.tex$} "$fn" whole Num
    regsub -- "-$Num\.tex\$" "$fn" "-[expr $Num + 1].tex" fn
  }
  return $fn
}

proc quoteLaTeX {string} {
  regsub -all {\$} "$string" {\\$} string
  regsub -all {&} "$string" {\\&} string
  regsub -all {#} "$string" {\\#} string
  return "$string"
}

proc PrintInvs {infp} {
  global argv0

  set LtFile [FormLaTeXFileName]
  set BaseLt [file rootname $LtFile]

  if {[catch [list open $LtFile w] LtFileFp]} {
    error "$argv0: PrintInvs: open $LtFile w: $LtFileFp"
    exit 99
  }

  puts $LtFileFp {\documentclass[12pt]{invoice}}
  puts $LtFileFp {\begin{document}}

  set numInvoices 0

  while {[gets $infp invItem] >= 0} {
    set orderid [lindex $invItem 0]
    set authno [lindex $invItem 1]
    set shippingamount [lindex $invItem 2]
    set taxamount [lindex $invItem 3]
    set totalamount [lindex $invItem 4]
    set itemlist [lindex $invItem 5]
    set ccname [lindex $invItem 6]
    set billname [lindex $invItem 7]
    set billaddr1 [lindex $invItem 8]
    set billaddr2 [lindex $invItem 9]
    set billcity [lindex $invItem 10]
    set billstate [lindex $invItem 11]
    set billcountry [lindex $invItem 12]
    set billzip [lindex $invItem 13]
    set shipname [lindex $invItem 14]
    set shipaddr1 [lindex $invItem 15]
    set shipaddr2 [lindex $invItem 16]
    set shipcity [lindex $invItem 17]
    set shipstate [lindex $invItem 18]
    set shipcountry [lindex $invItem 19]
    set shipzip [lindex $invItem 20]
    set phone [lindex $invItem 21]
    set email [lindex $invItem 22 ]
    set paymethod [lindex $invItem 23]
    set shipregion [lindex $invItem 24]
    set shipmethod [lindex $invItem 25]
    puts $LtFileFp {\begin{invoice}}
    puts $LtFileFp "\t\{$orderid\}"
    puts $LtFileFp "\t\{$shipmethod\}"
    puts -nonewline $LtFileFp "\t\{"
    puts -nonewline $LtFileFp "[quoteLaTeX $shipname]\\\\"
    puts -nonewline $LtFileFp "[quoteLaTeX $shipaddr1]\\\\"
    if {[string length "$shipaddr2"] != 0} {
      puts -nonewline $LtFileFp "[quoteLaTeX $shipaddr2]\\\\"
    }
    puts -nonewline $LtFileFp "[quoteLaTeX $shipcity],~[quoteLaTeX $shipstate]~[quoteLaTeX $shipzip]~[quoteLaTeX $shipcountry]"
    if {[string compare "$shipregion" {United States}] == 0} {
      puts -nonewline $LtFileFp " \\\\ \\ZipBarShipL\{$shipzip\}"
    }
    puts $LtFileFp "\}"
    puts -nonewline $LtFileFp "\t\{"
    puts -nonewline $LtFileFp "[quoteLaTeX $billname]\\\\"
    puts -nonewline $LtFileFp "[quoteLaTeX $billaddr1]\\\\"
    if {[string length "$billaddr2"] != 0} {
      puts -nonewline $LtFileFp "[quoteLaTeX $billaddr2]\\\\"
    }
    puts $LtFileFp "[quoteLaTeX $billcity],~[quoteLaTeX $billstate]~[quoteLaTeX $billzip]~[quoteLaTeX $billcountry]\}"

#    puts $LtFileFp {\begin{centering}}

    puts $LtFileFp "\{\\Large Invoice: Order \\# $orderid \\hfill [clock format [clock scan now] -format {%B %e, %Y}]\\\\"
    puts $LtFileFp "$ccname: ($paymethod) \\hfill $email, $phone\}\\\\\n"

#    puts $LtFileFp {\end{centering}}

#    puts $LtFileFp {\vspace*{.5in}}
    puts $LtFileFp {}

    puts $LtFileFp {\begin{tabular}{|r|r|p{3.5in}|r|r|r|}}
    puts $LtFileFp {\hline}
    puts $LtFileFp {No. & Quantity & Name & Price & Extension & Weight \\}
    puts $LtFileFp {\hline}
    puts $LtFileFp {\hline}

    set index 0
    foreach item $itemlist {
      incr index
      set id [lindex $item 0]
      set quant [lindex $item 1]
      set name [lindex $item 2]
      set descr [lindex $item 3]
      set price [lindex $item 4]
      set weight [lindex $item 5]
      puts $LtFileFp "$index. & $quant & [quoteLaTeX $name] & \n\
[format {%4.2f} $price] & [format {%4.2f} [expr $price * $quant]] & \n\
[format {%4.2f} $weight] \\\\"
      puts $LtFileFp {\hline}
    }

    set subtotal [expr $totalamount - ($taxamount + $shippingamount)]
    puts $LtFileFp "\\multicolumn{4}{|r|}{Subtotal} & [format {%4.2f} $subtotal] & \\\\"
    puts $LtFileFp {\hline}
    puts $LtFileFp "\\multicolumn{4}{|r|}{Tax} & [format {%4.2f} $taxamount] & \\\\"
    puts $LtFileFp {\hline}
    puts $LtFileFp "\\multicolumn{4}{|r|}{Shipping} & [format {%4.2f} $shippingamount] & \\\\"
    puts $LtFileFp {\hline}
    puts $LtFileFp "\\multicolumn{4}{|r|}{Total} & [format {%4.2f} $totalamount] & \\\\"
    puts $LtFileFp {\hline}


    puts $LtFileFp {\end{tabular}}


    puts $LtFileFp {}
    puts $LtFileFp {Deepwoods Software can be contacted at billing@deepsoft.com
or 1-978-544-6933.  Please be sure to read the printed instructions that are
included with your purchase.}


    puts $LtFileFp {\end{invoice}}
    incr numInvoices
  }

  puts $LtFileFp {\end{document}}

  close $LtFileFp

  if {$infp != {stdin}} {close $infp}

  if {$numInvoices == 0} {
    catch [file delete -force $BaseLt.tex]
    puts "No Invoices generated."
    return
  } elseif {$numInvoices == 1} {
    puts "1 Invoice generated \[$BaseLt\]."
  } else {
    puts "$numInvoices Invoices generated \[$BaseLt\]."
  }

  if {[catch [list exec latex $BaseLt] error]} {
    error "$argv0: PrintInvs: latex $BaseLt: $error"
    exit 98
  }

  catch [file delete -force $BaseLt.aux]
  catch [file delete -force $BaseLt.log]

  catch [list exec dvips $BaseLt -o] error
  catch [file delete -force $BaseLt.dvi]

  if {[catch [list exec lpr -Pcolor $BaseLt.ps] error]} {
    error "$argv0: PrintInvs: lpr -Pcolor $BaseLt.ps: $error"
    exit 96
  }

  catch [file delete -force $BaseLt.ps]

}



PrintInvs stdin
