#!/usr/bin/pgtclsh

global argv0

if {[catch {pg_connect deepwoodsvarying} conn]} {
  error "$argv0: pg_connect deepwoodsvarying: $conn"
}

pg_select $conn "SELECT * from Orders where OrderState = 'ShipPend'" order {
  set record {}
  foreach f {orderid authno shippingamount taxamount totalamount itemlist 
	     ccname billname billaddr1 billaddr2 billcity billstate 
	     billcountry billzip shipname shipaddr1 shipaddr2 shipcity 
	     shipstate shipcountry shipzip phone email paymethod shipregion 
	     shipmethod} {
    lappend record "$order($f)"
  }
  set Q "update orders set OrderState = 'ShipPendA' where orderid = $order(orderid)"
  if {[catch [list pg_exec $conn "$Q"] qr]} {
    set message "$qr"
    pg_disconnect $conn
    error "pg_exec $conn $Q: $message"
  } elseif {[string compare "[pg_result $qr -status]" "PGRES_COMMAND_OK"] != 0} {
    set message "[pg_result $qr -status]"
    pg_result $qr -clear
    pg_disconnect $conn
    error "pg_exec $conn \{$Q\}: $message"
  }
  pg_result $qr -clear
  puts "$record"
}

pg_disconnect $conn


