#/bin/sh
# \
exec wish -f $0 $*

# module inclusion
global env
global xfLoadPath
if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) /usr/local/lib/] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):/usr/local/lib/
  } {
    set xfLoadPath /usr/local/lib/
  }
} {
  set xfLoadPath /usr/local/lib/
}

global SourceDirectory 
set SourceDirectory [file dirname [info script]]

global argc
global argv
global tkVersion
global xfLoadInfo
global xfLoadPath
set xfLoadInfo 0
set tmpArgv ""
for {set counter 0} {$counter < $argc} {incr counter 1} {
  case [string tolower [lindex $argv $counter]] in {
    {-xfloadpath} {
      incr counter 1
      set xfLoadPath "[lindex $argv $counter]:$xfLoadPath"
    }
    {-xfstartup} {
      incr counter 1
      source [lindex $argv $counter]
    }
    {-xfbindfile} {
      incr counter 1
      set env(XF_BIND_FILE) "[lindex $argv $counter]"
    }
    {-xfcolorfile} {
      incr counter 1
      set env(XF_COLOR_FILE) "[lindex $argv $counter]"
    }
    {-xfcursorfile} {
      incr counter 1
      set env(XF_CURSOR_FILE) "[lindex $argv $counter]"
    }
    {-xffontfile} {
      incr counter 1
      set env(XF_FONT_FILE) "[lindex $argv $counter]"
    }
    {-xfmodelmono} {
      if {$tkVersion >= 3.0} {
        tk colormodel . monochrome
      }
    }
    {-xfmodelcolor} {
      if {$tkVersion >= 3.0} {
        tk colormodel . color
      }
    }
    {-xfloading} {
      set xfLoadInfo 1
    }
    {-xfnoloading} {
      set xfLoadInfo 0
    }
    {default} {
      lappend tmpArgv [lindex $argv $counter]
    }
  }
}
set argv $tmpArgv
set argc [llength $tmpArgv]
unset counter
unset tmpArgv


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  global SourceDirectory 
  set screenheight [winfo screenheight .]
  set screenwidth  [winfo screenwidth .]

  # Window manager configurations
  global tkVersion
  wm positionfrom . user
  wm sizefrom . ""
  wm maxsize . $screenwidth $screenheight
  wm title . {Fish}


  # build widget .button0
  button .button0 \
    -command {exit}\
    -text {Exit}

  # build widget .frame0
  frame .frame0 \
    -relief {raised}

  # build widget .frame0.scrollbar1
  scrollbar .frame0.scrollbar1 \
    -command {.frame0.canvas2 yview}\
    -relief {raised}

  # build widget .frame0.scrollbar3
  scrollbar .frame0.scrollbar3 \
    -command {.frame0.canvas2 xview}\
    -orient {horizontal}\
    -relief {raised}

  # build widget .frame0.canvas2
  canvas .frame0.canvas2 \
    -height {300}\
    -insertofftime {600}\
    -relief {raised}\
    -scrollregion [list 0 0 [expr $screenwidth - 30] [expr $screenheight - 60]]\
    -width {400}\
    -background {blue}\
    -xscrollcommand {.frame0.scrollbar3 set}\
    -yscrollcommand {.frame0.scrollbar1 set} \
    -cursor [list @[file join $SourceDirectory pengBW.xbm] [file join $SourceDirectory pengMask.xbm] black white]
  # build canvas items .frame0.canvas2

  # pack widget .frame0
  pack append .frame0 \
    .frame0.scrollbar1 {right frame center filly} \
    .frame0.canvas2 {top frame center expand fill} \
    .frame0.scrollbar3 {top frame center fillx} 

  # pack widget .
  pack append . \
    .frame0 {top frame center expand fill} \
    .button0 {top frame center fill} 

  if {"[info procs XFEdit]" != ""} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .xfEdit
  }
}


# User defined procedures

# Procedure: CreateFish
proc CreateFish {numFish} {
  global Fish
  set scrollregion [lindex [[SN Tank] configure -scrollregion] 4]
  set xbase [expr [lindex $scrollregion 0] + 50]
  set ybase [expr [lindex $scrollregion 1] + 50]
  set xmax  [expr [lindex $scrollregion 2] - 50]
  set ymax  [expr [lindex $scrollregion 3] - 50]
  set height [expr $ymax - $ybase]
  set width [expr $xmax - $xbase]
  for {set ifish 0} {$ifish < $numFish} {incr ifish} {
    set fish [NewFish $ifish [Random 5] [expr [Random $width] + $xbase] \
    				     [expr [Random $height] + $ybase] \
				     [Random 2]]
    [SN Tank] bind fish$ifish <1> "EatFish %W %x %y fish$ifish"
    lappend Fish $fish
  }
}

proc PutWord {canvas mx my word color} {
  set cx [$canvas canvasx $mx]
  set cy [$canvas canvasy $my]
  set id [$canvas create text $cx $cy -text $word -fill $color \
		-font {Helvetica -25 bold}]
  $canvas raise $id
  after 10000 "$canvas delete $id"
}

proc RemoveFish {tag} {
  global Fish
  set index [lsearch -regexp $Fish "^$tag"]
  if {$index < 0} {return}
  set Fish [lreplace $Fish $index $index]
  [SN Tank] delete $tag
  return [llength $Fish]
}

global Yummy
set Yummy {
	{I like fish}
	{Yummy!}
	{Lets go find another fish!}
	{Fish are tasty!}
}

proc EatFish {canvas mx my tag} {
  global Yummy
  set cx [$canvas canvasx $mx]
  set cy [$canvas canvasy $my]
  set YI [expr [Random [llength $Yummy]] - 1]
  set id [$canvas create text $cx $cy -text [lindex $Yummy $YI] -fill orange \
	     -font {Helvetica -25 bold}]
  $canvas raise $id
  after 10000 "$canvas delete $id"
  if {[RemoveFish $tag] == 0} {
    set id [$canvas create text 20 20 \
		-anchor nw -text {All the fish have been eaten. More will be along soon.} \
		-fill yellow -font [font create -size -30 -weight bold]]
    after 10000 "$canvas delete $id"
    update
    CreateFish [expr 10 + [Random 20]]
  }
}
  

# Procedure: MoveFish
proc MoveFish {} {
  set canvas [SN Tank]
  global Fish
  set numFish [llength $Fish]
  for {set ifish 0} {$ifish < $numFish} {incr ifish} {
    set fish    [lindex $Fish $ifish]
    set tag     [lindex $fish 0]
    set dx      [lindex $fish 1]
    set y       [lindex $fish 2]
    set creator [lindex $fish 3]
    set delta [expr $dx / 1.0]
    $canvas move $tag $delta 0
    set coords [$canvas bbox $tag]
    set left  [lindex $coords 0]
    set right [lindex $coords 2]
    set fwidth [expr $right - $left]
    set hwidth [expr $fwidth / 2.0]
    set scrollregion [lindex [$canvas configure -scrollregion] 4]
    set xbase [lindex $scrollregion 0]
    set xmax  [lindex $scrollregion 2]
    if {$dx < 0} {
      if {$left <= $xbase} {
	$canvas delete $tag
	set new [$creator $tag [expr $xbase + $hwidth] $y 1]
        set Fish [lreplace $Fish $ifish $ifish $new]
      }
    } else {
      if {$right >= $xmax} {
	$canvas delete $tag
	set new [$creator $tag [expr $xmax - $hwidth] $y 2]
        set Fish [lreplace $Fish $ifish $ifish $new]
      }
    }
    if {$ifish > 0} {
      $canvas lower $tag [lindex [lindex $Fish [expr $ifish - 1]] 0]
    }
  }
  after 100 MoveFish
}

# Procedure: NewFish
proc NewFish {index type x y leftright} {
  case $type in {
    {1} {
      return [RedFish "fish$index" $x $y $leftright]
    }
    {2} {
      return [GreenFish "fish$index" $x $y $leftright]
    }
    {3} {
      return [BlackFish "fish$index" $x $y $leftright]
    }
    {4} {
      return [YellowFish "fish$index" $x $y $leftright]
    }
    {5} {
      return [WhiteFish "fish$index" $x $y $leftright]
    }
  }
}

# Procedure: RedFish
proc RedFish {tag x y leftright} {
  set taglist [list $tag RedFish]
  set canvas [SN Tank]
  $canvas create oval [expr $x - 30] [expr $y - 10] \
		      [expr $x + 30] [expr $y + 10] \
		      -outline black -fill red -tags $taglist
  if {$leftright == 2} {
    set eyex [expr $x - 25]
    set tailx [expr $x + 30]
    set taildx 5
    set dorselx -5
    set dx -10
  } else {
    set eyex [expr $x + 25]
    set tailx [expr $x - 30]
    set taildx -5
    set dx 10
    set dorselx 5
  }
  $canvas create oval  [expr $eyex - 2] [expr $y - 2] \
		       [expr $eyex + 2] [expr $y + 2] \
		       -outline {} -fill black -tags $taglist
  $canvas create polygon $x [expr $y - 8] \
  			 $x [expr $y - 18] \
			 [expr $x + $dorselx] [expr $y - 8] \
			 $x [expr $y - 8] \
			 -fill red -tags $taglist
  $canvas create polygon $tailx $y \
			 [expr $tailx + $taildx] [expr $y - 5] \
			 [expr $tailx + $taildx] [expr $y + 5] \
			 $tailx $y \
			 -fill red -tags $taglist
  return [list $tag $dx $y RedFish]
}

# Procedure: GreenFish
proc GreenFish {tag x y leftright} {
  set taglist [list $tag GreenFish]
  set canvas [SN Tank]
  $canvas create oval [expr $x - 40] [expr $y - 15] \
		      [expr $x + 40] [expr $y + 15] \
		      -outline black -fill green -tags $taglist
  if {$leftright == 2} {
    set eyex [expr $x - 35]
    set tailx [expr $x + 40]
    set taildx 8
    set dx -10
    set dorselx -8
  } else {
    set eyex [expr $x + 35]
    set tailx [expr $x - 40]
    set taildx -8
    set dx 10
    set dorselx 8
  }
  $canvas create oval  [expr $eyex - 3] [expr $y - 3] \
		       [expr $eyex + 3] [expr $y + 3] \
		       -outline {} -fill black -tags $taglist
  $canvas create polygon $x [expr $y - 13] \
  			 $x [expr $y - 28] \
			 [expr $x + $dorselx] [expr $y - 13] \
			 $x [expr $y - 13] \
			 -fill green -tags $taglist
  $canvas create polygon $tailx $y \
			 [expr $tailx + $taildx] [expr $y - 8] \
			 [expr $tailx + $taildx] [expr $y + 8] \
			 $tailx $y \
			 -fill green -tags $taglist
  return [list $tag $dx $y GreenFish]
}

# Procedure: BlackFish
proc BlackFish {tag x y leftright} {
  set taglist [list $tag BlackFish]
  set canvas [SN Tank]
  $canvas create oval [expr $x - 30] [expr $y - 10] \
		      [expr $x + 30] [expr $y + 10] \
		      -outline white -fill black -tags $taglist
  if {$leftright == 2} {
    set eyex [expr $x - 25]
    set tailx [expr $x + 30]
    set taildx 5
    set dorselx -5
    set dx -10
  } else {
    set eyex [expr $x + 25]
    set tailx [expr $x - 30]
    set taildx -5
    set dorselx 5
    set dx 10
  }
  $canvas create oval  [expr $eyex - 2] [expr $y - 2] \
		       [expr $eyex + 2] [expr $y + 2] \
		       -outline red -fill white -tags $taglist
  $canvas create polygon $x [expr $y - 8] \
  			 $x [expr $y - 18] \
			 [expr $x + $dorselx] [expr $y - 8] \
			 $x [expr $y - 8] \
			 -fill black -tags $taglist
  $canvas create polygon $tailx $y \
			 [expr $tailx + $taildx] [expr $y - 5] \
			 [expr $tailx + $taildx] [expr $y + 5] \
			 $tailx $y \
			 -fill black -tags $taglist
  return [list $tag $dx $y BlackFish]
}

# Procedure: YellowFish
proc YellowFish {tag x y leftright} {
  set taglist [list $tag YellowFish]
  set canvas [SN Tank]
  $canvas create oval [expr $x - 30] [expr $y - 10] \
		      [expr $x + 30] [expr $y + 10] \
		      -outline black -fill yellow -tags $taglist
  if {$leftright == 2} {
    set eyex [expr $x - 25]
    set tailx [expr $x + 30]
    set taildx 5
    set dorselx -5
    set dx -10
  } else {
    set eyex [expr $x + 25]
    set tailx [expr $x - 30]
    set taildx -5
    set dorselx 5      
    set dx 10
  }
  $canvas create oval  [expr $eyex - 2] [expr $y - 2] \
		       [expr $eyex + 2] [expr $y + 2] \
		       -outline red -fill green -tags $taglist
  $canvas create polygon $x [expr $y - 8] \
  			 $x [expr $y - 18] \
			 [expr $x + $dorselx] [expr $y - 8] \
			 $x [expr $y - 8] \
			 -fill yellow -tags $taglist
  $canvas create polygon $tailx $y \
			 [expr $tailx + $taildx] [expr $y - 5] \
			 [expr $tailx + $taildx] [expr $y + 5] \
			 $tailx $y \
			 -fill yellow -tags $taglist
  return [list $tag $dx $y YellowFish]
}

# Procedure: WhiteFish
proc WhiteFish {tag x y leftright} {
  set taglist [list $tag WhiteFish]
  set canvas [SN Tank]
  $canvas create oval [expr $x - 100] [expr $y - 20] \
		      [expr $x + 100] [expr $y + 20] \
		      -outline grey -fill white -tags $taglist
  if {$leftright == 2} {
    set eyex [expr $x - 85]
    set tailx [expr $x + 100]
    set taildx 30
    set dorselx -20 
    set dx -50
  } else {
    set eyex [expr $x + 85]
    set tailx [expr $x - 100]
    set taildx -30
    set dorselx 20
    set dx 50
  }
  $canvas create oval  [expr $eyex - 5] [expr $y - 5] \
		       [expr $eyex + 5] [expr $y + 5] \
		       -outline {} -fill black -tags $taglist
  $canvas create polygon $x [expr $y - 18] \
  			 $x [expr $y - 40] \
			 [expr $x + $dorselx] [expr $y - 18] \
			 $x [expr $y - 18] \
			 -fill white -tags $taglist
  $canvas create polygon $tailx $y \
			 [expr $tailx + $taildx] [expr $y - 10] \
			 [expr $tailx + $taildx] [expr $y + 10] \
			 $tailx $y \
			 -fill white -tags $taglist
  return [list $tag $dx $y WhiteFish]
}


# Procedure: Random
proc Random { {N "0.0"}} {
  global RanVar
  set RanVar [expr int($RanVar * 4676) % 414971]
  set random [expr $RanVar / 414971.0]
  if {$N == 0.0} {
    return $random
  } else {
    return [expr int($random * $N) + 1]
  }
}

# Internal procedures


# Procedure: Alias
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########

  if {"$xfModifier" != ""} {
    set xfPressModifier "$xfModifier-"
    set xfMoveModifier "$xfModifier-"
    set xfReleaseModifier "Any-"
  } {
    set xfPressModifier ""
    set xfMoveModifier ""
    set xfReleaseModifier ""
  }

  if {"$xfCanvasTag" == ""} {
    if {[catch "bind $xfW \"<${xfPressModifier}ButtonPress-$xfButton>\"  \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "bind $xfW \"<${xfMoveModifier}B$xfButton-Motion>\"  \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "bind $xfW \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"  \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  } {
    if {[catch "$xfW bind $xfCanvasTag \"<${xfPressModifier}ButtonPress-$xfButton>\"  \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "$xfW bind $xfCanvasTag \"<${xfMoveModifier}B$xfButton-Motion>\"  \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "$xfW bind $xfCanvasTag \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"  \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  }
}
}


# Procedure: MenuPopupHandle
if {"[info procs MenuPopupHandle]" == ""} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupHandle
# Description: handle the popup menus
# Arguments: xfMenu - the menu to attach
#            xfW - the widget
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########

  if {"[info commands $xfMenu]" != "" && [winfo ismapped $xfMenu]} {
    set xfPopMinX [winfo rootx $xfMenu]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfMenu]]
    if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
      $xfMenu activate @[expr $xfY-[winfo rooty $xfMenu]]
    } {
      $xfMenu activate none
    }
  }
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}



# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        set xfAppDefaults($widname:[string tolower $name]) $value
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {xfClasses {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter [array names xfAppDefaults] {
    if {[string match "${xfWidgetPath}*" $xfCounter]} {
      set widname [string range $xfCounter 0 [expr [string first : $xfCounter]-1]]
      set name [string range $xfCounter [expr [string first : $xfCounter]+1] end]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"]} {
            catch "$widget configure -[string tolower $name] $xfAppDefaults($xfCounter)" 
          }
        }
      }
    }
  }
}

proc striplzeros {x} {
  regsub {^0*([0-9]+)} "$x" {\1} out
  return $out
}

proc mapstriplzeros {list} {
  set result {}
  foreach x $list {lappend result [striplzeros $x]}
  return $result
}

# end source
proc EndSrc {} {
  global RanVar
  set dtlist [mapstriplzeros \
		[clock format [clock scan now] -format {%y %e %d %H %M %S}]]
  set RanVar [expr int([eval [list expr [join $dtlist "+"]]])]
  CreateFish [expr 10 + [Random 20]]
  set canvas [SN Tank]
  set id [$canvas create text 20 20 \
	-anchor nw -text {Tux is hungry.  Help him catch some fish.} -fill yellow \
	-font [font create -size -30 -weight bold]]
  after 60000 "$canvas delete $id"
  MoveFish
}

# prepare auto loading
global auto_path
global tk_library
global xfLoadPath
set auto_path "[split $xfLoadPath :] $tk_library [info library]"

# initialize global variables
proc InitGlobals {} {

  global {RanVar}
  set {RanVar} {1}
  global {Fish}
  set {Fish} {}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(Fish)} {0}
  set {autoLoadList(main.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(Fish)} {}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(Tank)} {.frame0.canvas2}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs Fish
XFLocalSetAppDefs

# end source
EndSrc

# eof
#

