#* 
#* ------------------------------------------------------------------
#* RecordPage.tcl - Record Page
#* Created by Robert Heller on Mon Feb 26 16:25:58 2007
#* ------------------------------------------------------------------
#* Modification History: $Log: headerfile.text,v $
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Generic Project
#*     Copyright (C) 2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

#**************************************************************************
#*                                                                        *
#* Record Page widgetadaptor -- A notebook page that holds a record (row) *
#* of an address record (row).  This page is optionally editable.         *
#*                                                                        *
#**************************************************************************

namespace eval RecordPage {
  #***********************************
  # Record Page widgetadaptor
  #***********************************
  snit::widgetadaptor RecordPage {
    # Options:
    option -row -readonly yes;#			The row to display or edit
    option -connection -readonly yes;#		The database connection
    option -edit -readonly yes -default no;#	Editable flag
    option -notebook -readonly yes;#		The parent notebook
    option -ident -readonly yes;#		The page identification

    # Components:
    component nameLF;#			Name Label Frame
    component   salutationCB;#		Salutation Combo Box
    component   firstnameE;#		First name Entry
    component   lastnameE;#		Last name Entry
    component   suffixE;#		Suffix Entry
    component organizationLE;#		Organization Label Entry
    component address1LE;#		Address Line 1 Label Entry
    component address2LE;#		Address Line 2 Label Entry
    component cityE;#			City Entry
    component stateCB;#			State Combo Box
    component zipE;#			Zipcode Entry
    component phoneLE;#			Telephone Label Entry
    component faxLE;#			Fax Label Entry
    component updateB;#			Update Button
    component closeB;#			Close Button
    # Type variables:
    typevariable _labelWidth 15;#	Standard label width
    typevariable _RecordPages {};# 	List of pages
    # Instance variables:
    variable update {};#		Update statement object

    #***********************************
    # Constructor -- create all GUI components
    #***********************************
    constructor {args} {
      installhull $self
      $self configurelist $args
      install nameLF using LabelFrame::create $win.nameLF \
				-text {Name:} \
				-width $_labelWidth
      pack $nameLF -fill x
      if {$options(-edit)} {
        install salutationCB using \
			ComboBox::create [$nameLF getframe].salutationCB \
			-values $::DatabaseWidgets::Salutations \
			-editable no -text "[lindex $options(-row) 1]" \
			-width 6
      } else {
	install salutationCB using \
			Entry::create [$nameLF getframe].salutationCB \
			-editable no -text "[lindex $options(-row) 1]" \
			-width 6
      }
      pack $salutationCB -side left
      install firstnameE using Entry::create [$nameLF getframe].firstnameE \
				-editable $options(-edit) \
				-text "[lindex $options(-row) 2]"
      pack $firstnameE -fill x -side left -expand yes
      install lastnameE using Entry::create [$nameLF getframe].lastnameE \
				-editable $options(-edit) \
				-text "[lindex $options(-row) 3]"
      pack $lastnameE -fill x -side left -expand yes
      install suffixE using Entry::create [$nameLF getframe].suffixE \
				-editable $options(-edit) \
				-text "[lindex $options(-row) 4]" \
				-width 10
      pack $suffixE -fill x -side right
      install organizationLE using LabelEntry::create $win.organizationLE \
				-label {organization:} \
				-labelwidth $_labelWidth \
				-editable $options(-edit) \
				-text "[lindex $options(-row) 5]"
      pack $organizationLE -fill x
      install address1LE using LabelEntry::create $win.address1LE \
				-label {Address 1:} \
				-labelwidth $_labelWidth \
				-editable $options(-edit) \
				-text "[lindex $options(-row) 6]"
      pack $address1LE -fill x
      install address2LE using LabelEntry::create $win.address2LE \
				-label {Address 2:} \
				-labelwidth $_labelWidth \
				-editable $options(-edit) \
				-text "[lindex $options(-row) 7]"
      pack $address2LE -fill x
      set citystatezip [LabelFrame::create $win.citystatezip \
				-text {City, State, Zip:} \
				-width $_labelWidth]
      pack $citystatezip -fill x
      set citystatezipF [$citystatezip getframe]
      install cityE using Entry::create $citystatezipF.cityE\
				-editable $options(-edit) \
				-text "[lindex $options(-row) 8]"
      pack $cityE -fill x -side left -expand yes
      if {$options(-edit)} {
        install stateCB using ComboBox::create $citystatezipF.stateCB \
						-editable no \
						-values $::DatabaseWidgets::AllStates \
						-text "[lindex $options(-row) 9]" \
						-width 3
      } else {
	install stateCB using Entry::create $citystatezipF.stateCB \
						-editable no \
						-text "[lindex $options(-row) 9]" \
						-width 3
      }
      pack $stateCB -side left
      install zipE using Entry::create $citystatezipF.zipE\
				-editable $options(-edit) \
				-text "[lindex $options(-row) 10]" \
				-width 10
      pack $zipE -fill x -side left
      install phoneLE using LabelEntry::create $win.phoneLE \
				-label {Telephone:} \
				-labelwidth $_labelWidth \
				-editable $options(-edit) \
				-text "[lindex $options(-row) 11]"
      pack $phoneLE -fill x
      install faxLE using LabelEntry::create $win.faxLE \
				-label {Fax:} \
				-labelwidth $_labelWidth \
				-editable $options(-edit) \
				-text "[lindex $options(-row) 12]"
      pack $faxLE -fill x
      # If editable, create update statement and include update button.
      if {$options(-edit)} {
	set update [$options(-connection) statement [DatabaseWidgets::statementID create] \
		"update addresses set salutation = ?, firstname = ?, \
				      lastname = ?, suffix = ?, \
				      organization = ?, address1 = ?, \
				      address2 = ?, city = ?, state = ?, \
				      zip = ?, telephone = ?, fax = ? \
			where id = [lindex $options(-row) 0]" \
		 {CHAR CHAR CHAR CHAR CHAR CHAR CHAR CHAR CHAR CHAR CHAR CHAR}]
	install updateB using Button::create $win.updateB \
				-text Update \
				-command [mymethod _Update]
	pack $updateB -fill x
      }
      install closeB using Button::create $win.closeB \
      				-text Close \
				-command "destroy $win"
      pack $closeB -fill x
      # Make ourselves visible
      $options(-notebook) raise $options(-ident)
      $options(-notebook) see   $options(-ident)
      lappend _RecordPages $self
    }
    #***********************************
    # _Update method -- update record (row)
    #***********************************
    method _Update {} {
      set arglist {}
      lappend arglist "[$salutationCB cget -text]"
      lappend arglist "[$firstnameE cget -text]"
      lappend arglist "[$lastnameE cget -text]"
      lappend arglist "[$suffixE cget -text]"
      lappend arglist "[$organizationLE cget -text]"
      lappend arglist "[$address1LE cget -text]"
      lappend arglist "[$address2LE cget -text]"
      lappend arglist "[$cityE cget -text]"
      lappend arglist "[$stateCB cget -text]"
      lappend arglist "[$zipE cget -text]"
      lappend arglist "[$phoneLE cget -text]"
      lappend arglist "[$faxLE cget -text]"
      $update run $arglist
    }
    #***********************************
    # Destructor -- clean things up
    #***********************************
    destructor {
#      puts stderr "*** $self destroy"
      catch {$update drop}
      set update {}
      set index [lsearch $_RecordPages $self]
      if {$index == 0} {
	set _RecordPages [lrange $_RecordPages 1 end]
      } elseif {$index > 0} {
	set _RecordPages [lreplace $_RecordPages $index $index]
      }
#      parray options
      set nb $options(-notebook)
      $nb delete $options(-ident)
#      puts stderr "*** $self destroy: notebook delete completed"
      set last [$nb pages end]
      $nb raise $last
      $nb see   $last
    }
    #***********************************
    # Typemethod to clear out all open pages.
    #***********************************
    typemethod closeallpages {} {
      foreach page $_RecordPages {
	catch {$page destroy}
      }
    }
  }
}


package provide RecordPage 1.0
