#* 
#* ------------------------------------------------------------------
#* Reference.hh - Reference manual
#* Created by Robert Heller on Tue Mar  6 16:45:22 2007
#* ------------------------------------------------------------------
#* Modification History: $Log: headerfile.text,v $
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Generic Project
#*     Copyright (C) 2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#*
0 Keys
The keyboard shortcuts defined for the DirectMailTk program are:

    Key         Menu Item                      Function  
    ------------------------------------------------------------------
    Ctrl-i      <File>-><Initialize DB>            Initialize the database
    Ctrl-o      <File>-><Open...>                  Open A connection to a database
    Ctrl-Alt-c  <File>-><Export>-><As CSV...>        Export to CSV format
    Ctrl-Alt-e  <File>-><Export>-><As LaTeX ENVs>    Export to LaTeX Envelope (env.sty) format
    Ctrl-Alt-l  <File>-><Export>-><As LaTeX Letters> Export to LaTeX Letter (letter class) format
    Ctrl-p      <File>-><Print...>                 Print Labels
    Ctrl-q      <File>-><Exit>                     Quit the program
0 Version
This is version 0.0
0 Main Window
  The main window contains these parts:

  <Menu Bar>
  <Toolbar>
  <Notebook>
1 Menu Bar
  There are five menus on the menu bar:

  <File> <Edit> <View> <Options> <Help>
2 File
  The File menu has nine items:

  New             Not presently implemented
  <Initialize DB>   Initialize the database
  <Open...>         Open A connection to a database
  Save            Not presently implemented
  Save As...      Not presently implemented
  <Export>          Export rows to various formats
  <Print...>        Print labels
  <Close>           (See <Exit>)
  <Exit>            Exit the program
3 Initialize DB
  Initialize the database.  This creates a new [addresses] table.  If
there is already an [addresses] table, the initializeation is confirmed.
3 Open...
  Open A connection to a database.  A database connection string dialog
is presented to get the information needed to open a database connection.
3 Export
  There are three export formats defined:

  <As CSV...>         As a Comma Separated Value file
  <As LaTeX ENVs>     As a LaTeX file of envelopes (using the env.sty file)
  <As LaTeX Letters>  As a LaTeX Letters file (using the letters class)
4 As CSV...
  Export to CSV format.  A dialog box is displayed giving search
options.  The output file will have one row (record) per line, with the
fields separated by commas.  Field values with embeded commas will be
enclosed in double quote marks.
and a place to specify the output file.
4 As LaTeX ENVs
  Export to LaTeX Envelope (env.sty) format.  A dialog box is displayed giving search options
and a place to specify the output file.  The
selected rows, as selected by the search criteria, are output to a LaTeX
file using the env style file as envelope environments.  The name of the
output LaTeX can be specified.
4 As LaTeX Letters
  Export to LaTeX Letter (letter class) format.  A dialog box is displayed giving search options
and a place to specify the output file and the name of a form letter
template file. The form letter template file contains a LaTeX preamble
(which in inserted between the \\documentclass and \\begin\{document\}
lines) and a letter body.  The preamble is separated from  the body with
a line consisting of only:

%%endpreamble%%

The body of the letter can contain these replacement tags:

%salutation               -- Replaced with the salutation
%firstname                -- Replaced with the first name
%lastname                 -- Replaced with the last name
%suffix                   -- Replaced with the suffix
%organization             -- Replaced with the organization
%address1                 -- Replaced with the address line 1
%address2                 -- Replaced with the address line 2
%city                     -- Replaced with the city
%state                    -- Replaced with the state
%zip                      -- Replaced with the zip
%telephone                -- Replaced with the telephone
%fax                      -- Replaced with the fax

3 Print...
  Print Labels
3 Close
  See <Exit>
3 Exit
  Quit the program
2 Edit
  The edit menu contains the standard edit functions.
2 View
  The View menu is not presently used
2 Options
  The Options menu is not presently used
2 Help
  The Help menu contains the standard help items.
1 Toolbar
  The toolbar buttons map to these menu items:

  Button Graphic      Menu Item
  -----------------------------------------------------------------------
  {new.gif}                 <File>-><New>
  {open.gif}                 <File>-><Open...>
  {print.gif}                 <File>-><Print...>
  {mail.gif}                 <File>-><Export>-><As LaTeX ENVs>
  {tex.gif}                 <File>-><Export>-><As LaTeX Letters>
  {csv.gif}                 <File>-><Export>-><As LaTeX CSV...>
  {close.gif}                 <File>-><Exit>

1 Notebook
  The notebook window has at least these two tabs:

  <Add Record>               Adds a record (row) to the database.
  <Search and Edit Database> Searches the database for records to view
                           or edit
2 Add Record
  This notebook tab contains the data entry fields to add a new record
to the database.
2 Search and Edit Database
  This notebook tab contains a search frame and a list of matching
records (rows). The elements on the search results list can be viewed,
edited, or deleted. If the element(s) are selected for viewing or
editing, additional notebook tabs are creating containing the selected
records.
0 tlMain.tcl
  See <Main Window>.
1 tlMain.tcl.#menubar
  See <Menu Bar>.
1 tlMain.tcl.main.topf.tb0
  See <Toolbar>.
1 tlMain.tcl.main.frame.notebook
  See <Notebook>.
2 tlMain.tcl.main.frame.notebook.faddRecordTab
  See <Add Record>.
2 tlMain.tcl.main.frame.notebook.fsearchEditTab
  See <Search and Edit Database>
1 tlMain.tcl.main.status
  Status bar.  This is where status and help messages are displayed.
0 SelectDatasourceDialog
This dialog box allows you to select a database backend driver, as well
as the name of the database, the database server,  the username and
password to us to connect to the database, along with any additional
connection options needed to connect to this database.
0 PrintLabelsDialog
  This dialog box selects label printing parameters and options.

  Labels can either be printed to a Postscript printer (or a printer with a
Postscript filter, such as Ghostscript) or to a Postscript file.

  The format of the labels is determined by the label specification,
which can be loaded from a label specification file, using the [Browse]
and [Load] buttons on the <Label Spec. file>: line or directly created
or edited with the <CustomLabelDialog>, which can be invoked with the [Edit
Label Spec.] button.

  Once the output file or printer has been selected and the label format
set up, the rows selected by the search criteria can be printed by
clicking on the [Print] button.
1 Label Spec. file
  A label specification file is a text file containing lines consisting
of key and value pairs:

key: value

Recoginized keys are: LeftMargin, BottomMargin, LabelWidth, LabelHeight,
HorizSpace, VertSpace, HorizNumLabels, VertNumLabels, FontName, and
FontSize. See <CustomLabelDialog> for a discussion of the values for
these keys.
0 CustomLabelDialog
  This dialog box allows for customization of label printing.

  Label printing is controlled by a label specification, which consists
of these values:

	LeftMargin      Overall left margin, in points (1/72's of an inch).
	BottomMargin    Overall bottom margin, in points.
	LabelWidth      Label width, in points.
	LabelHeight     Label height, in points.
	HorizSpace      Horizontal space between columns of labels, in points.
	VertSpace       Vertical space between rows of labels, in points.
	HorizNumLabels  Number of columns of labels on a sheet.
	VertNumLabels   Number of rows of labels on a sheet.
	FontName        Name of the font to use.
	FontSize        Base font size, in points.
0 ExportEnvDialog
  This dialog box selects options for LaTeX Envelope exporting.  See
<File>-><Export>-><As LaTeX ENVs>.
0 ExportLetterDialog
  This dialog box selects options for LaTeX form letter exporting. See
<File>-><Export>-><As LaTeX Letters>.  
0 ExportCSVDialog
  This dialog box selects options for CSV exporting. See
<File>-><Export>-><As CSV...>.


