#!/usr/bin/wish
# Generated code: Mon Mar 10 10:20:12 EDT 2014
# Generated by: $Id: CTCPanelWindow.tcl 709 2009-05-01 15:20:49Z heller $
# Add your code to the bottom (after the 'Add User code after this line').
#
# -name {Example 4: From Chapt. 9 of C/MRI User's Manual V3.0}
# -width 780
# -height 550
# -hascmri yes
# -cmriport /dev/ttyS0
# -cmrispeed 9600
# -cmriretries 10000
# -hasazatrax no
# -simplemode no
# additionalPackages
# Load Tcl/Tk system supplied packages
package require Tk;#		Make sure Tk is loaded
package require tile;#          Load tile
package require snit;#		Load Snit

# Load MRR System packages
# Add MRR System package Paths
lappend auto_path /usr/local/lib/MRRSystem;# C++ (binary) packages
lappend auto_path /usr/local/share/MRRSystem;# Tcl (source) packages

package require snitStdMenuBar;#  Load the standard menu bar package
package require LabelFrames;#   Label frame widgets
package require MainFrame;#     Main Frame widget
package require ScrollableFrame;#     Scrollable Frame widget
package require MainWindow;#    Load the Main Window package
package require CTCPanel 2.0;#  Load the CTCPanel package (V2)
package require grsupport 2.0;# Load Graphics Support code (V2)

#* 
#* ------------------------------------------------------------------
#* panelCode.tcl - Panel Main Window Creation Library
#* Created by Robert Heller on Sun Apr 13 18:27:24 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: panelCode.tcl 625 2008-04-21 23:39:05Z heller $

snit::type MainWindow {
  pragma -hastypeinfo    no
  pragma -hastypedestroy no
  pragma -hasinstances   no

  typecomponent main
  typecomponent swframe
  typecomponent ctcpanel

  delegate typemethod {ctcpanel *} to ctcpanel
  delegate typemethod {main *} to main
  typemethod createwindow {args} {
    set name [from args -name {}]
    set width [from args -width 800]
    set height [from args -height 800]
    wm protocol . WM_DELETE_WINDOW [mytypemethod CarefulExit]
    wm withdraw .
    wm title . "$name"
    set main [mainwindow .main]
    pack $main -expand yes -fill both
    $main menu entryconfigure file New -state disabled
    $main menu entryconfigure file Open... -state disabled
    $main menu entryconfigure file Save -state disabled
    $main menu entryconfigure file {Save As...} -state disabled
    $main menu entryconfigure file Print... -state disabled
    $main menu entryconfigure file Close -command [mytypemethod CarefulExit]
    $main menu entryconfigure file Exit -command [mytypemethod CarefulExit]
    set frame [$main scrollwindow getframe]
    set swframe [ScrollableFrame $frame.swframe \
			-constrainedheight yes -constrainedwidth yes \
			-width [expr {$width + 15}] -height $height]
    $main scrollwindow setwidget $swframe
    set ctcpanel [::CTCPanel::CTCPanel [$swframe getframe].ctcpanel \
			-width $width -height $height]
    pack $ctcpanel -fill both -expand yes
    $main menu add view command \
		-label {Zoom In} \
		-accelerator {+} \
		-command "$ctcpanel zoomBy 2"
    set zoomMenu [menu [$main mainframe getmenu view].zoom -tearoff no]
    $main menu add view cascade \
		-label Zoom \
		-menu $zoomMenu
    $main menu add view command \
		-label {Zoom Out} \
		-accelerator {-} \
		-command "$ctcpanel zoomBy .5"
    $zoomMenu add command -label {16:1} -command "$ctcpanel setZoom 16"
    $zoomMenu add command -label {8:1} -command "$ctcpanel setZoom 8"
    $zoomMenu add command -label {4:1} -command "$ctcpanel setZoom 4"
    $zoomMenu add command -label {2:1} -command "$ctcpanel setZoom 2"
    $zoomMenu add command -label {1:1} -command "$ctcpanel setZoom 1"
    $zoomMenu add command -label {1:2} -command "$ctcpanel setZoom .5"
    $zoomMenu add command -label {1:4} -command "$ctcpanel setZoom .25"
    $zoomMenu add command -label {1:8} -command "$ctcpanel setZoom .125"
    $zoomMenu add command -label {1:16} -command "$ctcpanel setZoom .0625"

    $main showit
  }
  typemethod CarefulExit {{answer no}} {
    if {!$answer} {
      set answer [tk_messageBox -default no -icon question \
			-message {Really Quit?} -title {Careful Exit} \
			-type yesno -parent $main]
      if {$answer} {exit}
    }
  }  
}

MainWindow createwindow -name {Example 4: From Chapt. 9 of C/MRI User's Manual V3.0} -width 780 -height 550
# CTCPanelObjects
MainWindow ctcpanel create StraightBlock OS1m \
	-x1 180 \
	-y1 170 \
	-x2 200.0 \
	-y2 190.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock OS1n \
	-x1 150 \
	-y1 170 \
	-x2 180 \
	-y2 170.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create PushButton PB1 \
	-x 50 \
	-y 230.0 \
	-controlpoint BUTTE \
	-command {::Groups::TrackSelect setvalue Track1} \
	-color white \
	-label {Track 1}
MainWindow ctcpanel create StraightBlock OS1a \
	-x1 160.0 \
	-y1 60.0 \
	-x2 170.0 \
	-y2 70 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create PushButton PB2 \
	-x 50 \
	-y 190.0 \
	-controlpoint BUTTE \
	-command {::Groups::TrackSelect setvalue Track2} \
	-color white \
	-label {Track 2}
MainWindow ctcpanel create Signal SIG4LA \
	-x 521.0 \
	-y 199.0 \
	-label SIG4LA \
	-controlpoint BUTTE \
	-orientation 4 \
	-heads 1
MainWindow ctcpanel create Signal SIG2LAB \
	-x 401.0 \
	-y 199.0 \
	-label SIG2LAB \
	-controlpoint BUTTE \
	-orientation 4 \
	-heads 2
MainWindow ctcpanel create StraightBlock OS1b \
	-x1 220.0 \
	-y1 90.0 \
	-x2 260.0 \
	-y2 130.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create PushButton PB3 \
	-x 50 \
	-y 150.0 \
	-controlpoint BUTTE \
	-command {::Groups::TrackSelect setvalue Track3} \
	-color white \
	-label {Track 3}
MainWindow ctcpanel create PushButton PB4 \
	-x 50 \
	-y 110.0 \
	-controlpoint BUTTE \
	-command {::Groups::TrackSelect setvalue Track4} \
	-color white \
	-label {Track 4}
MainWindow ctcpanel create StraightBlock OS1c \
	-x1 210.0 \
	-y1 90 \
	-x2 220.0 \
	-y2 90.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock BK1 \
	-x1 10 \
	-y1 210 \
	-x2 165.0 \
	-y2 210.0 \
	-controlpoint BUTTE \
	-label {Track 1} \
	-position below \
	-occupiedcommand {::Blocks::BK1 occupiedp}
MainWindow ctcpanel create StraightBlock OS1d \
	-x1 110 \
	-y1 10 \
	-x2 130.0 \
	-y2 30.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock BK2 \
	-x1 10 \
	-y1 170 \
	-x2 145.0 \
	-y2 170.0 \
	-controlpoint BUTTE \
	-label {Track 2} \
	-position below \
	-occupiedcommand {::Blocks::BK2 occupiedp}
MainWindow ctcpanel create PushButton PB5 \
	-x 50 \
	-y 70.0 \
	-controlpoint BUTTE \
	-command {::Groups::TrackSelect setvalue Track5} \
	-color white \
	-label {Track 5}
MainWindow ctcpanel create StraightBlock OS1e \
	-x1 80 \
	-y1 10 \
	-x2 110.0 \
	-y2 10.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock BK3 \
	-x1 10 \
	-y1 145 \
	-x2 216.0 \
	-y2 145.0 \
	-controlpoint BUTTE \
	-label {Track 3} \
	-position below \
	-occupiedcommand {::Blocks::BK3 occupiedp}
MainWindow ctcpanel create PushButton PB6 \
	-x 50 \
	-y 30.0 \
	-controlpoint BUTTE \
	-command {::Groups::TrackSelect setvalue Track6} \
	-color white \
	-label {Track 6}
MainWindow ctcpanel create Signal SIG2RA \
	-x 168.0 \
	-y 221.0 \
	-label SIG2RA \
	-controlpoint BUTTE \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create Switch SM1 \
	-x 160.0 \
	-y 60.0 \
	-label SM1 \
	-controlpoint BUTTE \
	-orientation 5 \
	-flipped yes \
	-statecommand {::Switches::SM1 setstate [::Switches::SM1 motorbits]
::Switches::SM1 getstate} \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock OS1f \
	-x1 290.0 \
	-y1 160.0 \
	-x2 320 \
	-y2 190.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock BK4 \
	-x1 10 \
	-y1 90 \
	-x2 126.0 \
	-y2 90.0 \
	-controlpoint BUTTE \
	-label {Track 4} \
	-position below \
	-occupiedcommand {::Blocks::BK4 occupiedp}
MainWindow ctcpanel create Signal SIG2RB \
	-x 149.0 \
	-y 181.0 \
	-label SIG2RB \
	-controlpoint BUTTE \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create Switch SM2 \
	-x 210.0 \
	-y 90.0 \
	-label SM2 \
	-controlpoint BUTTE \
	-orientation 4 \
	-flipped no \
	-statecommand {::Switches::SM2 setstate [::Switches::SM2 motorbits]
::Switches::SM2 getstate} \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock OS1g \
	-x1 239.0 \
	-y1 210 \
	-x2 322.0 \
	-y2 210.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock BK5 \
	-x1 10 \
	-y1 45 \
	-x2 85 \
	-y2 45.0 \
	-controlpoint BUTTE \
	-label {Track 5} \
	-position below \
	-occupiedcommand {::Blocks::BK5 occupiedp}
MainWindow ctcpanel create Signal SIG4RA \
	-x 525.0 \
	-y 221.0 \
	-label SIG4RA \
	-controlpoint BUTTE \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create Signal SIG2RC \
	-x 219.0 \
	-y 158.0 \
	-label SIG2RC \
	-controlpoint BUTTE \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create Switch SM3 \
	-x 290.0 \
	-y 160.0 \
	-label SM3 \
	-controlpoint BUTTE \
	-orientation 5 \
	-flipped yes \
	-statecommand {::Switches::SM3 setstate [::Switches::SM3 motorbits]
::Switches::SM3 getstate} \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock OS1h \
	-x1 360.0 \
	-y1 210.0 \
	-x2 400.0 \
	-y2 210.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock BK6 \
	-x1 10 \
	-y1 10 \
	-x2 75.0 \
	-y2 10 \
	-controlpoint BUTTE \
	-label {Track 6} \
	-position below \
	-occupiedcommand {::Blocks::BK6 occupiedp}
MainWindow ctcpanel create Signal SIG2RD \
	-x 128.0 \
	-y 100.0 \
	-label SIG2RD \
	-controlpoint BUTTE \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create Switch SM4 \
	-x 240.0 \
	-y 210.0 \
	-label SM4 \
	-controlpoint BUTTE \
	-orientation 4 \
	-flipped no \
	-statecommand {::Switches::SM4 setstate [::Switches::SM4 motorbits]
::Switches::SM4 getstate} \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock OS1i \
	-x1 90.0 \
	-y1 46 \
	-x2 120.0 \
	-y2 46 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock BK7 \
	-x1 405.0 \
	-y1 210.0 \
	-x2 520.0 \
	-y2 210.0 \
	-controlpoint BUTTE \
	-label BK7 \
	-position below \
	-occupiedcommand {::Blocks::BK7 occupiedp}
MainWindow ctcpanel create SchLabel BUTTE \
	-x 332.0 \
	-y 99.0 \
	-controlpoint BUTTE \
	-color white \
	-label BUTTE
MainWindow ctcpanel create Signal SIG2RE \
	-x 88.0 \
	-y 55.0 \
	-label SIG2RE \
	-controlpoint BUTTE \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create Switch SM5 \
	-x 360.0 \
	-y 210.0 \
	-label SM5 \
	-controlpoint BUTTE \
	-orientation 4 \
	-flipped no \
	-statecommand {::Switches::SM5 setstate [::Switches::SM5 motorbits]
::Switches::SM5 getstate} \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock OS1j \
	-x1 130.0 \
	-y1 90 \
	-x2 170.0 \
	-y2 90.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock BK8 \
	-x1 525 \
	-y1 210.0 \
	-x2 650.0 \
	-y2 210.0 \
	-controlpoint BUTTE \
	-label BK8 \
	-position below \
	-occupiedcommand {::Blocks::BK8 occupiedp}
MainWindow ctcpanel create CTCLabel BUTTEa \
	-x 178.0 \
	-y 49.0 \
	-controlpoint BUTTE \
	-color white \
	-label BUTTE
MainWindow ctcpanel create Signal SIG2RF \
	-x 76.0 \
	-y 20.0 \
	-label SIG2RF \
	-controlpoint BUTTE \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create StraightBlock OS1k \
	-x1 220.0 \
	-y1 146 \
	-x2 250 \
	-y2 146.0 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
MainWindow ctcpanel create StraightBlock OS1l \
	-x1 170 \
	-y1 210 \
	-x2 200.0 \
	-y2 210 \
	-controlpoint BUTTE \
	-label {} \
	-position below \
	-occupiedcommand {::Blocks::OS1 occupiedp}
#* 
#* ------------------------------------------------------------------
#* cmriCode.tcl - CM/RI Library
#* Created by Robert Heller on Sun Apr 13 18:02:03 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: cmriCode.tcl 680 2009-01-07 22:53:14Z heller $

package require Cmri 2.0.0 ;#          Load the CMR/I package.
package require grsupport 2.0

# Snit type to implement a CMR/I node. 
snit::type CMriNode {
  typecomponent CMriBusObject;#		CMR/I I/O object
  typeconstructor {set CMriBusObject {}}
  typemethod open {port speed retries} {
    set CMriBusObject [CMri %%AUTO%% $port -baud  $speed -maxtries $retries]
  }
  typemethod close {} {
    if {[string length "$CMriBusObject"] > 0} {$CMriBusObject destroy}
    set CMriBusObject {}
  }
  # Define the integer verify method.
  GRSupport::VerifyIntegerMethod
  # options used by CMR/I nodes.
  option -ns -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -ni -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -no -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -dl -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -ct -default {} -readonly yes
  variable UA;#				This node's address
    
  constructor {_UA NodeType args} {
    cmri::uatype $_UA;#			Validate the address
    set UA $_UA;#			Stash our address
    $self configurelist $args;#		configure options
    # Determine type of node.
    cmri::CardType validate $NodeType;#	Validate the card type
    switch -exact -- $NodeType {
      SUSIC {set ctype SUSIC}
      USIC  {set ctype USIC}
      SMINI {set ctype SMINI
	     set options(-ni) 3
	     set options(-no) 6
	     set options(-dl) 0}
      default {
	error "Unknown Node Type: $NodeType"
      }
    }
    # Initialize our board.
    $CMriBusObject InitBoard $options(-ct) $options(-ni) \
			       $options(-no) $options(-ns) \
			       $UA $ctype $options(-dl)
  }
  # Input method -- poll our input ports
  method inputs {} {
    return [$CMriBusObject Inputs $options(-ni) $UA]
  }
  # Output method -- write to our output ports
  method outputs {args} {
    return [$CMriBusObject Outputs $args $UA]
  }
}


  


CMriNode open /dev/ttyS0 9600 10000
# CMRIBoards
CMriNode create Butte 0 SMINI -ns 0 -ni 3 -no 6 -dl 0 -ct {}

# Add User code after this line
# From chapter 9 of Computer/Model Railroad Interface User's Manual V3.0.
# See example4.iow for I/O connections for this example.

namespace eval Groups {
  # Radio groups (from push buttons)
  snit::type Group {
    option -buttonmap -readonly yes -default {}
    variable value
    constructor {args} {
      $self configurelist $args
      $self setvalue {}
    }
    method getvalue {} {return $value}
    method setvalue {newvalue} {
      set value $newvalue
      foreach {b v} $options(-buttonmap) {
	if {[string equal "$v" "$value"]} {
	  MainWindow ctcpanel seti $b I on
	} else {
	  MainWindow ctcpanel seti $b I off
	}
      }
    }
  } 
  Group TrackSelect -buttonmap {PB1 Track1 PB2 Track2 PB3 Track3 PB4 Track4 
				PB5 Track5 PB6 Track6}
}

namespace eval Signals {
  # Signal types.  Encapsulates a signal's aspect.
  # Descrete Led types, three aspect (Red, Yellow, Green)
  # See: Fig 3-5 of The Computer / Model Railroad Interface User's Manual V3.0
  snit::type OneHead {
    # Single head signals have four states: dark, green, yellow, or red.
    typevariable aspects -array {
      Dark	0x00
      Green	0x01
      Yellow	0x02
      Red	0x04
    }
    option -signal -default {}
    variable aspectbits
    constructor {args} {
      $self configurelist $args
      set aspectbits $aspects(Dark)
      if {[string length $options(-signal)] > 0} {
	MainWindow ctcpanel setv $options(-signal) dark
      }
    }
    method setaspect {a} {
      set aspectbits $aspects($a)
      if {[string length $options(-signal)] > 0} {
	switch $a {
	  Dark {MainWindow ctcpanel setv $options(-signal) dark}
	  Green {MainWindow ctcpanel setv $options(-signal) green}
	  Yellow {MainWindow ctcpanel setv $options(-signal) yellow}
	  Red {MainWindow ctcpanel setv $options(-signal) red}
	}
      }
    }
    method getaspect {}  {return $aspectbits}
  }
  snit::type TwoHead {
    # Two head signals have five states: dark, green over red, 
    # yellow over red, red over yellow, and red over red.
    typevariable aspects -array {
      Dark	0x00
      GreenRed	0x11
      YellowRed	0x12
      RedYellow	0x0c
      RedRed	0x14
    }
    option -signal -default {}
    variable aspectbits
    constructor {args} {
      $self configurelist $args
      set aspectbits $aspects(Dark)
      if {[string length $options(-signal)] > 0} {
	MainWindow ctcpanel setv $options(-signal) dark
      }
    }
    method setaspect {a} {
      set aspectbits $aspects($a)
      if {[string length $options(-signal)] > 0} {
	switch $a {
	  Dark {MainWindow ctcpanel setv $options(-signal) dark}
	  GreenRed {MainWindow ctcpanel setv $options(-signal) {green red}}
	  YellowRed {MainWindow ctcpanel setv $options(-signal) {yellow red}}
	  RedYellow {MainWindow ctcpanel setv $options(-signal) {red yellow}}
	  RedRed {MainWindow ctcpanel setv $options(-signal) {red red}}
	}
      }
    }
    method getaspect {}  {return $aspectbits}
  }
  snit::type ThreeHead {
    # Three head signals have six states: dark, green over red over red, 
    # yellow over red over red, red over yellow over red, red over red 
    # over yellow, and red over red over red.
    typevariable aspects -array {
      Dark		0x00
      GreenRedRed	0x51
      YellowRedRed	0x52
      RedYellowRed	0x4c
      RedRedYellow	0x34
      RedRedRed		0x54
    }
    option -signal -default {}
    variable aspectbits
    constructor {args} {
      $self configurelist $args
      set aspectbits $aspects(Dark)
      if {[string length $options(-signal)] > 0} {
	MainWindow ctcpanel setv $options(-signal) dark
      }
    }
    method setaspect {a} {
      set aspectbits $aspects($a)
      if {[string length $options(-signal)] > 0} {
	switch $a {
	  Dark {MainWindow ctcpanel setv $options(-signal) dark}
	  GreenRedRed {MainWindow ctcpanel setv $options(-signal) {green red red}}
	  YellowRedRed {MainWindow ctcpanel setv $options(-signal) {yellow red red}}
	  RedYellowRed {MainWindow ctcpanel setv $options(-signal) {red yellow red}}
	  RedRedYellow {MainWindow ctcpanel setv $options(-signal) {red red yellow}}
	  RedRedRed {MainWindow ctcpanel setv $options(-signal) {red red red}}
	}
      }
    }
    method getaspect {}  {return $aspectbits}
  }
  OneHead SIG2RF -signal SIG2RF
  OneHead SIG2RE -signal SIG2RE
  OneHead SIG2RD -signal SIG2RD
  OneHead SIG2RC -signal SIG2RC
  OneHead SIG2RB -signal SIG2RB
  OneHead SIG2RA -signal SIG2RA
  TwoHead SIG2LAB -signal SIG2LAB
  OneHead SIG4LA -signal SIG4LA
  OneHead SIG4RA -signal SIG4RA
}

namespace eval Blocks {
  # Block type (general trackwork).
  # Encapsulates block occupation detectors.
  #
  snit::type Block {
    # Occupation state values
    typevariable OCC 1
    typevariable CLR 0
    # Occupation state bit
    variable occupiedbit
    constructor {} {
      set occupiedbit $CLR;#	Initialize to clear.
    }
    # Occupation state methods
    method occupiedp {} {return [expr {$occupiedbit == $OCC}]}
    method setoccupied {value} {
      set occupiedbit $value
    }
  }
  Block OS1;# Shared by all switches
  Block BK1
  Block BK2
  Block BK3
  Block BK4
  Block BK5
  Block BK6
  Block BK7
  Block BK8
}

namespace eval Switches {
  # Switch type (turnout)
  # Encapsulates a switch (turnout), including its OS (delegated to a Block 
  # object), its switch motor, and its point position sensor (its state).
  snit::type Switch {
    component block;#			OS section
    delegate method * to block;#	Delegate block methods
    variable state unknown;#		Sense state (point position)
    # Motor bit values
    typevariable NOR 1;# 01		
    typevariable REV 2;# 10		
    variable motor;#			Motor bits -- used to drive switch 
#					motor.
    constructor {} {
      #					Install OS section
      install block using Blocks::Block %AUTO%
      # Initialize motor bits
      set motor $NOR
    }
    # State methods
    method getstate {} {return $state}
    method setstate {statebits} {
      if {$statebits == $NOR} {
	set state normal
      } elseif {$statebits == $REV} {
	set state reverse
      } else {
	set state unknown
      }
    }
    # Motor bit methods
    method motorbits {} {return $motor}
    method setmotor {mv} {
      switch -exact $mv {
	normal {set motor $NOR}
	reverse {set motor $REV}
      }
    }
  }
  Switch SM1
  Switch SM2
  Switch SM3
  Switch SM4
  Switch SM5
}



# Main Loop Start
while {true} {
  # Read all ports
  set Butte_inbits [Butte inputs]
  # Unpack input bits
  set tempbyte [lindex $Butte_inbits 0];# Port A: Blocks 1-7, OS1
  Blocks::BK1 setoccupied [expr {$tempbyte      & 0x01}]
  Blocks::BK2 setoccupied [expr {$tempbyte >> 1 & 0x01}]
  Blocks::BK3 setoccupied [expr {$tempbyte >> 2 & 0x01}]
  Blocks::BK4 setoccupied [expr {$tempbyte >> 3 & 0x01}]
  Blocks::BK5 setoccupied [expr {$tempbyte >> 4 & 0x01}]
  Blocks::BK6 setoccupied [expr {$tempbyte >> 5 & 0x01}]
  Blocks::OS1 setoccupied [expr {$tempbyte >> 6 & 0x01}]
  Blocks::BK7 setoccupied [expr {$tempbyte >> 7 & 0x01}]
  set tempbyte [lindex $Butte_inbits 1];# Port B: Block 8
  Blocks::BK8 setoccupied [expr {$tempbyte      & 0x01}]
  # Invoke all trackwork and get occupicency
  MainWindow ctcpanel invoke  OS1a
  MainWindow ctcpanel invoke  OS1b  
  MainWindow ctcpanel invoke  OS1c  
  MainWindow ctcpanel invoke  OS1d  
  MainWindow ctcpanel invoke  OS1e  
  MainWindow ctcpanel invoke  OS1f  
  MainWindow ctcpanel invoke  OS1g  
  MainWindow ctcpanel invoke  OS1h  
  MainWindow ctcpanel invoke  OS1i  
  MainWindow ctcpanel invoke  OS1j  
  MainWindow ctcpanel invoke  OS1k  
  MainWindow ctcpanel invoke  OS1l  
  MainWindow ctcpanel invoke  OS1m  
  MainWindow ctcpanel invoke  OS1n  
  MainWindow ctcpanel invoke  BK1
  MainWindow ctcpanel invoke  BK2
  MainWindow ctcpanel invoke  BK3
  MainWindow ctcpanel invoke  BK4
  MainWindow ctcpanel invoke  BK5
  MainWindow ctcpanel invoke  BK6
  MainWindow ctcpanel invoke  BK7
  MainWindow ctcpanel invoke  BK8
  # Process switch machines
  if {![Blocks::OS1 occupiedp]} {
    switch [::Groups::TrackSelect getvalue] {
      Track1 {Switches::SM4 setmotor normal;Switches::SM5 setmotor normal}
      Track2 {Switches::SM4 setmotor reverse;Switches::SM5 setmotor normal}
      Track3 {Switches::SM5 setmotor reverse;Switches::SM3 setmotor reverse}
      Track4 {Switches::SM5 setmotor reverse;Switches::SM3 setmotor normal;
	      Switches::SM2 setmotor normal}
      Track5 {Switches::SM5 setmotor reverse;Switches::SM3 setmotor normal;
	      Switches::SM2 setmotor reverse;Switches::SM1 setmotor reverse}
      Track6 {Switches::SM5 setmotor reverse;Switches::SM3 setmotor normal;
	      Switches::SM2 setmotor reverse;Switches::SM1 setmotor normal}
    }
  }
  MainWindow ctcpanel invoke  SM1
  MainWindow ctcpanel invoke  SM2
  MainWindow ctcpanel invoke  SM3
  MainWindow ctcpanel invoke  SM4
  MainWindow ctcpanel invoke  SM5
  # Compute direction of traffic
  if {[Block::OS1 occupiedp]} {
    set dot1 EastBound
  } else {
    set dot1 Westbound
  }  
  # Calculate SIG4RA
  Signals::SIG4RA setaspect Red
  if {$dot1 ne WestBound && ![Block::BK8 occupiedp]} {
    Signals::SIG4RA setaspect Green
  }
  # Calculate Butte exit signals
  Signals::SIG2RA setaspect Red
  Signals::SIG2RB setaspect Red
  Signals::SIG2RC setaspect Red
  Signals::SIG2RD setaspect Red
  Signals::SIG2RE setaspect Red
  Signals::SIG2RF setaspect Red
  set ExitSig Red
  if {$dot1 ne WestBound && ![Blocks::OS1 occupiedp] && ![Blocks::BK7 occupiedp]} {
    set ExitSig Yellow
    if {[MainWindow ctcpanel getv SIG4RA] ne red} {set ExitSig Green}
    switch [::Groups::TrackSelect getvalue] {
      Track1 {Signals::SIG2RA setaspect $ExitSig}
      Track2 {Signals::SIG2RB setaspect $ExitSig}
      Track3 {Signals::SIG2RC setaspect $ExitSig}
      Track4 {Signals::SIG2RD setaspect $ExitSig}
      Track5 {Signals::SIG2RE setaspect $ExitSig}
      Track6 {Signals::SIG2RF setaspect $ExitSig}
    }
  }
  Signals::SIG2LAB setaspect RedRed
  if {![Blocks::OS1 occupiedp]} {
    switch [::Groups::TrackSelect getvalue] {
      Track1 {if {![Blocks::BK1 occupiedp]} {Signals::SIG2LAB setaspect YellowRed}}
      Track2 {if {![Blocks::BK2 occupiedp]} {Signals::SIG2LAB setaspect RedYellow}}
      Track3 {if {![Blocks::BK3 occupiedp]} {Signals::SIG2LAB setaspect RedYellow}}
      Track4 {if {![Blocks::BK4 occupiedp]} {Signals::SIG2LAB setaspect RedYellow}}
      Track5 {if {![Blocks::BK5 occupiedp]} {Signals::SIG2LAB setaspect RedYellow}}
      Track6 {if {![Blocks::BK5 occupiedp]} {Signals::SIG2LAB setaspect RedYellow}}
    }
  }
  Signals::SIG4LA setaspect Red
  if {$dot1 ne EastBound && ![Blocks::BK7 occupiedp]} {
    Signals::SIG4LA setaspect Yellow
    if {[MainWindow ctcpanel getv SIG2LAB] ne {red red}} {
      Signals::SIG4LA setaspect Green
    }
  }
  # Pack output bits
  # Port A, Card 0:
  set     Butte_outbits  [expr {[Signals::SIG2LAB getaspect] | \
				[Signals::SIG2RA  getaspect] << 5}]
  # Port B, Card 0:
  lappend Butte_outbits  [expr {[Signals::SIG2RB  getaspect] | \
				[Signals::SIG2RC  getaspect] << 3 | \
				[Switches::SM1    motorbits] << 6}]
  # Port C, Card 0:
  lappend Butte_outbits  [expr {[Signals::SIG2RD  getaspect] | \
				[Signals::SIG2RE  getaspect] << 3 | \
				[Switches::SM2    motorbits] << 6}]
  # Port A, Card 2:
  lappend Butte_outbits  [expr {[Signals::SIG2RF  getaspect] | \
				[Switches::SM3    motorbits] << 3 | \
				[Switches::SM4    motorbits] << 5}]
  # Port B, Card 2:
  lappend Butte_outbits  [expr {[Signals::SIG4LA  getaspect] | \
				[Signals::SIG4RA  getaspect] << 3 | \
				[Switches::SM5    motorbits] << 6}]
  # Port C, Card 2:
  lappend Butte_outbits 0
  # Write all output ports
  eval [list Butte outputs] $Butte_outbits
  update;# Update display
}
# Main Loop End

