#!/usr/bin/wish
# Generated code: Tue Oct 30 01:46:07 PM EDT 2012
# Generated by: $Id: CTCPanelWindow.tcl 709 2009-05-01 15:20:49Z heller $
# Add your code to the bottom (after the 'Add User code after this line').
#
# -name AN02
# -width 780
# -height 550
# -hascmri no
# -hasazatrax yes
# -simplemode no
# additionalPackages
# Load Tcl/Tk system supplied packages
package require Tk;#		Make sure Tk is loaded
package require BWidget;#       Load BWidgets
package require snit;#		Load Snit

# Load MRR System packages
# Add MRR System package Paths
lappend auto_path /usr/local/lib/MRRSystem;# C++ (binary) packages
lappend auto_path /usr/local/share/MRRSystem;# Tcl (source) packages

package require BWStdMenuBar;#  Load the standard menu bar package
package require MainWindow;#    Load the Main Window package
package require CTCPanel 2.0;#  Load the CTCPanel package (V2)
package require grsupport 2.0;# Load Graphics Support code (V2)

#* 
#* ------------------------------------------------------------------
#* panelCode.tcl - Panel Main Window Creation Library
#* Created by Robert Heller on Sun Apr 13 18:27:24 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: panelCode.tcl 625 2008-04-21 23:39:05Z heller $

snit::type MainWindow {
  pragma -hastypeinfo    no
  pragma -hastypedestroy no
  pragma -hasinstances   no

  typecomponent main
  typecomponent swframe
  typecomponent ctcpanel

  delegate typemethod {ctcpanel *} to ctcpanel
  delegate typemethod {main *} to main
  typemethod createwindow {args} {
    set name [from args -name {}]
    set width [from args -width 800]
    set height [from args -height 800]
    wm protocol . WM_DELETE_WINDOW [mytypemethod CarefulExit]
    wm withdraw .
    wm title . "$name"
    set main [mainwindow .main]
    pack $main -expand yes -fill both
    $main menu entryconfigure file New -state disabled
    $main menu entryconfigure file Open... -state disabled
    $main menu entryconfigure file Save -state disabled
    $main menu entryconfigure file {Save As...} -state disabled
    $main menu entryconfigure file Print... -state disabled
    $main menu entryconfigure file Close -command [mytypemethod CarefulExit]
    $main menu entryconfigure file Exit -command [mytypemethod CarefulExit]
    set frame [$main scrollwindow getframe]
    set swframe [ScrollableFrame $frame.swframe \
			-constrainedheight yes -constrainedwidth yes \
			-width [expr {$width + 15}] -height $height]
    pack $swframe -expand yes -fill both
    $main scrollwindow setwidget $swframe
    set ctcpanel [::CTCPanel::CTCPanel [$swframe getframe].ctcpanel \
			-width $width -height $height]
    pack $ctcpanel -fill both -expand yes
    $main menu add view command \
		-label {Zoom In} \
		-accelerator {+} \
		-command "$ctcpanel zoomBy 2"
    set zoomMenu [menu [$main mainframe getmenu view].zoom -tearoff no]
    $main menu add view cascade \
		-label Zoom \
		-menu $zoomMenu
    $main menu add view command \
		-label {Zoom Out} \
		-accelerator {-} \
		-command "$ctcpanel zoomBy .5"
    $zoomMenu add command -label {16:1} -command "$ctcpanel setZoom 16"
    $zoomMenu add command -label {8:1} -command "$ctcpanel setZoom 8"
    $zoomMenu add command -label {4:1} -command "$ctcpanel setZoom 4"
    $zoomMenu add command -label {2:1} -command "$ctcpanel setZoom 2"
    $zoomMenu add command -label {1:1} -command "$ctcpanel setZoom 1"
    $zoomMenu add command -label {1:2} -command "$ctcpanel setZoom .5"
    $zoomMenu add command -label {1:4} -command "$ctcpanel setZoom .25"
    $zoomMenu add command -label {1:8} -command "$ctcpanel setZoom .125"
    $zoomMenu add command -label {1:16} -command "$ctcpanel setZoom .0625"

    $main showit
  }
  typemethod CarefulExit {{answer no}} {
    if {!$answer} {
      set answer [tk_messageBox -default no -icon question \
			-message {Really Quit?} -title {Careful Exit} \
			-type yesno -parent $main]
      if {$answer} {exit}
    }
  }  
}

MainWindow createwindow -name AN02 -width 780 -height 550
# CTCPanelObjects
MainWindow ctcpanel create StraightBlock SouthT1 \
	-x1 150.0 \
	-y1 220 \
	-x2 580 \
	-y2 220 \
	-controlpoint South \
	-label {} \
	-position below \
	-occupiedcommand {::SouthT1_Occ occupiedP}
MainWindow ctcpanel create StraightBlock SouthT2 \
	-x1 150.0 \
	-y1 200 \
	-x2 580 \
	-y2 200 \
	-controlpoint South \
	-label {} \
	-position below \
	-occupiedcommand {::SouthT2_Occ occupiedP}
MainWindow ctcpanel create Switch Switch1n \
	-x 110.0 \
	-y 20.0 \
	-label 1n \
	-controlpoint West \
	-orientation 0 \
	-flipped no \
	-statecommand {$::WestTurnoutState} \
	-occupiedcommand {::CurveOccupancy ::WestClockwise ::WestCounterClockwise
}
MainWindow ctcpanel create CurvedBlock SE1 \
	-x1 620.0 \
	-y1 220.0 \
	-x2 720.0 \
	-y2 120.0 \
	-radius 100 \
	-controlpoint East \
	-label {} \
	-position below \
	-occupiedcommand {::CurveOccupancy ::EastClockwise ::EastCounterClockwise}
MainWindow ctcpanel create CurvedBlock SW1 \
	-x1 10.0 \
	-y1 120.0 \
	-x2 110.0 \
	-y2 220.0 \
	-radius 100 \
	-controlpoint West \
	-label {} \
	-position below \
	-occupiedcommand {::CurveOccupancy ::WestClockwise ::WestCounterClockwise}
MainWindow ctcpanel create Switch Switch1s \
	-x 110.0 \
	-y 220.0 \
	-label 1s \
	-controlpoint West \
	-orientation 0 \
	-flipped yes \
	-statecommand {$::WestTurnoutState} \
	-occupiedcommand {::CurveOccupancy ::WestClockwise ::WestCounterClockwise
}
MainWindow ctcpanel create StraightBlock NorthT1 \
	-x1 150.0 \
	-y1 20 \
	-x2 580 \
	-y2 20 \
	-controlpoint North \
	-label {} \
	-position below \
	-occupiedcommand {::NorthT1_Occ occupiedP}
MainWindow ctcpanel create StraightBlock NorthT2 \
	-x1 150.0 \
	-y1 40.0 \
	-x2 580 \
	-y2 40 \
	-controlpoint North \
	-label {} \
	-position below \
	-occupiedcommand {::NorthT2_Occ occupiedP}
MainWindow ctcpanel create Switch Switch2n \
	-x 620.0 \
	-y 20 \
	-label 2n \
	-controlpoint East \
	-orientation 4 \
	-flipped yes \
	-statecommand {$::EastTurnoutState} \
	-occupiedcommand {::CurveOccupancy ::EastClockwise ::EastCounterClockwise}
MainWindow ctcpanel create CurvedBlock NE1 \
	-x1 720.0 \
	-y1 120.0 \
	-x2 620.0 \
	-y2 20.0 \
	-radius 100 \
	-controlpoint East \
	-label {} \
	-position below \
	-occupiedcommand {::CurveOccupancy ::EastClockwise ::EastCounterClockwise}
MainWindow ctcpanel create CurvedBlock NW1 \
	-x1 110 \
	-y1 20 \
	-x2 10 \
	-y2 120 \
	-radius 100 \
	-controlpoint West \
	-label {} \
	-position below \
	-occupiedcommand {::CurveOccupancy ::WestClockwise ::WestCounterClockwise}
MainWindow ctcpanel create Switch Switch2s \
	-x 620.0 \
	-y 220.0 \
	-label 2s \
	-controlpoint East \
	-orientation 4 \
	-flipped no \
	-statecommand {$::EastTurnoutState} \
	-occupiedcommand {::CurveOccupancy ::EastClockwise ::EastCounterClockwise}

package require Azatrax
# Azatrax Nodes
# West End control
SR4 WestControl -this [Azatrax_OpenDevice 003 $::Azatrax_idSR4Product]
# East end clockwise sensor
MRD EastClockwise -this [Azatrax_OpenDevice 005 $::Azatrax_idMRDProduct]
# East end counter clockwise sensor
MRD EastCounterClockwise -this [Azatrax_OpenDevice 004 $::Azatrax_idMRDProduct]
# East end control
SR4 EastControl -this [Azatrax_OpenDevice 006 $::Azatrax_idSR4Product]
# West end clockwise sensor pair
MRD WestClockwise -this [Azatrax_OpenDevice 001 $::Azatrax_idMRDProduct]
# West end counterclockwise sensor pair
MRD WestCounterClockwise -this [Azatrax_OpenDevice 002 $::Azatrax_idMRDProduct]

# Add User code after this line

proc CurveOccupancy {CW_Sensor CCW_Sensor} {
## Check for curve occupancy. 
#  First the clockwise sensor is checked and then the counter-
#  clockwise sensor is checked. The logic is:
#  Sense_1 This is at the entrance to the curve, just before the 
#		turnout. If this sensor is active, then a train 
#		is presently entering.
#  Latch_1 This is the latched state of sense 1. If it is set, 
#		then the train has cleared sense 1, but has not 
#		yet covered sense 2, this means that the train is 
#		in the curve between the sensors.
#  Sense_2 This is the sensor at the exit from the curve. If this 
#		sensor is active, then a train is presently 
#		exiting the curve. When this sensor is activated, 
#		the latch for sensor 1 is cleared.
#  
#  If all of the above are clear (return false), then the train 
#  has cleared the exit sensor and the curve is not occupied. 
#  If any of the above are set (return true), then there is a 
#  train occupying the block.
#
#  Both the clockwise and counter-clockwise sensors are checked, 
#  since a tain going in either direction could be occupying the 
#  curve.
#
#  This procedure is used as the Occupancy Script for the curved 
#  sections of the trackwork, including the turnouts.
#
#  Parameters:
#  CW_Sensor The Clockwise sensor, a MRD object.
#  CCW_Sensor The Counter-Clockwise sensor, a MRD object.
#
  if {[$CW_Sensor Sense_1] ||
      [$CW_Sensor Latch_1] ||
      [$CW_Sensor Sense_2]} {
    return yes
  } elseif {[$CCW_Sensor Sense_1] ||
	    [$CCW_Sensor Latch_1] ||
	    [$CCW_Sensor Sense_2]} {
    return yes
  } else {
    return no
  }
}

snit::type StraightOccupancy {
## Object to implement occupancy testing on the straight 
#  sections. This object is used to check occupancy on the 
#  four straight sections.
#
#  Options:
#  -enter_sense Sensor at the entrance to the straight section. 
#		This will be a sense 2, so only Sense_2 and 
#		Latch_2 are checked.
#  -exit_sense Sensor at the exit of the straight section.  
#		This will be a sense 1, so only Sense_1 is 
#		checked.
#  
#
#  A state variable is used to keep track of possible states: 
#  exited, entering, entered, exiting, and default (unknown).  
#  Each state determines which sensors or their latches are 
#  checked and determine the next state.
#
#  Four of these objects will be created and used in the 
#  Occupancy scripts of each of the four straight senctions.  
#  The occupiedP method will be called to compute the occupancy 
#  state.
#
  option -enter_sense -readonly yes -default {}
  option -exit_sense -readonly yes -default {}
  variable state unknown
  ## State variable.
  constructor {args} {
    ## The constructor just processes the object options.
    $self configurelist $args
  }
  method occupiedP {} {
    ## Method to check for occupancy.  The state variable is 
    #  checked and depending on its value, the sensors or latches 
    #  are checked to determine the possible progress of a train 
    #  through the straight section.
    #
    switch $state {
      exited {
	# A train has exited.  Has a train reached the entry 
	# sensor?
	if {[$options(-enter_sense) Sense_2]} {
	  # Yes, save the state.
	  set state entering
	  # Block is now occupied.
	  set occupied yes
	} else {
	  # No, block is clear.
	  set occupied no
	}
      }
      entering {
	# A train was entering.  Has it completly entered yet?
	if {[$options(-enter_sense) Latch_2]} {
	  # Yes. The train is now fully in the block.
	  set state entered
	}
	# The block is occupied.
        set occupied yes
      }
      entered {
	# A train has completly entered.  Is it leaving yet?
	if {[$options(-exit_sense) Sense_1]} {
	  # Yes, it is now leaving.
	  set state exiting
	}
	# The block is occupied.
	set occupied yes
      }
      exiting {
	# A train is exiting.  Has it completely left yet?
	if {[$options(-exit_sense) Latch_1]} {
	  # Yes, it has now left.
	  set state exited
	  # The block is no longer occupied.
	  set occupied no
	} else {
	  # No, the train has not completely left, so the block 
	  # is still occupied.
	  set occupied yes
	}
      }
      default {
	# Unknown state.  Check each possible sensor and 
	# determine where the train might be.
	if {[$options(-enter_sense) Sense_2]} {
	  # Entry sensor is covered: a train is entering and the 
	  # block is occupied.
	  set state entering
	  set occupied yes
	} elseif {[$options(-enter_sense) Latch_2]} {
	  # Entry sensor was covered, but isn't anymore: a train 
	  # has fully entered and the block is occupied.
	  set state entered
	  set occupied yes
	} elseif {[$options(-exit_sense) Sense_1]} {
	  # Exit sensor is covered: the train is exiting and the 
	  # block is occupied.
	  set state exiting
	  set occupied yes
        } elseif {[$options(-exit_sense) Latch_1]} {
	  # Exit sensor was covered, but isn't anymore: the train 
	  # has fully exited and the block is no longer occupied.
	  set state exited
	  set occupied no 
	} else {
	  # No sensor state was met.  Presume that the block is 
	  # not occupied.
	  set occupied no
	}
      }
    }
    return $occupied
  }
}

# Four occupancy detection objects, one for each of the four 
# straight sections.
StraightOccupancy create SouthT1_Occ \
			-enter_sense WestCounterClockwise \
			-exit_sense  EastCounterClockwise
StraightOccupancy create SouthT2_Occ \
			-enter_sense EastClockwise \
			-exit_sense  WestClockwise
StraightOccupancy create NorthT1_Occ \
			-enter_sense EastCounterClockwise \
			-exit_sense  WestCounterClockwise
StraightOccupancy create NorthT2_Occ \
			-enter_sense WestClockwise \
			-exit_sense  EastClockwise

# Initialize both Turnout states and both reversing relays.

# West end.
global WestTurnoutState 
WestControl PulseRelays 0 1 0 0 4
WestControl RelaysOff   0 0 1 0
set WestTurnoutState normal

# East end.
global EastTurnoutState 
EastControl PulseRelays 0 1 0 0 4
EastControl RelaysOff   0 0 1 0
set EastTurnoutState normal

# Main Loop Start
# The main loop consistes ofthree sections
while {true} {
  ## Read all AZATRAX state data: read all sensors from the 
  #  devices to the sensor memory buffer.  This data will be 
  #  used to check occupicency and to determine if it needful 
  #  to throw turnouts and relays.

  WestControl GetStateData
  EastClockwise GetStateData
  EastCounterClockwise GetStateData
  EastControl GetStateData
  WestClockwise GetStateData
  WestCounterClockwise GetStateData

  ## Invoke all trackwork and get occupicency.  Occupicency is 
  #  computed from the MRD sensor data loaded above.  Each piece 
  #  of trackwork contains an occupicency script which checks the 
  #  sense data and determines if the piece of trackwork is 
  #  occupied.

  MainWindow ctcpanel invoke SouthT1
  MainWindow ctcpanel invoke SouthT2
  MainWindow ctcpanel invoke SE1
  MainWindow ctcpanel invoke Switch1n
  MainWindow ctcpanel invoke SW1
  MainWindow ctcpanel invoke Switch1s
  MainWindow ctcpanel invoke NorthT1
  MainWindow ctcpanel invoke NorthT2
  MainWindow ctcpanel invoke Switch2n
  MainWindow ctcpanel invoke NE1
  MainWindow ctcpanel invoke NW1
  MainWindow ctcpanel invoke Switch2s

  ## Implement dispatcher logic: check for train arrival at the 
  #  start of a single track section, then check for a possible 
  #  opposing movement. If there is no opposing movement, set the 
  #  turnout and reversing relay to favor the newly arrived 
  #  train.
  #
  #  There are four blocks, two for each of two ends.  Each end 
  #  has a clockwise and a counter-clockwise block.
  #

  ## West end movements.  A clockwise and then counter clockwise 
  #  block.

  ## West end clockwise block.
  # Has a clockwise train arrived at the west end single track 
  # segment? If WestClockwise's Sense_1 is covered, 
  # WestCounterClockwise sensors are checked to see if there is 
  # an opposing movement.
  if {[WestClockwise Sense_1]} {
    # Check for opposing movement
    if {![WestCounterClockwise Sense_1] &&
	![WestCounterClockwise Sense_2] &&
	![WestCounterClockwise Latch_1]} {
      # single track segment is clear
      # Throw turnouts 1n and 1s (reversed).
      WestControl PulseRelays 1 0 0 0 4
      WestControl RelaysOn    0 0 1 0;# Set relay.
      set WestTurnoutState reverse
    }
  }

  ## West end counter-clockwise block.
  # Has a counterclockwise train arrived at the west end single 
  # track segment? If WestCounterClockwise's Sense_1 is covered, 
  # WestClockwise sensors are checked to see if there is an 
  # opposing movement.
  if {[WestCounterClockwise Sense_1]} {
    # Check for opposing movement
    if {![WestClockwise Sense_1] &&
	![WestClockwise Sense_2] &&
	![WestClockwise Latch_1]} {
      # single track segment is clear
      # Throw turnouts 1n and 1s (normal).
      WestControl PulseRelays 0 1 0 0 4
      WestControl RelaysOff   0 0 1 0;# Unset relay.
      set WestTurnoutState normal
    }
  }

  ## East end movements: just like the west end, a clockwise 
  #  block and then a counter clockwise block.

  ## East end clockwise block.  
  # Has a clockwise train arrived at the east end single track 
  # segment? If EastClockwise's Sense_1 is covered, 
  # EastCounterClockwise sensors are checked to see if there 
  # is an opposing movement.
  if {[EastClockwise Sense_1]} {
    # Check for opposing movement
    if {![EastCounterClockwise Sense_1] &&
	![EastCounterClockwise Sense_2] &&
	![EastCounterClockwise Latch_1]} {
      # single track segment is clear
      # Throw turnouts 2n and 2s (normal).
      EastControl PulseRelays 0 1 0 0 4
      EastControl RelaysOff   0 0 1 0;# Unset relay.
      set EastTurnoutState normal
    }
  }

  ## East end counter-clockwise block.  
  # Has a counterclockwise train arrived at the east end single 
  # track segment? If EastCounterClockwise's Sense_1 is covered, 
  # EastClockwise sensors are checked to see if there is an 
  # opposing movement.
  if {[EastCounterClockwise Sense_1]} {
    # Check for opposing movement
    if {![EastClockwise Sense_1] &&
	![EastClockwise Sense_2] &&
	![EastClockwise Latch_1]} {
      # single track segment is clear
      # Throw turnouts 2n and 2s (reverse).
      EastControl PulseRelays 1 0 0 0 4
      EastControl RelaysOn   0 0 1 0;# Set relay.
      set EastTurnoutState reverse
    }
  }


  update;# Update display
}
# Main Loop End

 

