#!/usr/bin/wish
# Generated code: Thu May 10 21:48:25 EDT 2018
# Generated by: $Id: CTCPanelWindow.tcl 709 2009-05-01 15:20:49Z heller $
# Add your code to the bottom (after the 'Add User code after this line').
#
# -name {Crossing Interchange}
# -width 780
# -height 550
# -hascmri no
# -hasctiacela no
# -hasazatrax no
# -simplemode no
# -openlcbmode yes
# -openlcbtransport CANGridConnectOverCANSocket
# -openlcbtransportopts {-nid 05:01:01:01:22:ff -socketname vcan0}
# additionalPackages
# Load Tcl/Tk system supplied packages
package require Tk;#		Make sure Tk is loaded
package require tile;#          Load tile
package require snit;#		Load Snit

# Load MRR System packages
# Add MRR System package Paths
lappend auto_path /usr/local/lib/MRRSystem;# C++ (binary) packages
lappend auto_path /usr/local/share/MRRSystem;# Tcl (source) packages

package require snitStdMenuBar;#  Load the standard menu bar package
package require LabelFrames;#   Label frame widgets
package require MainFrame;#     Main Frame widget
package require ScrollableFrame;#     Scrollable Frame widget
package require MainWindow;#    Load the Main Window package
package require CTCPanel 2.0;#  Load the CTCPanel package (V2)
package require grsupport 2.0;# Load Graphics Support code (V2)

#* 
#* ------------------------------------------------------------------
#* panelCode.tcl - Panel Main Window Creation Library
#* Created by Robert Heller on Sun Apr 13 18:27:24 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: panelCode.tcl 625 2008-04-21 23:39:05Z heller $

snit::type MainWindow {
  pragma -hastypeinfo    no
  pragma -hastypedestroy no
  pragma -hasinstances   no

  typecomponent main
  typecomponent swframe
  typecomponent ctcpanel

  delegate typemethod {ctcpanel *} to ctcpanel
  delegate typemethod {main *} to main
  typemethod createwindow {args} {
    set name [from args -name {}]
    set width [from args -width 800]
    set height [from args -height 800]
    set extramenus [from args -extramenus {}]
    wm protocol . WM_DELETE_WINDOW [mytypemethod CarefulExit]
    wm withdraw .
    wm title . "$name"
    set main [mainwindow .main -extramenus $extramenus]
    pack $main -expand yes -fill both
    $main menu entryconfigure file New -state disabled
    $main menu entryconfigure file Open... -state disabled
    $main menu entryconfigure file Save -state disabled
    $main menu entryconfigure file {Save As...} -state disabled
    $main menu entryconfigure file Print... -state disabled
    $main menu entryconfigure file Close -command [mytypemethod CarefulExit]
    $main menu entryconfigure file Exit -command [mytypemethod CarefulExit]
    set frame [$main scrollwindow getframe]
    set swframe [ScrollableFrame $frame.swframe \
			-constrainedheight yes -constrainedwidth yes \
			-width [expr {$width + 15}] -height $height]
    $main scrollwindow setwidget $swframe
    set ctcpanel [::CTCPanel::CTCPanel [$swframe getframe].ctcpanel \
			-width $width -height $height]
    pack $ctcpanel -fill both -expand yes
    $main menu add view command \
		-label {Zoom In} \
		-accelerator {+} \
		-command "$ctcpanel zoomBy 2"
    set zoomMenu [menu [$main mainframe getmenu view].zoom -tearoff no]
    $main menu add view cascade \
		-label Zoom \
		-menu $zoomMenu
    $main menu add view command \
		-label {Zoom Out} \
		-accelerator {-} \
		-command "$ctcpanel zoomBy .5"
    $zoomMenu add command -label {16:1} -command "$ctcpanel setZoom 16"
    $zoomMenu add command -label {8:1} -command "$ctcpanel setZoom 8"
    $zoomMenu add command -label {4:1} -command "$ctcpanel setZoom 4"
    $zoomMenu add command -label {2:1} -command "$ctcpanel setZoom 2"
    $zoomMenu add command -label {1:1} -command "$ctcpanel setZoom 1"
    $zoomMenu add command -label {1:2} -command "$ctcpanel setZoom .5"
    $zoomMenu add command -label {1:4} -command "$ctcpanel setZoom .25"
    $zoomMenu add command -label {1:8} -command "$ctcpanel setZoom .125"
    $zoomMenu add command -label {1:16} -command "$ctcpanel setZoom .0625"

    $main showit
  }
  typemethod CarefulExit {{answer no}} {
    if {!$answer} {
      set answer [tk_messageBox -default no -icon question \
			-message {Really Quit?} -title {Careful Exit} \
			-type yesno -parent $main]
      if {$answer} {exit}
    }
  }  
}

MainWindow createwindow -name {Crossing Interchange} -width 780 -height 550 -extramenus {"OpenLCB" openlcb openlcb 0 {}}
# CTCPanelObjects
MainWindow ctcpanel create SWPlate SW1_Plate \
	-x 111.0 \
	-y 123.0 \
	-label SW1 \
	-controlpoint CP1 \
	-normalcommand {} \
	-reversecommand {}
MainWindow ctcpanel create Crossing Crossing \
	-x 106.0 \
	-y 284.0 \
	-label {} \
	-controlpoint Main \
	-orientation 2 \
	-type x90 \
	-flipped yes \
	-occupiedcommand {}
MainWindow ctcpanel create SWPlate SW2_Plate \
	-x 611.0 \
	-y 105.0 \
	-label SW2 \
	-controlpoint CP2 \
	-normalcommand {} \
	-reversecommand {}
MainWindow ctcpanel create Signal S3S \
	-x 96.0 \
	-y 252.0 \
	-label S3S \
	-controlpoint Main \
	-orientation 2 \
	-heads 1
MainWindow ctcpanel create StraightBlock MainOneWest \
	-x1 83.0 \
	-y1 303.0 \
	-x2 7.0 \
	-y2 304.0 \
	-controlpoint Main \
	-label {} \
	-position left \
	-occupiedcommand {}
MainWindow ctcpanel create StraightBlock MainTwoSouth \
	-x1 106.0 \
	-y1 331.0 \
	-x2 106.0 \
	-y2 370.0 \
	-controlpoint Main \
	-label {} \
	-position left \
	-occupiedcommand {}
MainWindow ctcpanel create Signal S2IE \
	-x 574.0 \
	-y 259.0 \
	-label S2IE \
	-controlpoint CP2 \
	-orientation 1 \
	-heads 1
MainWindow ctcpanel create Signal S3E \
	-x 52.0 \
	-y 315.0 \
	-label S3E \
	-controlpoint Main \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create Switch SW1 \
	-x 106.0 \
	-y 18.0 \
	-label SW1 \
	-controlpoint CP1 \
	-orientation 2 \
	-flipped yes \
	-statecommand {} \
	-occupiedcommand {}
MainWindow ctcpanel create Switch SW2 \
	-x 625.0 \
	-y 303.0 \
	-label SW2 \
	-controlpoint CP2 \
	-orientation 4 \
	-flipped no \
	-statecommand {} \
	-occupiedcommand {}
MainWindow ctcpanel create Signal S3W \
	-x 176.0 \
	-y 294.0 \
	-label S3W \
	-controlpoint Main \
	-orientation 4 \
	-heads 1
MainWindow ctcpanel create Signal S2ME \
	-x 548.0 \
	-y 316.0 \
	-label S2ME \
	-controlpoint CP2 \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create StraightBlock Interchange \
	-x1 129.0 \
	-y1 61.0 \
	-x2 580.0 \
	-y2 281.0 \
	-controlpoint Main \
	-label {} \
	-position left \
	-occupiedcommand {}
MainWindow ctcpanel create Signal S1IN \
	-x 189.0 \
	-y 73.0 \
	-label S1IN \
	-controlpoint CP1 \
	-orientation 5 \
	-heads 1
MainWindow ctcpanel create Signal S2W \
	-x 661.0 \
	-y 293.0 \
	-label S2W \
	-controlpoint CP2 \
	-orientation 4 \
	-heads 2
MainWindow ctcpanel create CodeButton Code1 \
	-x 112.0 \
	-y 189.0 \
	-controlpoint CP1 \
	-command {}
MainWindow ctcpanel create Signal S3N \
	-x 117.0 \
	-y 366.0 \
	-label S3N \
	-controlpoint Main \
	-orientation 6 \
	-heads 1
MainWindow ctcpanel create CodeButton Code2 \
	-x 613.0 \
	-y 176.0 \
	-controlpoint CP2 \
	-command {}
MainWindow ctcpanel create Signal S1MN \
	-x 118.0 \
	-y 113.0 \
	-label S1MN \
	-controlpoint CP1 \
	-orientation 6 \
	-heads 1
MainWindow ctcpanel create Signal S1S \
	-x 93.0 \
	-y 15.0 \
	-label S1S \
	-controlpoint CP1 \
	-orientation 2 \
	-heads 2
MainWindow ctcpanel create StraightBlock MainOne \
	-x1 129.0 \
	-y1 304.0 \
	-x2 581.0 \
	-y2 303.0 \
	-controlpoint Main \
	-label {} \
	-position left \
	-occupiedcommand {}
MainWindow ctcpanel create StraightBlock MainTwo \
	-x1 106.0 \
	-y1 63.0 \
	-x2 105.0 \
	-y2 280.0 \
	-controlpoint Main \
	-label {} \
	-position left \
	-occupiedcommand {}
#*****************************************************************************
#
#  System        : 
#  Module        : 
#  Object Name   : $RCSfile$
#  Revision      : $Revision$
#  Date          : $Date$
#  Author        : $Author$
#  Created By    : Robert Heller
#  Created       : Sat Aug 20 09:20:52 2016
#  Last Modified : <170719.1538>
#
#  Description	
#
#  Notes
#
#  History
#	
#*****************************************************************************
#
#    Copyright (C) 2016  Robert Heller D/B/A Deepwoods Software
#			51 Locke Hill Road
#			Wendell, MA 01379-9728
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# 
#
#*****************************************************************************


package require snit
package require LCC
package require LCCNodeTree
package require EventDialogs
package require CTCPanel 2.0

snit::type Dispatcher_Block {
    option -openlcb -type ::OpenLCB_Dispatcher -readonly yes
    option -name    -default {}
    option -occupiedeventid -type lcc::EventID_or_null -default {}
    option -notoccupiedeventid -type lcc::EventID_or_null -default {}
    variable occupied no

    constructor {args} {
        $self configurelist $args
        MainWindow ctcpanel itemconfigure "$options(-name)" \
              -occupiedcommand [mymethod occupiedp]
    }
    method occupiedp {} {return $occupied}
    method consumerP {} {return yes}
    method producerP {} {return no}
    method consumedEvents {} {
        set events [list]
        foreach eopt {occupiedeventid notoccupiedeventid} {
            set ev [$self cget -$eopt]
            if {$ev eq {}} {continue}
            lappend events $ev
        }
        return $events
    }
    method producedEvents {} {return [list]}
    method consumeEvent {event} {
        set ev [$self cget -occupiedeventid]
        if {$ev ne {} && [$ev match $event]} {
            set occupied yes
        }
        set ev [$self cget -notoccupiedeventid]
        if {$ev ne {} && [$ev match $event]} {
            set occupied no
        }
        MainWindow ctcpanel invoke "$options(-name)"
    }
}

snit::type Dispatcher_Switch {
    option -openlcb -type ::OpenLCB_Dispatcher -readonly yes
    option -name    -default {}
    option -occupiedeventid -type lcc::EventID_or_null -default {}
    option -notoccupiedeventid -type lcc::EventID_or_null -default {}
    variable occupied no
    option -statenormaleventid -type lcc::EventID_or_null -default {}
    option -statereverseeventid -type lcc::EventID_or_null -default {}
    variable state unknown
    constructor {args} {
        $self configurelist $args
        MainWindow ctcpanel itemconfigure "$options(-name)" \
              -occupiedcommand [mymethod occupiedp] \
              -statecommand    [mymethod getstate]
    }
    method occupiedp {} {return $occupied}
    method getstate  {} {return $state}
    method consumerP {} {return yes}
    method producerP {} {return no}
    method consumedEvents {} {
        set events [list]
        foreach eopt {occupiedeventid notoccupiedeventid statenormaleventid 
                      statereverseeventid} {
            set ev [$self cget -$eopt]
            if {$ev eq {}} {continue}
            lappend events $ev
        }
        return $events
    }
    method producedEvents {} {return [list]}
    method consumeEvent {event} {
        set ev [$self cget -occupiedeventid]
        if {$ev ne {} && [$ev match $event]} {
            set occupied yes
        }
        set ev [$self cget -notoccupiedeventid]
        if {$ev ne {} && [$ev match $event]} {
            set occupied no
        }
        set ev [$self cget -statenormaleventid]
        if {$ev ne {} && [$ev match $event]} {
            set state normal
        }
        set ev [$self cget -statereverseeventid]
        if {$ev ne {} && [$ev match $event]} {
            set state reverse
        }
        MainWindow ctcpanel invoke "$options(-name)"
    }
}

snit::enum CTC_AspectColors -values {dark red yellow green white blue}

snit::listtype CTC_AspectList -type CTC_AspectColors
    
snit::type CTC_EventAspectList {
    pragma  -hastypeinfo no -hastypedestroy no -hasinstances no
    typemethod validate {object} {
        if {([llength $object] & 1) != 0} {
            if {([llength $object] & 1) != 0} {
                error [_ "Not an CTC_EventAspectList: %s (odd list length)" $object]
            } else {
                foreach {e al} $object {
                    if {[catch {lcc::EventID validate $e}]} {
                        error [_ "Not an CTC_EventAspectList: %s (badevent: %s)" $object $e]
                    }
                }
                if {[catch { validate $al}]} {
                    error [_ "Not an CTC_EventAspectList: %s (bad AspectArgumentList: %s)" $object $al]
                }
            }
        }
        return $object
    }
}



snit::type Dispatcher_Signal {
    option -openlcb -type ::OpenLCB_Dispatcher -readonly yes
    option -name    -default {}
    option -eventidaspectlist -type CTC_EventAspectList -default {}
    constructor {args} {
        $self configurelist $args
    }
    method consumerP {} {return yes}
    method producerP {} {return no}    
    method consumedEvents {} {
        set events [list]
        foreach {ev aspl} [$self cget -eventidaspectlist] {
            lappend events $ev
        }
        return $events
    }
    method producedEvents {} {return [list]}
    method consumeEvent {event} {
        foreach {ev aspl} [$self cget -eventidaspectlist] {
            if {[$ev match $event]} {
                MainWindow ctcpanel setv "$options(-name)" "$aspl"
            }
        }
    }
}


snit::type Dispatcher_CodeButton {
    option -openlcb -type ::OpenLCB_Dispatcher -readonly yes
    option -name    -default {}
    option -eventid -type lcc::EventID_or_null -default {}
    constructor {args} {
        $self configurelist $args
        MainWindow ctcpanel itemconfigure "$options(-name)" \
              -command [mymethod code]
    }
    method consumerP {} {return no}
    method producerP {} {return yes}    
    method consumedEvents {} {return [list]}
    method producedEvents {} {
        set events [list]
        set ev [$self cget -eventid]
        if {$ev ne ""} {lappend events $ev}
        return $events
    }
    method code {} {
        set cp [MainWindow ctcpanel itemcget [$self cget -name] -controlpoint]
        set ev [$self cget -eventid]
        if {$ev ne ""} {
            [$self cget -openlcb] sendMyEvent $ev
        }
        foreach swp [MainWindow ctcpanel objectlist $cp SwitchPlates] {
            MainWindow ctcpanel invoke $swp
        }
        foreach sgp [MainWindow ctcpanel objectlist $cp SignalPlates] {
            MainWindow ctcpanel invoke $sgp
        }
        foreach tog [MainWindow ctcpanel objectlist $cp Toggles] {
            MainWindow ctcpanel invoke $tog
        }
        foreach push [MainWindow ctcpanel objectlist $cp PushButtons] {
            MainWindow ctcpanel invoke $push
        }
    }
}

snit::type Dispatcher_Lamp {
    option -openlcb -type ::OpenLCB_Dispatcher -readonly yes
    option -name    -default {}
    option -oneventid  -type lcc::EventID_or_null -default {}
    option -offeventid -type lcc::EventID_or_null -default {}
    constructor {args} {
        $self configurelist $args
    }
    method consumerP {} {return yes}
    method producerP {} {return no}
    method consumedEvents {} {
        set events [list]
        foreach eopt {oneventid offeventid} {
            set ev [$self cget -$eopt]
            if {$ev ne ""} {lappend events $ev}
        }
        return $events
    }
    method producedEvents {} {return [list]}
    method consumeEvent {event} {
        set ev [$self cget -oneventid]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel setv "$options(-name)" on
        }
        set ev [$self cget -offeventid]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel setv "$options(-name)" off
        }
    }
}

snit::type Dispatcher_ToggleSwitch {
    option -openlcb -type ::OpenLCB_Dispatcher -readonly yes
    option -name    -default {}
    option -lefteventid   -type lcc::EventID_or_null -default {}
    option -righteventid  -type lcc::EventID_or_null -default {}
    option -centereventid -type lcc::EventID_or_null -default {}
    constructor {args} {
        $self configurelist $args
        MainWindow ctcpanel itemconfigure "$options(-name)" \
              -leftcommand [mymethod sendevent -lefteventid] \
              -rightcommand [mymethod sendevent -righteventid] \
              -centercommand [mymethod sendevent -centereventid]
    }
    method sendevent {eopt} {
        set ev [$self cget $eopt]
        if {$ev ne ""} {
            [$self cget -openlcb] sendMyEvent $ev
        }
    }
    method consumerP {} {return no}
    method producerP {} {return yes}
    method consumedEvents {} {return [list]}
    method producedEvents {} {
        set events [list]
        foreach eopt {lefteventid righteventid centereventid} {
            set ev [$self cget -$eopt]
            if {$ev ne ""} {lappend events $ev}
        }
        return $events
    }
    method consumeEvent {event} {}
}

snit::type Dispatcher_PushButton {
    option -openlcb -type ::OpenLCB_Dispatcher -readonly yes
    option -name    -default {}
    option -eventid -type lcc::EventID_or_null -default {}
    constructor {args} {
        $self configurelist $args
        MainWindow ctcpanel itemconfigure "$options(-name)" \
              -command [mymethod sendevent -eventid]
    }
    method sendevent {eopt} {
        set ev [$self cget $eopt]
        if {$ev ne ""} {
            [$self cget -openlcb] sendMyEvent $ev
        }
    }
    method consumerP {} {return no}
    method producerP {} {return yes}
    method consumedEvents {} {return [list]}
    method producedEvents {} {
        set events [list]
        set ev [$self cget -eventid]
        if {$ev ne ""} {lappend events $ev}
        return $events
    }
    method consumeEvent {event} {}
}

snit::type Dispatcher_SwitchPlate {
    option -openlcb -type ::OpenLCB_Dispatcher -readonly yes
    option -name    -default {}
    option -normaleventid   -type lcc::EventID_or_null -default {}
    option -reverseeventid  -type lcc::EventID_or_null -default {}
    option -normalindonev   -type lcc::EventID_or_null -default {}
    option -normalindoffev  -type lcc::EventID_or_null -default {}
    option -centerindonev   -type lcc::EventID_or_null -default {}
    option -centerindoffev  -type lcc::EventID_or_null -default {}
    option -reverseindonev  -type lcc::EventID_or_null -default {}
    option -reverseindoffev -type lcc::EventID_or_null -default {}
    constructor {args} {
        $self configurelist $args
        MainWindow ctcpanel itemconfigure "$options(-name)" \
              -normalcommand [mymethod sendevent -normaleventid] \
              -reversecommand [mymethod sendevent -reverseeventid]
    }
    method sendevent {eopt} {
        set ev [$self cget $eopt]
        if {$ev ne ""} {
            [$self cget -openlcb] sendMyEvent $ev
        }
    }
    method consumerP {} {return yes}
    method producerP {} {return yes}
    method consumedEvents {} {
        set events [list]
        foreach eopt {normalindonev normalindoffev centerindonev 
                      centerindoffev reverseindonev reverseindoffev} {
            set ev [$self cget -$eopt]
            if {$ev ne ""} {lappend events $ev}
        }
    }
    method producedEvents {} {
        set events [list]
        foreach eopt {normaleventid reverseeventid} {
            set ev [$self cget -$eopt]
            if {$ev ne ""} {lappend events $ev}
        }
        return $events
    }
    method consumeEvent {event} {
        set ev [$self cget -normalindonev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" N on
        }
        set ev [$self cget -normalindoffev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" N off
        }
        set ev [$self cget -centerindonev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" C on
        }
        set ev [$self cget -centerindoffev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" C off
        }
        set ev [$self cget -reverseindonev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" R on
        }
        set ev [$self cget -reverseindoffev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" R off
        }
    }
}

snit::type Dispatcher_SignalPlate {
    option -openlcb -type ::OpenLCB_Dispatcher -readonly yes
    option -name    -default {}
    option -lefteventid     -type lcc::EventID_or_null -default {}
    option -centereventid   -type lcc::EventID_or_null -default {}
    option -righteventid    -type lcc::EventID_or_null -default {}
    option -leftindonev     -type lcc::EventID_or_null -default {}
    option -leftindoffev    -type lcc::EventID_or_null -default {}
    option -centerindonev   -type lcc::EventID_or_null -default {}
    option -centerindoffev  -type lcc::EventID_or_null -default {}
    option -rightindonev  -type lcc::EventID_or_null -default {}
    option -rightindoffev -type lcc::EventID_or_null -default {}
    
    constructor {args} {
        $self configurelist $args
        MainWindow ctcpanel itemconfigure "$options(-name)" \
              -leftcommand [mymethod sendevent -lefteventid] \
              -centercommand [mymethod sendevent -centereventid] \
              -reversecommand [mymethod sendevent -righteventid]
    }
    method sendevent {eopt} {
        set ev [$self cget $eopt]
        if {$ev ne ""} {
            [$self cget -openlcb] sendMyEvent $ev
        }
    }
    method consumerP {} {return yes}
    method producerP {} {return yes}
    method consumedEvents {} {
        set events [list]
        foreach eopt {leftindonev leftindoffev centerindonev 
                      centerindoffev rightindonev rightindoffev} {
            set ev [$self cget -$eopt]
            if {$ev ne ""} {lappend events $ev}
        }
    }
    method producedEvents {} {
        set events [list]
        foreach eopt {lefteventid righteventid centereventid} {
            set ev [$self cget -$eopt]
            if {$ev ne ""} {lappend events $ev}
        }
        return $events
    }
    method consumeEvent {event} {
        set ev [$self cget -leftindonev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" L on
        }
        set ev [$self cget -leftindoffev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" L off
        }
        set ev [$self cget -centerindonev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" C on
        }
        set ev [$self cget -centerindoffev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" C off
        }
        set ev [$self cget -rightindonev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" R on
        }
        set ev [$self cget -rightindoffev]
        if {$ev ne "" && [$ev match $event]} {
            MainWindow ctcpanel seti "$options(-name)" R off
        }
    }
}

snit::enum ElementClasses -values {Block Switch Signal CodeButton Lamp 
    ToggleSwitch SwitchPlate SignalPlate 
    PushButton}

snit::type OpenLCB_Dispatcher {
    ## OpenLCB Interface code for Dispatcher panels
    #
    # The typemethods implement the interface to the OpenLCB network, and the
    # instances implement the interface to Dispatcher panel elements. The
    # instances use a helper type to implement a specific Dispatcher panel 
    # element type.
    # 
    #
    
    typecomponent transport; #        Transport layer
    typevariable  elelist {};#        List of elements
    typevariable  consumers {};#      Element instances that consume events
    typevariable  eventsconsumed {};# Events consumed.
    typevariable  producers {};#      Element instances that produce events
    typevariable  eventsproduced {};# Events produced.
    typevariable  eventlogging no;#   Event logging
    typecomponent eventlog;#          Event log window
    typecomponent nodetreetop;#       Node Tree toplevel
    typecomponent nodetreemain;#      Node Tree Main window
    typecomponent nodetree;#          Node Tree
    
    typeconstructor {
        set eventlog {}
        set nodetree {}
        set nodetreemain {}
        set nodetreetop {}
    }

    typemethod PopulateOpenLCBMenu {} {
        MainWindow main menu add openlcb checkbutton \
              -label [_m {Menu|OpenLCB|Event Logging}] \
              -variable [mytypevar eventlogging] \
              -onvalue yes -offvalue no
        MainWindow main menu add openlcb command \
              -label [_m {Menu|OpenLCB|Open Eventlog}] \
              -command [mytypemethod _OpenEventlog]
        MainWindow main menu add openlcb command \
              -label [_m {Menu|OpenLCB|Open Node Tree}] \
              -command [mytypemethod _OpenNodeTree]
    }
    
    typemethod _OpenEventlog {} {
        if {![winfo exists $eventlog]} {
            set eventlog [lcc::EventLog .eventlog%AUTO% \
                          -transport $transport \
                          -localeventhandler [mytypemethod _localeventhandler]]
        }
        $eventlog open
    }
    typemethod _OpenNodeTree {} {
        if {![winfo exists $nodetree]} {
            catch {.nodetreetop destroy}
            set nodetreetop [toplevel .nodetreetop]
            set nodetreemain [mainwindow $nodetreetop.main -scrolling yes \
                              -height 480 -width 640 \
                              -menu [subst {
                                     "[_m {Menu|&File}]" {file:menu} {file} 0 {
                                         {command "[_m {Menu|File|&Close}]" 
                                             {file:close} 
                                             "[_ {Close the Node Tree}]" 
                                             {Ctrl c} 
                                             -command "[mytypemethod _closeNodeTree]"}}}]]
            pack $nodetreemain -expand yes -fill both
            wm protocol $nodetreetop WM_DELETE_WINDOW \
                  [mytypemethod _closeNodeTree]
            set nodetree [LCCNodeTree [$nodetreemain scrollwindow getframe].nodetree \
                          -transport $transport]
            $nodetreemain scrollwindow setwidget $nodetree
        }
        $nodetreemain showit
    }
    typemethod _closeNodeTree {} {
        if {[winfo exists $nodetree]} {
            wm withdraw $nodetreetop
        }
    }
    typemethod ConnectToOpenLCB {args} {
        #puts stderr "*** $type ConnectToOpenLCB $args"
        set transportConstructors [info commands ::lcc::[from args -transport]]
        if {[llength $transportConstructors] > 0} {
            set transportConstructor [lindex $transportConstructors 0]
        }
        if {$transportConstructor eq {}} {
            error [_ "No valid transport constructor found!"]
            exit 96
        }
        set name [from args -name]
        set description [from args -description]
        if {[catch {eval [list lcc::OpenLCBNode %AUTO% \
                          -transport $transportConstructor \
                          -eventhandler [mytypemethod _eventHandler] \
                          -generalmessagehandler [mytypemethod _messageHandler] \
                          -softwaremodel "Dispatcher Panel" \
                          -softwareversion "1.0" \
                          -nodename $name \
                          -nodedescription $description \
                          -additionalprotocols {EventExchange} \
                          ] \
                          $args} transport]} {
            error [_ "Could not open OpenLCBNode: %s" $transport]
            exit 95
        }
        $transport SendVerifyNodeID
        $transport IdentifyEvents
        #puts stderr "*** $type ConnectToOpenLCB: transport = $transport"
    }
    typemethod SendMyEvents {} {
        foreach ev $eventsconsumed {
            $transport ConsumerIdentified $ev unknown
        }
        foreach ev $eventsproduced {
            $transport ProducerIdentified $ev unknown
        }
    }
    typemethod sendEvent {event} {
        #** Send an event, after first checking for local consumtion.
        #
        # @param event The event to process
        
        foreach c $consumers {
            $c consumeEvent $event
        }
        $transport ProduceEvent $event
    }
    typemethod _eventHandler {command eventid {validity {}}} {
        #* Event Exchange handler.  Handle Event Exchange messages.
        #
        # @param command The type of event operation.
        # @param eventid The eventid.
        # @param validity The validity of the event.
        
        #puts stderr "*** $type _eventHandler $command $eventid $validity"
        switch $command {
            consumerrangeidentified {
            }
            consumeridentified {
            }
            producerrangeidentified {
            }
            produceridentified {
                if {$validity eq "valid"} {
                    foreach c $consumers {
                        #puts stderr "*** $type _eventHandler: c is $c"
                        #puts stderr "*** $type _eventHandler: event is [$eventid cget -eventidstring]"
                        $c consumeEvent $eventid
                        
                    }
                    if {$eventlogging} {
                        if {![winfo exists $eventlog]} {
                            set eventlog [lcc::EventLog .eventlog%AUTO% \
                                          -transport $transport]
                        }
                        $eventlog eventReceived $eventid
                        $eventlog open
                    }
                }
            }
            learnevents {
            }
            identifyconsumer {
                foreach ev $eventsconsumed {
                    if {[$eventid match $ev]} {
                        $transport ConsumerIdentified $ev unknown
                    }
                }
            }
            identifyproducer {
                foreach ev $eventsproduced {
                    if {[$eventid match $ev]} {
                        $transport ProducerIdentified $ev unknown
                    }
                }
            }
            identifyevents {
                foreach ev $eventsconsumed {
                    $transport ConsumerIdentified $ev unknown
                }
                foreach ev $eventsproduced {
                    $transport ProducerIdentified $ev unknown
                }
            }
            report {
                #puts stderr "*** $type _eventHandler: consumers is $consumers"
                foreach c $consumers {
                    #puts stderr "*** $type _eventHandler: c is $c"
                    #puts stderr "*** $type _eventHandler: event is [$eventid cget -eventidstring]"
                    $c consumeEvent $eventid
                    
                }
                if {$eventlogging} {
                    if {![winfo exists $eventlog]} {
                        set eventlog [lcc::EventLog .eventlog%AUTO% \
                                      -transport $transport]
                    }
                    $eventlog eventReceived $eventid
                    $eventlog open
                }
            }
        }
    }
    typemethod _localeventhandler {eventid} {
        #* Local Event handler.  Handle local Events from the event log dialog.
        #
        # @param eventid The eventid.
        
        foreach c $consumers {
            #puts stderr "*** $type _localeventhandler: c is $c"
            #puts stderr "*** $type _localeventhandler: event is [$eventid cget -eventidstring]"
            $c consumeEvent $eventid
        }
    }
    typemethod _messageHandler {message} {
        #** General message handler.
        #
        # @param message The OpenLCB message
        
        switch [format {0x%04X} [$message cget -mti]] {
            0x0490 -
            0x0488 {
                #* Verify Node ID
                $transport SendMyNodeVerifcation
            }
            0x0828 {
                #* Protocol Support Inquiry
                $transport SendMySupportedProtocols [$message cget -sourcenid]
            }
            0x0DE8 {
                #* Simple Node Information Request
                $transport SendMySimpleNodeInfo [$message cget -sourcenid]
            }
            default {
            }
        }
        if {[winfo exists $nodetree]} {
            $nodetree messageHandler $message
        }
    }
    
    typemethod validate {object} {
        if {[catch {$object info type} otype]} {
            error [_ "Not an OpenLCB_Dispatcher: %s" $object]
        } elseif {$otype ne $type} {
            error [_ "Not an OpenLCB_Dispatcher: %s" $object]
        } else {
            return $object
        }
    }
    
    component elehandler -inherit yes;# Element handler object.
    option -eleclasstype -type ElementClasses -readonly yes
    option -description -readonly yes -default {}
    
    constructor {args} {
        #** Construct a Acela I/O instance
        #
        # @param ... Options:
        # @arg -eleclasstype The I/O class.  Readonly, no default.
        # @par Additional options from the I/O class.
        
        #puts stderr "*** $type create $self $args"
        set options(-eleclasstype) [from args -eleclasstype]
        #puts stderr "*** $type create $self: options(-eleclasstype) = $options(-eleclasstype)"
        set options(-description) [from args -description]
        #puts stderr "*** $type create $self: options(-description) is '$options(-description)'"
        set classconstructor Dispatcher_$options(-eleclasstype)
        set elehandler [eval [list $classconstructor %AUTO% -openlcb $self] \
                        $args]
        lappend elelist $self
        if {[$self consumerP]} {
            lappend consumers $self
            foreach ev [$self consumedEvents] {
                lappend eventsconsumed $ev
            }
        }
        if {[$self producerP]} {
            lappend producers $self
            foreach ev [$self producedEvents] {
                lappend eventsproduced $ev
            }
        }
        
    }
    method sendMyEvent {eventid} {
        $type sendEvent $eventid
    }
}

OpenLCB_Dispatcher PopulateOpenLCBMenu
OpenLCB_Dispatcher ConnectToOpenLCB -transport CANGridConnectOverCANSocket -nid 05:01:01:01:22:ff -socketname vcan0 -name {Crossing Interchange} -description {CrossingInterchange.tcl}
# OpenLCB_Dispatcher Nodes
# OpenLCB_Dispatcher SW1_Plate -eleclasstype SwitchPlate -normaleventid 05.01.01.01.22.00.01.01 -reverseeventid 05.01.01.01.22.00.01.02 -normalindonev 05.01.01.01.22.00.01.03 -normalindoffev 05.01.01.01.22.00.01.04 -reverseindonev 05.01.01.01.22.00.01.04 -reverseindoffev 05.01.01.01.22.00.01.03
OpenLCB_Dispatcher create %AUTO% -name SW1_Plate \
	-eleclasstype SwitchPlate \
	-normaleventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.01}] \
	-reverseeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.02}] \
	-normalindonev [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.03}] \
	-normalindoffev [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.04}] \
	-reverseindonev [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.04}] \
	-reverseindoffev [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.03}]
# OpenLCB_Dispatcher Crossing -eleclasstype Block -occupiedeventid 05.01.01.01.22.00.00.0b -notoccupiedeventid 05.01.01.01.22.00.00.0c
OpenLCB_Dispatcher create %AUTO% -name Crossing \
	-eleclasstype Block \
	-occupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.0b}] \
	-notoccupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.0c}]
# OpenLCB_Dispatcher S3S -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.03.40 green 05.01.01.01.22.00.03.41 yellow 05.01.01.01.22.00.03.42 red}
OpenLCB_Dispatcher create %AUTO% -name S3S \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.40}] \
{green} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.41}] \
{yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.42}] \
{red} \
	]
# OpenLCB_Dispatcher SW2_Plate -eleclasstype SwitchPlate -normaleventid 05.01.01.01.22.00.02.01 -reverseeventid 05.01.01.01.22.00.02.02 -normalindonev 05.01.01.01.22.00.02.03 -normalindoffev 05.01.01.01.22.00.02.04 -reverseindonev 05.01.01.01.22.00.02.04 -reverseindoffev 05.01.01.01.22.00.02.03
OpenLCB_Dispatcher create %AUTO% -name SW2_Plate \
	-eleclasstype SwitchPlate \
	-normaleventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.01}] \
	-reverseeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.02}] \
	-normalindonev [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.03}] \
	-normalindoffev [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.04}] \
	-reverseindonev [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.04}] \
	-reverseindoffev [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.03}]
# OpenLCB_Dispatcher MainTwoSouth -eleclasstype Block -occupiedeventid 05.01.01.01.22.00.00.0f -notoccupiedeventid 05.01.01.01.22.00.00.10
OpenLCB_Dispatcher create %AUTO% -name MainTwoSouth \
	-eleclasstype Block \
	-occupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.0f}] \
	-notoccupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.10}]
# OpenLCB_Dispatcher MainOneWest -eleclasstype Block -occupiedeventid 05.01.01.01.22.00.00.0d -notoccupiedeventid 05.01.01.01.22.00.00.0e
OpenLCB_Dispatcher create %AUTO% -name MainOneWest \
	-eleclasstype Block \
	-occupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.0d}] \
	-notoccupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.0e}]
# OpenLCB_Dispatcher S3E -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.03.30 green 05.01.01.01.22.00.03.31 yellow 05.01.01.01.22.00.03.32 red}
OpenLCB_Dispatcher create %AUTO% -name S3E \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.30}] \
{green} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.31}] \
{yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.32}] \
{red} \
	]
# OpenLCB_Dispatcher S2IE -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.02.30 green 05.01.01.01.22.00.02.31 yellow 05.01.01.01.22.00.02.32 red}
OpenLCB_Dispatcher create %AUTO% -name S2IE \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.30}] \
{green} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.31}] \
{yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.32}] \
{red} \
	]
# OpenLCB_Dispatcher SW1 -eleclasstype Switch -occupiedeventid 05.01.01.01.22.00.00.01 -notoccupiedeventid 05.01.01.01.22.00.00.02 -statenormaleventid 05.01.01.01.22.00.01.03 -statereverseeventid 05.01.01.01.22.00.01.04
OpenLCB_Dispatcher create %AUTO% -name SW1 \
	-eleclasstype Switch \
	-occupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.01}] \
	-notoccupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.02}] \
	-statenormaleventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.03}] \
	-statereverseeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.04}]
# OpenLCB_Dispatcher SW2 -eleclasstype Switch -occupiedeventid 05.01.01.01.22.00.00.03 -notoccupiedeventid 05.01.01.01.22.00.00.04 -statenormaleventid 05.01.01.01.22.00.02.03 -statereverseeventid 05.01.01.01.22.00.02.04
OpenLCB_Dispatcher create %AUTO% -name SW2 \
	-eleclasstype Switch \
	-occupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.03}] \
	-notoccupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.04}] \
	-statenormaleventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.03}] \
	-statereverseeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.04}]
# OpenLCB_Dispatcher S3W -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.03.10 green 05.01.01.01.22.00.03.11 yellow 05.01.01.01.22.00.03.12 red}
OpenLCB_Dispatcher create %AUTO% -name S3W \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.10}] \
{green} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.11}] \
{yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.12}] \
{red} \
	]
# OpenLCB_Dispatcher S2ME -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.02.20 green 05.01.01.01.22.00.02.21 yellow 05.01.01.01.22.00.02.22 red}
OpenLCB_Dispatcher create %AUTO% -name S2ME \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.20}] \
{green} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.21}] \
{yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.22}] \
{red} \
	]
# OpenLCB_Dispatcher Interchange -eleclasstype Block -occupiedeventid 05.01.01.01.22.00.00.05 -notoccupiedeventid 05.01.01.01.22.00.00.06
OpenLCB_Dispatcher create %AUTO% -name Interchange \
	-eleclasstype Block \
	-occupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.05}] \
	-notoccupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.06}]
# OpenLCB_Dispatcher S1IN -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.01.30 green 05.01.01.01.22.00.01.31 yellow 05.01.01.01.22.00.01.32 red}
OpenLCB_Dispatcher create %AUTO% -name S1IN \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.30}] \
{green} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.31}] \
{yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.32}] \
{red} \
	]
# OpenLCB_Dispatcher Code1 -eleclasstype CodeButton
OpenLCB_Dispatcher create %AUTO% -name Code1 \
	-eleclasstype CodeButton \

# OpenLCB_Dispatcher S2W -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.02.10 {green red} 05.01.01.01.22.00.02.11 {yellow red} 05.01.01.01.22.00.02.12 {red yellow} 05.01.01.01.22.00.02.13 {red red}}
OpenLCB_Dispatcher create %AUTO% -name S2W \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.10}] \
{green red} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.11}] \
{yellow red} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.12}] \
{red yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.02.13}] \
{red red} \
	]
# OpenLCB_Dispatcher S3N -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.03.20 green 05.01.01.01.22.00.03.21 yellow 05.01.01.01.22.00.03.22 red}
OpenLCB_Dispatcher create %AUTO% -name S3N \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.20}] \
{green} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.21}] \
{yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.03.22}] \
{red} \
	]
# OpenLCB_Dispatcher Code2 -eleclasstype CodeButton
OpenLCB_Dispatcher create %AUTO% -name Code2 \
	-eleclasstype CodeButton \

# OpenLCB_Dispatcher MainTwo -eleclasstype Block -occupiedeventid 05.01.01.01.22.00.00.09 -notoccupiedeventid 05.01.01.01.22.00.00.0a
OpenLCB_Dispatcher create %AUTO% -name MainTwo \
	-eleclasstype Block \
	-occupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.09}] \
	-notoccupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.0a}]
# OpenLCB_Dispatcher MainOne -eleclasstype Block -occupiedeventid 05.01.01.01.22.00.00.07 -notoccupiedeventid 05.01.01.01.22.00.00.08
OpenLCB_Dispatcher create %AUTO% -name MainOne \
	-eleclasstype Block \
	-occupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.07}] \
	-notoccupiedeventid [lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.00.08}]
# OpenLCB_Dispatcher S1S -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.01.10 {green red} 05.01.01.01.22.00.01.11 {yellow red} 05.01.01.01.22.00.01.12 {red yellow} 05.01.01.01.22.00.01.13 {red red}}
OpenLCB_Dispatcher create %AUTO% -name S1S \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.10}] \
{green red} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.11}] \
{yellow red} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.12}] \
{red yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.13}] \
{red red} \
	]
# OpenLCB_Dispatcher S1MN -eleclasstype Signal -eventidaspectlist {05.01.01.01.22.00.01.20 green 05.01.01.01.22.00.01.21 yellow 05.01.01.01.22.00.01.22 red}
OpenLCB_Dispatcher create %AUTO% -name S1MN \
	-eleclasstype Signal \
	-eventidaspectlist [list \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.20}] \
{green} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.21}] \
{yellow} \
		[lcc::EventID %AUTO% -eventidstring {05.01.01.01.22.00.01.22}] \
{red} \
	]
OpenLCB_Dispatcher SendMyEvents
