#!/usr/bin/wish
# Generated code: Mon Mar 10 10:19:59 EDT 2014
# Generated by: $Id: CTCPanelWindow.tcl 709 2009-05-01 15:20:49Z heller $
# Add your code to the bottom (after the 'Add User code after this line').
#
# -name {Example 3: double track crossover}
# -width 780
# -height 550
# -hascmri yes
# -cmriport /dev/ttyS2
# -cmrispeed 9600
# -cmriretries 10000
# -hasazatrax no
# -simplemode no
# additionalPackages
# Load Tcl/Tk system supplied packages
package require Tk;#		Make sure Tk is loaded
package require tile;#          Load tile
package require snit;#		Load Snit

# Load MRR System packages
# Add MRR System package Paths
lappend auto_path /usr/local/lib/MRRSystem;# C++ (binary) packages
lappend auto_path /usr/local/share/MRRSystem;# Tcl (source) packages

package require snitStdMenuBar;#  Load the standard menu bar package
package require LabelFrames;#   Label frame widgets
package require MainFrame;#     Main Frame widget
package require ScrollableFrame;#     Scrollable Frame widget
package require MainWindow;#    Load the Main Window package
package require CTCPanel 2.0;#  Load the CTCPanel package (V2)
package require grsupport 2.0;# Load Graphics Support code (V2)

#* 
#* ------------------------------------------------------------------
#* panelCode.tcl - Panel Main Window Creation Library
#* Created by Robert Heller on Sun Apr 13 18:27:24 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: panelCode.tcl 625 2008-04-21 23:39:05Z heller $

snit::type MainWindow {
  pragma -hastypeinfo    no
  pragma -hastypedestroy no
  pragma -hasinstances   no

  typecomponent main
  typecomponent swframe
  typecomponent ctcpanel

  delegate typemethod {ctcpanel *} to ctcpanel
  delegate typemethod {main *} to main
  typemethod createwindow {args} {
    set name [from args -name {}]
    set width [from args -width 800]
    set height [from args -height 800]
    wm protocol . WM_DELETE_WINDOW [mytypemethod CarefulExit]
    wm withdraw .
    wm title . "$name"
    set main [mainwindow .main]
    pack $main -expand yes -fill both
    $main menu entryconfigure file New -state disabled
    $main menu entryconfigure file Open... -state disabled
    $main menu entryconfigure file Save -state disabled
    $main menu entryconfigure file {Save As...} -state disabled
    $main menu entryconfigure file Print... -state disabled
    $main menu entryconfigure file Close -command [mytypemethod CarefulExit]
    $main menu entryconfigure file Exit -command [mytypemethod CarefulExit]
    set frame [$main scrollwindow getframe]
    set swframe [ScrollableFrame $frame.swframe \
			-constrainedheight yes -constrainedwidth yes \
			-width [expr {$width + 15}] -height $height]
    $main scrollwindow setwidget $swframe
    set ctcpanel [::CTCPanel::CTCPanel [$swframe getframe].ctcpanel \
			-width $width -height $height]
    pack $ctcpanel -fill both -expand yes
    $main menu add view command \
		-label {Zoom In} \
		-accelerator {+} \
		-command "$ctcpanel zoomBy 2"
    set zoomMenu [menu [$main mainframe getmenu view].zoom -tearoff no]
    $main menu add view cascade \
		-label Zoom \
		-menu $zoomMenu
    $main menu add view command \
		-label {Zoom Out} \
		-accelerator {-} \
		-command "$ctcpanel zoomBy .5"
    $zoomMenu add command -label {16:1} -command "$ctcpanel setZoom 16"
    $zoomMenu add command -label {8:1} -command "$ctcpanel setZoom 8"
    $zoomMenu add command -label {4:1} -command "$ctcpanel setZoom 4"
    $zoomMenu add command -label {2:1} -command "$ctcpanel setZoom 2"
    $zoomMenu add command -label {1:1} -command "$ctcpanel setZoom 1"
    $zoomMenu add command -label {1:2} -command "$ctcpanel setZoom .5"
    $zoomMenu add command -label {1:4} -command "$ctcpanel setZoom .25"
    $zoomMenu add command -label {1:8} -command "$ctcpanel setZoom .125"
    $zoomMenu add command -label {1:16} -command "$ctcpanel setZoom .0625"

    $main showit
  }
  typemethod CarefulExit {{answer no}} {
    if {!$answer} {
      set answer [tk_messageBox -default no -icon question \
			-message {Really Quit?} -title {Careful Exit} \
			-type yesno -parent $main]
      if {$answer} {exit}
    }
  }  
}

MainWindow createwindow -name {Example 3: double track crossover} -width 780 -height 550
# CTCPanelObjects
MainWindow ctcpanel create StraightBlock BK5T2 \
	-x1 676.0 \
	-y1 130.0 \
	-x2 780.0 \
	-y2 130.0 \
	-controlpoint Main \
	-label BK5T2 \
	-position above \
	-occupiedcommand {::Blocks::BK5T2 occupiedp}
MainWindow ctcpanel create Switch SW2a \
	-x 712 \
	-y 170 \
	-label 2 \
	-controlpoint Main \
	-orientation 4 \
	-flipped no \
	-statecommand {::Switches::SW2a getstate} \
	-occupiedcommand {::Switches::SW2a occupiedp}
MainWindow ctcpanel create Switch SW2b \
	-x 632.0 \
	-y 130.0 \
	-label {} \
	-controlpoint CP2 \
	-orientation 0 \
	-flipped no \
	-statecommand {::Switches::SW2b getstate} \
	-occupiedcommand {::Switches::SW2b occupiedp}
MainWindow ctcpanel create SWPlate CP1SW \
	-x 75.0 \
	-y 60.0 \
	-label 1 \
	-controlpoint CP1 \
	-normalcommand {::SwitchPlates::CP1SW setlever normal} \
	-reversecommand {::SwitchPlates::CP1SW setlever reverse}
MainWindow ctcpanel create CodeButton CP1Code \
	-x 75 \
	-y 200.0 \
	-controlpoint CP1 \
	-command {::ControlPoints::CP1 code}
MainWindow ctcpanel create SWPlate CP2SW \
	-x 695.0 \
	-y 61.0 \
	-label 2 \
	-controlpoint CP2 \
	-normalcommand {::SwitchPlates::CP2SW setlever normal} \
	-reversecommand {::SwitchPlates::CP2SW setlever reverse}
MainWindow ctcpanel create CodeButton CP2Code \
	-x 695 \
	-y 200.0 \
	-controlpoint CP2 \
	-command {::ControlPoints::CP2 code}
MainWindow ctcpanel create SIGPlate CP1T1SG \
	-x 75.0 \
	-y 150.0 \
	-label 1.1 \
	-controlpoint CP1 \
	-leftcommand {::SignalPlates::CP1T1SG setlever left} \
	-centercommand {::SignalPlates::CP1T1SG setlever center} \
	-rightcommand {::SignalPlates::CP1T1SG setlever right}
MainWindow ctcpanel create StraightBlock BK1T1 \
	-x1 4.0 \
	-y1 170.0 \
	-x2 45.0 \
	-y2 170.0 \
	-controlpoint CP2 \
	-label BK1T1 \
	-position below \
	-occupiedcommand {::Blocks::BK1T1 occupiedp}
MainWindow ctcpanel create StraightBlock BK1T2 \
	-x1 4.0 \
	-y1 130.0 \
	-x2 86.0 \
	-y2 130.0 \
	-controlpoint Main \
	-label BK1T2 \
	-position above \
	-occupiedcommand {::Blocks::BK1T2 occupiedp}
MainWindow ctcpanel create Switch SW1a \
	-x 50.0 \
	-y 170.0 \
	-label 1 \
	-controlpoint CP1 \
	-orientation 0 \
	-flipped yes \
	-statecommand {::Switches::SW1a getstate} \
	-occupiedcommand {::Switches::SW1a occupiedp}
MainWindow ctcpanel create SIGPlate CP1T2SG \
	-x 150.0 \
	-y 150.0 \
	-label 1.2 \
	-controlpoint CP1 \
	-leftcommand {::SignalPlates::CP1T2SG setlever left} \
	-centercommand {::SignalPlates::CP1T2SG setlever center} \
	-rightcommand {::SignalPlates::CP1T2SG setlever right}
MainWindow ctcpanel create SIGPlate CP2T1SG \
	-x 620 \
	-y 150.0 \
	-label 2.1 \
	-controlpoint CP2 \
	-leftcommand {::SignalPlates::CP2T1SG setlever left} \
	-centercommand {::SignalPlates::CP2T1SG setlever center} \
	-rightcommand {::SignalPlates::CP2T1SG setlever right}
MainWindow ctcpanel create StraightBlock BK3T1 \
	-x1 95.0 \
	-y1 170.0 \
	-x2 667.0 \
	-y2 170.0 \
	-controlpoint Main \
	-label BK3T1 \
	-position below \
	-occupiedcommand {::Blocks::BK3T1 occupiedp}
MainWindow ctcpanel create Switch SW1b \
	-x 130 \
	-y 130 \
	-label {} \
	-controlpoint CP1 \
	-orientation 4 \
	-flipped yes \
	-statecommand {::Switches::SW1b getstate} \
	-occupiedcommand {::Switches::SW1b occupiedp}
MainWindow ctcpanel create SIGPlate CP2T2SG \
	-x 695 \
	-y 150.0 \
	-label 2.2 \
	-controlpoint CP2 \
	-leftcommand {::SignalPlates::CP2T2SG setlever left} \
	-centercommand {::SignalPlates::CP2T2SG setlever center} \
	-rightcommand {::SignalPlates::CP2T2SG setlever right}
MainWindow ctcpanel create StraightBlock BK3T2 \
	-x1 134.0 \
	-y1 130.0 \
	-x2 628.0 \
	-y2 130.0 \
	-controlpoint Main \
	-label BK3T2 \
	-position above \
	-occupiedcommand {::Blocks::BK3T2 occupiedp}
MainWindow ctcpanel create StraightBlock BK5T1 \
	-x1 716.0 \
	-y1 170.0 \
	-x2 781.0 \
	-y2 170.0 \
	-controlpoint Main \
	-label BK5T1 \
	-position below \
	-occupiedcommand {::Blocks::BK5T1 occupiedp}
#* 
#* ------------------------------------------------------------------
#* cmriCode.tcl - CM/RI Library
#* Created by Robert Heller on Sun Apr 13 18:02:03 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: cmriCode.tcl 680 2009-01-07 22:53:14Z heller $

package require Cmri 2.0.0 ;#          Load the CMR/I package.
package require grsupport 2.0

# Snit type to implement a CMR/I node. 
snit::type CMriNode {
  typecomponent CMriBusObject;#		CMR/I I/O object
  typeconstructor {set CMriBusObject {}}
  typemethod open {port speed retries} {
    set CMriBusObject [CMri %%AUTO%% $port -baud  $speed -maxtries $retries]
  }
  typemethod close {} {
    if {[string length "$CMriBusObject"] > 0} {$CMriBusObject destroy}
    set CMriBusObject {}
  }
  # Define the integer verify method.
  GRSupport::VerifyIntegerMethod
  # options used by CMR/I nodes.
  option -ns -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -ni -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -no -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -dl -default 0 -readonly yes \
	 -validatemethod _VerifyInteger
  option -ct -default {} -readonly yes
  variable UA;#				This node's address
    
  constructor {_UA NodeType args} {
    cmri::uatype $_UA;#			Validate the address
    set UA $_UA;#			Stash our address
    $self configurelist $args;#		configure options
    # Determine type of node.
    cmri::CardType validate $NodeType;#	Validate the card type
    switch -exact -- $NodeType {
      SUSIC {set ctype SUSIC}
      USIC  {set ctype USIC}
      SMINI {set ctype SMINI
	     set options(-ni) 3
	     set options(-no) 6
	     set options(-dl) 0}
      default {
	error "Unknown Node Type: $NodeType"
      }
    }
    # Initialize our board.
    $CMriBusObject InitBoard $options(-ct) $options(-ni) \
			       $options(-no) $options(-ns) \
			       $UA $ctype $options(-dl)
  }
  # Input method -- poll our input ports
  method inputs {} {
    return [$CMriBusObject Inputs $options(-ni) $UA]
  }
  # Output method -- write to our output ports
  method outputs {args} {
    return [$CMriBusObject Outputs $args $UA]
  }
}


  


CMriNode open /dev/ttyS2 9600 10000
# CMRIBoards
CMriNode create CP1 0 SMINI -ns 0 -ni 3 -no 6 -dl 0 -ct {}
CMriNode create CP2 1 SMINI -ns 0 -ni 3 -no 6 -dl 0 -ct {}

# Add User code after this line

# This is an example CTC Panel program.  It features a section of double
# tracked mainline with a pair of crossovers
#
# The switches and signals are controled by a pair of SMINI nodes, which also 
# connects occupation detectors and switch point sensors to the host system.
# See example3.iow for I/O connections for this example.
#
# The signals are two headed, three light signals.
#

package require snit;#		Make sure snit is loaded.

# Define types:
# This code uses SNIT to create a set of OO types to encapsulate each of 
# the several elements of the system: trackwork sections (blocks), 
# switches (turnouts), Switch Plates, Signal Plates, Signals, and control
# points.
#

namespace eval Blocks {
  # Block type (general trackwork).
  # Encapsulates block occupation detectors.
  #
  snit::type Block {
    # Occupation state values
    typevariable OCC 1
    typevariable CLR 0
    # Occupation state bit
    variable occupiedbit
    constructor {} {
      set occupiedbit $CLR;#	Initialize to clear.
    }
    # Occupation state methods
    method occupiedp {} {return [expr {$occupiedbit == $OCC}]}
    method setoccupied {value} {
      set occupiedbit $value
    }
  }
  # Main line trackage
  Block BK1T1;#	Block 1, East
  Block BK1T2;#	Block 1, West
  Block BK3T1;#	Block 3, East
  Block BK3T2;#	Block 3, West
  Block BK5T1;#	Block 5, East
  Block BK5T2;#	Block 5, West
}

namespace eval Switches {
  # Switch type (turnout)
  # Encapsulates a switch (turnout), including its OS (delegated to a Block 
  # object), its switch motor, and its point position sensor (its state).
  snit::type Switch {
    component block;#			OS section
    delegate method * to block;#	Delegate block methods
    variable state unknown;#		Sense state (point position)
    # Motor bit values
    typevariable NOR 1;# 01		
    typevariable REV 2;# 10		
    variable motor;#			Motor bits -- used to drive switch 
#					motor.
    constructor {} {
      #					Install OS section
      install block using Blocks::Block %AUTO%
      # Initialize motor bits
      set motor $NOR
    }
    # State methods
    method getstate {} {return $state}
    method setstate {statebits} {
      if {$statebits == $NOR} {
	set state normal
      } elseif {$statebits == $REV} {
	set state reverse
      } else {
	set state unknown
      }
    }
    # Motor bit methods
    method motorbits {} {return $motor}
    method setmotor {mv} {
      switch -exact $mv {
	normal {set motor $NOR}
	reverse {set motor $REV}
      }
    }
  }
  Switch SW1a;#		Switch at CP1
  Switch SW1b;#		Switch at CP1
  Switch SW2a;#		Switch at CP2
  Switch SW2b;#		Switch at CP2
}


namespace eval SwitchPlates {
  # Switch Plate
  # Encapsulates a switch plate, implementing its lever position.
  snit::type SwitchPlate {
    delegate method * to switch
    variable leverpos unknown
    constructor {sw} {
      set switch $sw
    }
    method setlever {pos} {set leverpos $pos}
    method getlever {} {return $leverpos}
  }
  SwitchPlate CP1SW
  SwitchPlate CP2SW
}

namespace eval Signals {
  # Signal types.  Encapsulates a signal's aspect.
  snit::type OneHead {
    # Single head signals have four states: dark, green, yellow, or red.
    typevariable aspects -array {
      Dark	0x00
      Green	0x01
      Yellow	0x02
      Red	0x04
    }
    variable aspectbits
    constructor {} {
      set aspectbits $aspects(Dark)
    }
    method setaspect {a} {set aspectbits $aspects($a)}
    method getaspect {}  {return $aspectbits}
  }
  snit::type TwoHead {
    # Two head signals have five states: dark, green over red, 
    # yellow over red, red over yellow, and red over red.
    typevariable aspects -array {
      Dark	0x00
      GreenRed	0x11
      YellowRed	0x12
      RedYellow	0x0c
      RedRed	0x14
    }
    variable aspectbits
    constructor {} {
      set aspectbits $aspects(Dark)
    }
    method setaspect {a} {set aspectbits $aspects($a)}
    method getaspect {}  {return $aspectbits}
  }
  TwoHead CP1ET1;#	Heading into switch 1 from the west (block 1, Track 1)
  TwoHead CP1WT1;#	Heading into switch 1 from the east (Block 3, Track 1)
  TwoHead CP1ET2;#	Heading into switch 1 from the east (block 1, Track 2)
  TwoHead CP1WT2;#	Heading into switch 1 from the west (Block 3, Track 2)
  TwoHead CP2ET1;#	Heading into switch 1 from the west (block 3, Track 1)
  TwoHead CP2WT1;#	Heading into switch 1 from the east (Block 5, Track 1)
  TwoHead CP2ET2;#	Heading into switch 1 from the east (block 3, Track 2)
  TwoHead CP2WT2;#	Heading into switch 1 from the west (Block 5, Track 2)
}

namespace eval SignalPlates {
  # Signal Plate, encapsulating a signal plate with its lever and indicators.
  snit::type SignalPlate {
    variable leverpos unknown
    option -signalplate -default {} -readonly yes
    constructor {args} {
      $self configurelist $args
    }
    method setlever {pos} {set leverpos $pos}
    method getlever {} {return $leverpos}
    method setdot {dir} {
      switch $dir {
	left {
	  MainWindow ctcpanel seti $options(-signalplate) L on
	  MainWindow ctcpanel seti $options(-signalplate) C off
	  MainWindow ctcpanel seti $options(-signalplate) R off
	}
	right {
	  MainWindow ctcpanel seti $options(-signalplate) L off
	  MainWindow ctcpanel seti $options(-signalplate) C off
	  MainWindow ctcpanel seti $options(-signalplate) R on
	}
	none -
	default {
	  MainWindow ctcpanel seti $options(-signalplate) L off
	  MainWindow ctcpanel seti $options(-signalplate) C on
	  MainWindow ctcpanel seti $options(-signalplate) R off
	}
      }
    }
  }
  SignalPlate CP1T1SG -signalplate CP1T1SG;#Signal plate for CP1, track 1
  SignalPlate CP1T2SG -signalplate TRACK2;#Signal plate for CP1, track 2
  SignalPlate CP2T1SG -signalplate CP1T1SG;#Signal plate for CP2, track 1
  SignalPlate CP2T2SG -signalplate TRACK2;#Signal plate for CP2, track 2
}

namespace eval ControlPoints {
  # Control points.  Used to implement code buttons.  
  # Encapsulates a control point
  snit::type ControlPoint {
    option -cpname -readonly yes -default {}
    constructor {args} {
      $self configurelist $args
    }
    method code {} {
      foreach swp [MainWindow ctcpanel objectlist $options(-cpname) SwitchPlates] {
	MainWindow ctcpanel invoke $swp
      }      
      foreach sgp [MainWindow ctcpanel objectlist $options(-cpname) SignalPlates] {
	MainWindow ctcpanel invoke $sgp
      }
    }
  }
  ControlPoint CP1 -cpname CP1;#	Control point 1
  ControlPoint CP2 -cpname CP2;#	Control point 2
}


# Main Loop Start
while {true} {
  # Read all ports
  set CP1_inbits [CP1 inputs]
  # Occupation Detectors and point state switches: (Input Port A)
  set tempByte [lindex $CP1_inbits 0]
  Blocks::BK1T1 setoccupied  [expr {$tempByte      & 0x01}]
  Blocks::BK1T2 setoccupied  [expr {$tempByte >> 1 & 0x01}]
  Blocks::BK3T1 setoccupied  [expr {$tempByte >> 2 & 0x01}]
  # The both switches are on a common OD for their OSs
  Switches::SW1a setoccupied [expr {$tempByte >> 3 & 0x01}]
  Switches::SW1b setoccupied [expr {$tempByte >> 3 & 0x01}]
  Switches::SW1a setstate    [expr {$tempByte >> 4 & 0x03}]
  Switches::SW1b setstate    [expr {$tempByte >> 6 & 0x03}]
  set CP2_inbits [CP2 inputs]
  # Occupation Detectors and point state switches: (Input Port A)
  set tempByte [lindex $CP2_inbits 0]
  Blocks::BK5T1 setoccupied  [expr {$tempByte      & 0x01}]
  Blocks::BK5T2 setoccupied  [expr {$tempByte >> 1 & 0x01}]
  Blocks::BK3T2 setoccupied  [expr {$tempByte >> 2 & 0x01}]
  # The both switches are on a common OD for their OSs
  Switches::SW2a setoccupied [expr {$tempByte >> 3 & 0x01}]
  Switches::SW2b setoccupied [expr {$tempByte >> 3 & 0x01}]
  Switches::SW2a setstate    [expr {$tempByte >> 4 & 0x03}]
  Switches::SW2b setstate    [expr {$tempByte >> 6 & 0x03}]
  # Invoke all trackwork and get occupicency
  MainWindow ctcpanel invoke BK1T1
  MainWindow ctcpanel invoke BK1T2
  MainWindow ctcpanel invoke BK3T1
  MainWindow ctcpanel invoke BK3T2
  MainWindow ctcpanel invoke BK5T1
  MainWindow ctcpanel invoke BK5T2
  MainWindow ctcpanel invoke SW1a
  MainWindow ctcpanel invoke SW1b
  MainWindow ctcpanel invoke SW2a
  MainWindow ctcpanel invoke SW2b
  # Initialize all signals to Red
  Signals::CP1ET1 setaspect RedRed
  Signals::CP1WT1 setaspect RedRed
  Signals::CP1ET2 setaspect RedRed
  Signals::CP1WT2 setaspect RedRed
  Signals::CP2ET1 setaspect RedRed
  Signals::CP2WT1 setaspect RedRed
  Signals::CP2ET2 setaspect RedRed
  Signals::CP2WT2 setaspect RedRed
  set dot1t1 none ;# Assume no direction of travel through control point 1, track 1
  set dot1t2 none ;# Assume no direction of travel through control point 1, track 2
  if {![MainWindow ctcpanel invoke SW1a] &&
      ![MainWindow ctcpanel invoke SW1b]} {
    # Switch1 (a & b) OS is clear.  We can start to move the points
    Switches::SW1a setmotor [SwitchPlates::CP1SW getlever]
    Switches::SW1b setmotor [SwitchPlates::CP1SW getlever]
    set s1a [Switches::SW1a getstate]
    set s1b [Switches::SW1b getstate]
    if {[string equal "$s1a" "$s1b"]} {
      switch $s1a {
	normal {;# Aligned for the Main.  Set the mainline signals.
	  if {![Blocks::BK1T1 occupiedp] &&
	      [string equal [SignalPlates::CP1T1SG getlever] "left"]} {
	    # Clear to left on track 1
	    Signals::CP1WT1 setaspect GreenRed
	    set dot1t1 left
	  }
	  if {![Blocks::BK1T2 occupiedp] &&
	      [string equal [SignalPlates::CP1T2SG getlever] "left"]} {
	    # Clear to left on track 2
	    Signals::CP1WT2 setaspect GreenRed
	    set dot1t2 left
	  }
	  if {![Blocks::BK3T1 occupiedp] &&
	      [string equal [SignalPlates::CP1T1SG getlever] "right"]} {
	    # Clear to right on track 1
	    Signals::CP1ET1 setaspect GreenRed
	    set dot1t1 right
	  }
	  if {![Blocks::BK3T2 occupiedp] &&
	      [string equal [SignalPlates::CP1T2SG getlever] "right"]} {
	    # Clear to right on track 2
	    Signals::CP1ET2 setaspect GreenRed
	    set dot1t2 right
	  }
	  # Set plate indicators
	  MainWindow ctcpanel seti CP1SW N on
	  MainWindow ctcpanel seti CP1SW R off
	}
	reverse {;# Aligned for crossing over
	  if {[string equal [SignalPlates::CP1T1SG getlever] [SignalPlates::CP1T2SG getlever]]} {
	    if {![Blocks::BK1T1 occupiedp] &&
	         [string equal [SignalPlates::CP1T1SG getlever] "left"]} {
	      Signals::CP1WT2 setaspect RedYellow
	      set dot1t1 left
	      set dot1t2 left
	    }
	    if {![Blocks::BK3T2 occupiedp] &&
		[string equal [SignalPlates::CP1T2SG getlever] "right"]} {
	      Signals::CP1ET1 setaspect RedYellow
	      set dot1t1 right
	      set dot1t2 right
	    }
	  }
	  # Set plate indicators
	  MainWindow ctcpanel seti CP1SW N off
	  MainWindow ctcpanel seti CP1SW R on
	}
	default {;# Points still moving.
	  # Set plate indicators
	  MainWindow ctcpanel seti CP1SW N off
	  MainWindow ctcpanel seti CP1SW R off
	}
      }
    } else {;# Points not consistently aligned
      # Set plate indicators
      MainWindow ctcpanel seti CP1SW N off
      MainWindow ctcpanel seti CP1SW R off
    }
  }
  # Set DOT on signal plates
  SignalPlates::CP1T1SG setdot $dot1t1
  SignalPlates::CP1T2SG setdot $dot1t2
  set dot2t1 none ;# Assume no direction of travel through control point 2, track 1
  set dot2t2 none ;# Assume no direction of travel through control point 2, track 2
  if {![MainWindow ctcpanel invoke SW2a] &&
      ![MainWindow ctcpanel invoke SW2b]} {
    # Switch2 (a & b) OS is clear.  We can start to move the points
    Switches::SW2a setmotor [SwitchPlates::CP2SW getlever]
    Switches::SW2b setmotor [SwitchPlates::CP2SW getlever]
    set s2a [Switches::SW2a getstate]
    set s2b [Switches::SW2b getstate]
    if {[string equal "$s2a" "$s2b"]} {
      switch $s2a {
	normal {;# Aligned for the Main.  Set the mainline signals.
	  if {![Blocks::BK3T1 occupiedp] &&
	      [string equal [SignalPlates::CP2T1SG getlever] "left"]} {
	    # Clear to left on track 1
	    Signals::CP2WT1 setaspect GreenRed
	    set dot2t1 left
	  }
	  if {![Blocks::BK3T2 occupiedp] &&
	      [string equal [SignalPlates::CP2T2SG getlever] "left"]} {
	    # Clear to left on track 2
	    Signals::CP2WT2 setaspect GreenRed
	    set dot2t2 left
	  }
	  if {![Blocks::BK5T1 occupiedp] &&
	      [string equal [SignalPlates::CP2T1SG getlever] "right"]} {
	    # Clear to right on track 1
	    Signals::CP2ET1 setaspect GreenRed
	    set dot2t1 right
	  }
	  if {![Blocks::BK5T2 occupiedp] &&
	      [string equal [SignalPlates::CP2T2SG getlever] "right"]} {
	    # Clear to right on track 2
	    Signals::CP2ET2 setaspect GreenRed
	    set dot2t2 right
	  }
	  # Set plate indicators
	  MainWindow ctcpanel seti CP2SW N on
	  MainWindow ctcpanel seti CP2SW R off
	}
	reverse {;# Aligned for crossing over
	  if {[string equal [SignalPlates::CP2T1SG getlever] [SignalPlates::CP2T2SG getlever]]} {
	    if {![Blocks::BK3T2 occupiedp] &&
	         [string equal [SignalPlates::CP2T2SG getlever] "left"]} {
	      Signals::CP2WT1 setaspect RedYellow
	      set dot2t1 left
	      set dot2t2 left
	    }
	    if {![Blocks::BK5T1 occupiedp] &&
		[string equal [SignalPlates::CP2T1SG getlever] "right"]} {
	      Signals::CP2ET2 setaspect RedYellow
	      set dot2t1 right
	      set dot2t2 right
	    }
	  }
	  # Set plate indicators
	  MainWindow ctcpanel seti CP2SW N off
	  MainWindow ctcpanel seti CP2SW R on
	}
	default {;# Points still moving.
	  # Set plate indicators
	  MainWindow ctcpanel seti CP2SW N off
	  MainWindow ctcpanel seti CP2SW R off
	}
      }
    } else {;# Points not consistently aligned
      # Set plate indicators
      MainWindow ctcpanel seti CP2SW N off
      MainWindow ctcpanel seti CP2SW R off
    }
  }
  # Set DOT on signal plates
  SignalPlates::CP2T1SG setdot $dot2t1
  SignalPlates::CP2T2SG setdot $dot2t2
  # Approach lighting -- darken signals facing empty blocks.
  if {![Blocks::BK1T1 occupiedp]} {
    Signals::CP1ET1 setaspect Dark
  }
  if {![Blocks::BK1T2 occupiedp]} {
    Signals::CP1ET2 setaspect Dark
  }
  if {![Blocks::BK3T1 occupiedp]} {
    Signals::CP1WT1 setaspect Dark
    Signals::CP2ET1 setaspect Dark
  }
  if {![Blocks::BK1T2 occupiedp]} {
    Signals::CP1WT2 setaspect Dark
    Signals::CP2ET2 setaspect Dark
  }
  if {![Blocks::BK5T1 occupiedp]} {
    Signals::CP2WT1 setaspect Dark
  }
  if {![Blocks::BK5T2 occupiedp]} {
    Signals::CP2WT2 setaspect Dark
  }
  # Pack output bits
  # CP1:
  set     CP1_outbits [Signals::CP1ET1 getaspect];# Output Port A, Card 0 (CP1ET1)
  lappend CP1_outbits [Signals::CP1ET2 getaspect];# Output Port B, Card 0 (CP1ET2)
  lappend CP1_outbits [Signals::CP1WT1 getaspect];# Output Port C, Card 0 (CP1WT1)
  lappend CP1_outbits [Signals::CP1WT2 getaspect];# Output Port A, Card 2 (CP1WT2)
  # Output Port B, Card 2 (Switch motor bits SW1a and SW1b)
  lappend CP1_outbits [expr {[Switches::SW1a motorbits] | \
			     [Switches::SW1b motorbits] << 2}]
  lappend CP1_outbits 0;#			    Output Port C, Card 2 (unused)
  # CP2:
  set     CP2_outbits [Signals::CP2ET1 getaspect];# Output Port A, Card 0 (CP2ET1)
  lappend CP2_outbits [Signals::CP2ET2 getaspect];# Output Port B, Card 0 (CP2ET2)
  lappend CP2_outbits [Signals::CP2WT1 getaspect];# Output Port C, Card 0 (CP2WT1)
  lappend CP2_outbits [Signals::CP2WT2 getaspect];# Output Port A, Card 2 (CP2WT2)
  # Output Port B, Card 2 (Switch motor bits SW2a and SW2b)
  lappend CP2_outbits [expr {[Switches::SW2a motorbits] | \
			     [Switches::SW2b motorbits] << 2}]
  lappend CP2_outbits 0;#			    Output Port C, Card 2 (unused)
  # Write all output ports
  eval [list CP1 outputs] $CP1_outbits
  eval [list CP2 outputs] $CP2_outbits
  update;# Update display
}
# Main Loop End


