#!/usr/bin/wish
# Generated code: Thu Sep 20 12:17:19 PM EDT 2012
# Generated by: $Id: CTCPanelWindow.tcl 709 2009-05-01 15:20:49Z heller $
# Add your code to the bottom (after the 'Add User code after this line').
#
# -name AN01
# -width 780
# -height 550
# -hascmri no
# -hasazatrax yes
# -simplemode no
# additionalPackages {}
# Load Tcl/Tk system supplied packages
package require Tk;#		Make sure Tk is loaded
package require BWidget;#       Load BWidgets
package require snit;#		Load Snit

# Load MRR System packages
# Add MRR System package Paths
lappend auto_path /usr/local/lib/MRRSystem;# C++ (binary) packages
lappend auto_path /usr/local/share/MRRSystem;# Tcl (source) packages

package require BWStdMenuBar;#  Load the standard menu bar package
package require MainWindow;#    Load the Main Window package
package require CTCPanel 2.0;#  Load the CTCPanel package (V2)
package require grsupport 2.0;# Load Graphics Support code (V2)

#* 
#* ------------------------------------------------------------------
#* panelCode.tcl - Panel Main Window Creation Library
#* Created by Robert Heller on Sun Apr 13 18:27:24 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: panelCode.tcl 625 2008-04-21 23:39:05Z heller $

snit::type MainWindow {
  pragma -hastypeinfo    no
  pragma -hastypedestroy no
  pragma -hasinstances   no

  typecomponent main
  typecomponent swframe
  typecomponent ctcpanel

  delegate typemethod {ctcpanel *} to ctcpanel
  delegate typemethod {main *} to main
  typemethod createwindow {args} {
    set name [from args -name {}]
    set width [from args -width 800]
    set height [from args -height 800]
    wm protocol . WM_DELETE_WINDOW [mytypemethod CarefulExit]
    wm withdraw .
    wm title . "$name"
    set main [mainwindow .main]
    pack $main -expand yes -fill both
    $main menu entryconfigure file New -state disabled
    $main menu entryconfigure file Open... -state disabled
    $main menu entryconfigure file Save -state disabled
    $main menu entryconfigure file {Save As...} -state disabled
    $main menu entryconfigure file Print... -state disabled
    $main menu entryconfigure file Close -command [mytypemethod CarefulExit]
    $main menu entryconfigure file Exit -command [mytypemethod CarefulExit]
    set frame [$main scrollwindow getframe]
    set swframe [ScrollableFrame $frame.swframe \
			-constrainedheight yes -constrainedwidth yes \
			-width [expr {$width + 15}] -height $height]
    pack $swframe -expand yes -fill both
    $main scrollwindow setwidget $swframe
    set ctcpanel [::CTCPanel::CTCPanel [$swframe getframe].ctcpanel \
			-width $width -height $height]
    pack $ctcpanel -fill both -expand yes
    $main menu add view command \
		-label {Zoom In} \
		-accelerator {+} \
		-command "$ctcpanel zoomBy 2"
    set zoomMenu [menu [$main mainframe getmenu view].zoom -tearoff no]
    $main menu add view cascade \
		-label Zoom \
		-menu $zoomMenu
    $main menu add view command \
		-label {Zoom Out} \
		-accelerator {-} \
		-command "$ctcpanel zoomBy .5"
    $zoomMenu add command -label {16:1} -command "$ctcpanel setZoom 16"
    $zoomMenu add command -label {8:1} -command "$ctcpanel setZoom 8"
    $zoomMenu add command -label {4:1} -command "$ctcpanel setZoom 4"
    $zoomMenu add command -label {2:1} -command "$ctcpanel setZoom 2"
    $zoomMenu add command -label {1:1} -command "$ctcpanel setZoom 1"
    $zoomMenu add command -label {1:2} -command "$ctcpanel setZoom .5"
    $zoomMenu add command -label {1:4} -command "$ctcpanel setZoom .25"
    $zoomMenu add command -label {1:8} -command "$ctcpanel setZoom .125"
    $zoomMenu add command -label {1:16} -command "$ctcpanel setZoom .0625"

    $main showit
  }
  typemethod CarefulExit {{answer no}} {
    if {!$answer} {
      set answer [tk_messageBox -default no -icon question \
			-message {Really Quit?} -title {Careful Exit} \
			-type yesno -parent $main]
      if {$answer} {exit}
    }
  }  
}

MainWindow createwindow -name AN01 -width 780 -height 550
# CTCPanelObjects
MainWindow ctcpanel create Switch SW2 \
	-x 555.0 \
	-y 110.0 \
	-label 2 \
	-controlpoint CP1 \
	-orientation 4 \
	-flipped yes \
	-statecommand {} \
	-occupiedcommand {}
MainWindow ctcpanel create StubYard UpperYard \
	-x 140.0 \
	-y 85.0 \
	-label {} \
	-controlpoint Yard \
	-orientation 7 \
	-flipped yes \
	-occupiedcommand {} \
	-position below
MainWindow ctcpanel create StraightBlock East \
	-x1 560.0 \
	-y1 110 \
	-x2 652.0 \
	-y2 110.0 \
	-controlpoint CP1 \
	-label {} \
	-position below \
	-occupiedcommand {}
MainWindow ctcpanel create Signal S1a \
	-x 130.0 \
	-y 70.0 \
	-label {} \
	-controlpoint CP1 \
	-orientation 3 \
	-heads 2
MainWindow ctcpanel create StubYard LowerYard \
	-x 512.0 \
	-y 133.0 \
	-label {} \
	-controlpoint Yard \
	-orientation 3 \
	-flipped no \
	-occupiedcommand {} \
	-position below
MainWindow ctcpanel create StraightBlock Main \
	-x1 140 \
	-y1 110 \
	-x2 510 \
	-y2 110 \
	-controlpoint CP1 \
	-label {} \
	-position below \
	-occupiedcommand {}
MainWindow ctcpanel create Signal S1b \
	-x 36.0 \
	-y 126.0 \
	-label {} \
	-controlpoint CP1 \
	-orientation 0 \
	-heads 2
MainWindow ctcpanel create Signal S2a \
	-x 510.0 \
	-y 150.0 \
	-label {} \
	-controlpoint CP1 \
	-orientation 7 \
	-heads 2
MainWindow ctcpanel create Signal S2b \
	-x 626.0 \
	-y 96.0 \
	-label {} \
	-controlpoint CP1 \
	-orientation 4 \
	-heads 2
MainWindow ctcpanel create StraightBlock West \
	-x1 20.0 \
	-y1 110.0 \
	-x2 88.0 \
	-y2 110.0 \
	-controlpoint CP1 \
	-label {} \
	-position below \
	-occupiedcommand {}
MainWindow ctcpanel create Switch SW1 \
	-x 95.0 \
	-y 110.0 \
	-label 1 \
	-controlpoint CP1 \
	-orientation 0 \
	-flipped yes \
	-statecommand {} \
	-occupiedcommand {}

package require Azatrax
# Azatrax Nodes

# Add User code after this line
package require RaildriverClient
package require Xpressnet

# Main Loop Start
while {true} {
  # Read all AZATRAX state data
  # Invoke all trackwork and get occupicency
  update;# Update display
}
# Main Loop End

