// -!- c++ -!- //////////////////////////////////////////////////////////////
//
//  System        : 
//  Module        : 
//  Object Name   : $RCSfile$
//  Revision      : $Revision$
//  Date          : $Date$
//  Author        : $Author$
//  Created By    : Robert Heller
//  Created       : Fri Apr 11 13:28:13 2014
//  Last Modified : <170727.1043>
//
//  Description	
//
//  Notes
//
//  History
//	
/////////////////////////////////////////////////////////////////////////////
//
//  Copyright (c) 2014 Deepwoods Software.
// 
//  All Rights Reserved.
// 
// This  document  may  not, in  whole  or in  part, be  copied,  photocopied,
// reproduced,  translated,  or  reduced to any  electronic  medium or machine
// readable form without prior written consent from Deepwoods Software.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef __FCFTUTORIAL_H
#define __FCFTUTORIAL_H

/** @page fcf_Tutorial Freight Car Forwarder (V2) Tutorial
 * 
 * The Freight Car Forwarder is a program designed to simulate freight car 
 * traffic on your model railroad.  It does this by matching types of freight 
 * cars with industries.  Specific types of freight cars are meant to carry 
 * specific types of commodities and specific industries produce or consume
 * specific types of commodities.
 * 
 * Before you start using the Freight Car Forwarder system, you should
 * carefully study Section @ref fcf_ref_Files and 
 * Section @ref fcf_ref_FileFormats of the reference section.   These
 * files describe the system layout (system file), the industries
 * (industry file), the trains that will move the cars (trains file), and
 * the cars themselves (the cars file).  There are some additional files,
 * including an owner's file and a car types file, as well as a file for
 * statistics.  All of these files are plain text files--you will need a
 * plain text file editor (such as Notepad under MS-Windows or gedit under
 * many versions of Linux
 * @latexonly
 * \footnote{It might be worthwhile to install a powerful general purpose 
 * text editor such as GNUEmacs for this purpose.}
 * @endlatexonly
 * ) to create and generally edit these files. The only files
 * that are ever modified by the Freight Car Forwarder system are the cars
 * and the statistics files. You should @e not edit the statistics
 * file--this file is automatically generated by the Freight Car Forwarder
 * system.  While it is possible to use tools available as part of the
 * Freight Car Forwarder system to edit cars in the cars file, it is
 * probably best to use a regular text editor to add, modify, or delete
 * cars in a wholesale manor.  All of the other files are treated as
 * "constant data" by the Freight Car Forwarder system, which will load
 * the data into memory and not modify that data.
 * 
 * @section fcf_tut_LoadingSystemData Loading System Data
 * 
 * The Freight Car Forwarder starts loading data by opening and reading
 * the system file, using either the file menu's @c Open... item or open file
 * button on the toolbar.  This file contains the path names of the other
 * files, which are assumed to be relative to the directory (folder) that
 * contains the system file.  All of the system data is loaded into a
 * large data structure, which is then used by the program to simulate car
 * movements.
 * 
 * @section fcf_tut_AssigningCars Assigning Cars
 * 
 * In order to move cars, the cars need to be @e assigned, that is, they
 * need to have a destination set, either to be loaded (if empty) or
 * unloaded (if loaded).  The Car Assignment procedure performs this task.
 * 
 * @section fcf_tut_RunningTrains Running Trains
 * 
 * Once cars has been assigned, they need to be moved.  Cars are moved on
 * trains, and this is done with the run trains procedures.  There are
 * three of these procedures: Run All Trains in Operating Session, Run
 * Boxmoves, and Run One Train at a time.  The run trains procedures
 * simulate the actual movement of cars and determines which trains will
 * move which cars and in what order.  From this simulation, a set of yard
 * and switch lists can be generated and printed out for use during your
 * operating session.
 * 
 * @section fcf_tut_PrintingYardSwitchLists Printing Yard and Switch Lists
 * 
 * Once the trains have been run, yard and switch lists can be printed
 * out, using the print yard lists menu.
 * 
 * @section fcf_tut_SavingData Saving the updated car data
 * 
 * Once you have assigned cars, simulated train movements and created your
 * Yard and Switch Lists, you should save the cars file.  You should now
 * be ready to run your trains in an operating session.  If your session
 * went off well, you will be ready to make car assignments for your next
 * session.  If there were problems during the operating session (such as
 * bad ordered cars or late trains), you might have to make adjustments
 * before running the car assignment process for the next session.  You
 * would use the car editor to make these adjustments.
 * @latexonly
 * \footnote{It might be easier to use a text editor in the case of wholesale 
 * changes.}
 * @endlatexonly
 * 
 * @section fcf_tut_GeneratingReports Generating Reports
 * 
 * Various reports can also be generated and printed using the reports
 * menu. 
 * 
 * @section fcf_tut_Other Other activities
 * 
 * Other activities include adding, removing, and editing cars and
 * displaying various state information, such as assigned and unassigned
 * cars, car movement information, lists of trains, and lists of
 * industries, stations, and divisions.
 * 
 * 
 */


#endif // __FCFTUTORIAL_H

