#!/usr/bin/wish
# Generated code: Thu Jul 30 14:22:22 EDT 2015
# Generated by: $Id: CTCPanelWindow.tcl 709 2009-05-01 15:20:49Z heller $
# Add your code to the bottom (after the 'Add User code after this line').
#
# -name {Azatrax Siding}
# -width 780
# -height 550
# -hascmri no
# -hasazatrax yes
# -simplemode no
# additionalPackages
# Load Tcl/Tk system supplied packages
package require Tk;#		Make sure Tk is loaded
package require tile;#          Load tile
package require snit;#		Load Snit

# Load MRR System packages
# Add MRR System package Paths
lappend auto_path /usr/local/lib/MRRSystem;# C++ (binary) packages
lappend auto_path /usr/local/share/MRRSystem;# Tcl (source) packages

package require snitStdMenuBar;#  Load the standard menu bar package
package require LabelFrames;#   Label frame widgets
package require MainFrame;#     Main Frame widget
package require ScrollableFrame;#     Scrollable Frame widget
package require MainWindow;#    Load the Main Window package
package require CTCPanel 2.0;#  Load the CTCPanel package (V2)
package require grsupport 2.0;# Load Graphics Support code (V2)

#* 
#* ------------------------------------------------------------------
#* panelCode.tcl - Panel Main Window Creation Library
#* Created by Robert Heller on Sun Apr 13 18:27:24 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: panelCode.tcl 625 2008-04-21 23:39:05Z heller $

snit::type MainWindow {
  pragma -hastypeinfo    no
  pragma -hastypedestroy no
  pragma -hasinstances   no

  typecomponent main
  typecomponent swframe
  typecomponent ctcpanel

  delegate typemethod {ctcpanel *} to ctcpanel
  delegate typemethod {main *} to main
  typemethod createwindow {args} {
    set name [from args -name {}]
    set width [from args -width 800]
    set height [from args -height 800]
    wm protocol . WM_DELETE_WINDOW [mytypemethod CarefulExit]
    wm withdraw .
    wm title . "$name"
    set main [mainwindow .main]
    pack $main -expand yes -fill both
    $main menu entryconfigure file New -state disabled
    $main menu entryconfigure file Open... -state disabled
    $main menu entryconfigure file Save -state disabled
    $main menu entryconfigure file {Save As...} -state disabled
    $main menu entryconfigure file Print... -state disabled
    $main menu entryconfigure file Close -command [mytypemethod CarefulExit]
    $main menu entryconfigure file Exit -command [mytypemethod CarefulExit]
    set frame [$main scrollwindow getframe]
    set swframe [ScrollableFrame $frame.swframe \
			-constrainedheight yes -constrainedwidth yes \
			-width [expr {$width + 15}] -height $height]
    $main scrollwindow setwidget $swframe
    set ctcpanel [::CTCPanel::CTCPanel [$swframe getframe].ctcpanel \
			-width $width -height $height]
    pack $ctcpanel -fill both -expand yes
    $main menu add view command \
		-label {Zoom In} \
		-accelerator {+} \
		-command "$ctcpanel zoomBy 2"
    set zoomMenu [menu [$main mainframe getmenu view].zoom -tearoff no]
    $main menu add view cascade \
		-label Zoom \
		-menu $zoomMenu
    $main menu add view command \
		-label {Zoom Out} \
		-accelerator {-} \
		-command "$ctcpanel zoomBy .5"
    $zoomMenu add command -label {16:1} -command "$ctcpanel setZoom 16"
    $zoomMenu add command -label {8:1} -command "$ctcpanel setZoom 8"
    $zoomMenu add command -label {4:1} -command "$ctcpanel setZoom 4"
    $zoomMenu add command -label {2:1} -command "$ctcpanel setZoom 2"
    $zoomMenu add command -label {1:1} -command "$ctcpanel setZoom 1"
    $zoomMenu add command -label {1:2} -command "$ctcpanel setZoom .5"
    $zoomMenu add command -label {1:4} -command "$ctcpanel setZoom .25"
    $zoomMenu add command -label {1:8} -command "$ctcpanel setZoom .125"
    $zoomMenu add command -label {1:16} -command "$ctcpanel setZoom .0625"

    $main showit
  }
  typemethod CarefulExit {{answer no}} {
    if {!$answer} {
      set answer [tk_messageBox -default no -icon question \
			-message {Really Quit?} -title {Careful Exit} \
			-type yesno -parent $main]
      if {$answer} {exit}
    }
  }  
}

MainWindow createwindow -name {Azatrax Siding} -width 780 -height 550
# CTCPanelObjects
MainWindow ctcpanel create SWPlate SwitchPlate1 \
	-x 90.0 \
	-y 80.0 \
	-label 1 \
	-controlpoint CP1 \
	-normalcommand {switch1 motor normal} \
	-reversecommand {switch1 motor reverse}
MainWindow ctcpanel create SWPlate SwitchPlate2 \
	-x 630.0 \
	-y 80.0 \
	-label 2 \
	-controlpoint CP2 \
	-normalcommand {switch2 motor normal} \
	-reversecommand {switch2 motor reverse}
MainWindow ctcpanel create StraightBlock Main \
	-x1 115.0 \
	-y1 180.0 \
	-x2 605.0 \
	-y2 180.0 \
	-controlpoint Dummy \
	-label main \
	-position below \
	-occupiedcommand {main occupiedp}
MainWindow ctcpanel create StraightBlock Siding \
	-x1 115.0 \
	-y1 160.0 \
	-x2 605.0 \
	-y2 160.0 \
	-controlpoint Dummy \
	-label siding \
	-position above \
	-occupiedcommand {siding occupiedp}
MainWindow ctcpanel create Switch Switch1 \
	-x 70.0 \
	-y 180.0 \
	-label 1 \
	-controlpoint CP1 \
	-orientation 0 \
	-flipped yes \
	-statecommand {switch1 pointstate} \
	-occupiedcommand {switch1 occupiedp}
MainWindow ctcpanel create Switch Switch2 \
	-x 650.0 \
	-y 180.0 \
	-label 2 \
	-controlpoint CP2 \
	-orientation 4 \
	-flipped no \
	-statecommand {switch2 pointstate} \
	-occupiedcommand {switch2 occupiedp}
MainWindow ctcpanel create CodeButton Code1 \
	-x 90.0 \
	-y 157.0 \
	-controlpoint CP1 \
	-command {code1 code}
MainWindow ctcpanel create CodeButton Code2 \
	-x 632.0 \
	-y 157.0 \
	-controlpoint CP2 \
	-command {code2 code}

package require Azatrax
# Azatrax Nodes

# Add User code after this line

#* ControlPoints:START *
# Control points.  Used to implement code buttons.  
# Encapsulates a control point
snit::type ControlPoint {
    option -cpname -readonly yes -default {}
    constructor {args} {
        $self configurelist $args
    }
    method code {} {
        foreach swp [MainWindow ctcpanel objectlist $options(-cpname) SwitchPlates] {
            MainWindow ctcpanel invoke $swp
        }      
        foreach sgp [MainWindow ctcpanel objectlist $options(-cpname) SignalPlates] {
            MainWindow ctcpanel invoke $sgp
        }
    }
}
#* ControlPoints:END *

# Load in MRD2_Block code
package require MRD2_Block

# Load in SR4_MRD2_Switch code
package require SR4_MRD2_Switch

# Load in Azatrax_Signals
package require Azatrax_Signals

## @file Azatrax_Siding.tcl 
# @brief This file contains a simple passing siding with block detection and
# turnout actuation using Azatrax's MRD2 and SR4 devices.
#
# Four MRD2-Us are used for occupancy detection and one SR4 is used to activate
# the switch motors (Circuitron Tortoise Switch Machines).  There are no 
# signals in this example, although working signals can be easily added.
#
# 
#
# Using the Abstract Data Types (Classes) MRD2_Block and SR4_MRD2_Switch 
# almost all of the code is embeded in these Abstract Data Types, which makes 
# the code here very simple.  Specificly, we create a MRD2_Block object for the
# main and siding tracks:
# Two straight blocks, with MRD2s
MRD2_Block main   -sensorsn 0200001234
MRD2_Block siding -sensorsn 0200001235
## Then create a connection to the SR4 for use by the two turnouts:
# One SR4 for turnout control
SR4 turnoutControl1 -this [Azatrax_OpenDevice 0400001234 \
                           $::Azatrax_idSR4Product]
## Then we create a SR4_MRD2_Switch object for each turnout, linking them to 
# the main and siding tracks.
# Two turnouts, one at each end.
SR4_MRD2_Switch switch1 -motorobj turnoutControl1 -motorhalf lower \
      -pointsenseobj turnoutControl1 -pointsensehalf lower \
      -ossensorsn 0200001236 -nextmainblock main -nextdivergentblock siding \
      -plate SwitchPlate1
SR4_MRD2_Switch switch2 -motorobj turnoutControl1 -motorhalf upper \
      -pointsenseobj turnoutControl1 -pointsensehalf upper \
      -ossensorsn 0200001237 -forwarddirection reverse  \
      -nextmainblock main -nextdivergentblock siding \
      -plate SwitchPlate2
## Then connect the main and siding MRD2_Block objects to the SR4_MRD2_Switch 
# objects.
# Connect the siding and main to the switch frogs
main configure -previousblock switch1 -nextblock switch2
siding configure -previousblock switch1 -nextblock switch2
## Finally, we create a pair of CodeButton objects for the code buttons.
# Two Code buttons
ControlPoint code1 -cpname CP1
ControlPoint code2 -cpname CP2
## When we assembled the track work and control panel, we set the scripts to 
# run the various callback methods:
#
# For the Main straight block, the "Occupied Script" would be 
# "main occupiedp". For the Siding it would be "siding occupiedp".
# For Switches, "State Script" would be set to "switchN pointstate" and
# "Occupied Script" would be set to "switchN occupiedp". For the switch
# plates, the "Normal Script" would be "switchN motor normal" and the
# "Reverse Script" would be "switchN motor reverse". Finally the code
# buttons would have an "Action Script" of "codeN code". Thus everything is 
# tied together.  The main loop 'invokes' the track work elements, which runs 
# the occupency methods.
# Main Loop Start
while {true} {
  # Read all AZATRAX state data
  # Invoke all trackwork and get occupicency
  MainWindow ctcpanel invoke Switch2
  MainWindow ctcpanel invoke Main
  MainWindow ctcpanel invoke Siding
  MainWindow ctcpanel invoke Switch1
  update;# Update display
}
# Main Loop End
## The code buttons will run the switch plate functions which in turn 
# will activate the switch machines.

