#!/usr/bin/wish
# Generated code: Thu Aug 20 15:28:05 EDT 2015
# Generated by: $Id: CTCPanelWindow.tcl 709 2009-05-01 15:20:49Z heller $
# Add your code to the bottom (after the 'Add User code after this line').
#
# -name {Fox Yard}
# -width 780
# -height 550
# -hascmri no
# -hasctiacela no
# -hasazatrax no
# -simplemode no
# additionalPackages
# Load Tcl/Tk system supplied packages
package require Tk;#		Make sure Tk is loaded
package require tile;#          Load tile
package require snit;#		Load Snit

# Load MRR System packages
# Add MRR System package Paths
lappend auto_path /usr/local/lib/MRRSystem;# C++ (binary) packages
lappend auto_path /usr/local/share/MRRSystem;# Tcl (source) packages

package require snitStdMenuBar;#  Load the standard menu bar package
package require LabelFrames;#   Label frame widgets
package require MainFrame;#     Main Frame widget
package require ScrollableFrame;#     Scrollable Frame widget
package require MainWindow;#    Load the Main Window package
package require CTCPanel 2.0;#  Load the CTCPanel package (V2)
package require grsupport 2.0;# Load Graphics Support code (V2)

#* 
#* ------------------------------------------------------------------
#* panelCode.tcl - Panel Main Window Creation Library
#* Created by Robert Heller on Sun Apr 13 18:27:24 2008
#* ------------------------------------------------------------------
#* Modification History: $Log$
#* Modification History: Revision 1.1  2002/07/28 14:03:50  heller
#* Modification History: Add it copyright notice headers
#* Modification History:
#* ------------------------------------------------------------------
#* Contents:
#* ------------------------------------------------------------------
#*  
#*     Model RR System, Version 2
#*     Copyright (C) 1994,1995,2002-2005  Robert Heller D/B/A Deepwoods Software
#* 			51 Locke Hill Road
#* 			Wendell, MA 01379-9728
#* 
#*     This program is free software; you can redistribute it and/or modify
#*     it under the terms of the GNU General Public License as published by
#*     the Free Software Foundation; either version 2 of the License, or
#*     (at your option) any later version.
#* 
#*     This program is distributed in the hope that it will be useful,
#*     but WITHOUT ANY WARRANTY; without even the implied warranty of
#*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*     GNU General Public License for more details.
#* 
#*     You should have received a copy of the GNU General Public License
#*     along with this program; if not, write to the Free Software
#*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#* 
#*  
#* 

# $Id: panelCode.tcl 625 2008-04-21 23:39:05Z heller $

snit::type MainWindow {
  pragma -hastypeinfo    no
  pragma -hastypedestroy no
  pragma -hasinstances   no

  typecomponent main
  typecomponent swframe
  typecomponent ctcpanel

  delegate typemethod {ctcpanel *} to ctcpanel
  delegate typemethod {main *} to main
  typemethod createwindow {args} {
    set name [from args -name {}]
    set width [from args -width 800]
    set height [from args -height 800]
    wm protocol . WM_DELETE_WINDOW [mytypemethod CarefulExit]
    wm withdraw .
    wm title . "$name"
    set main [mainwindow .main]
    pack $main -expand yes -fill both
    $main menu entryconfigure file New -state disabled
    $main menu entryconfigure file Open... -state disabled
    $main menu entryconfigure file Save -state disabled
    $main menu entryconfigure file {Save As...} -state disabled
    $main menu entryconfigure file Print... -state disabled
    $main menu entryconfigure file Close -command [mytypemethod CarefulExit]
    $main menu entryconfigure file Exit -command [mytypemethod CarefulExit]
    set frame [$main scrollwindow getframe]
    set swframe [ScrollableFrame $frame.swframe \
			-constrainedheight yes -constrainedwidth yes \
			-width [expr {$width + 15}] -height $height]
    $main scrollwindow setwidget $swframe
    set ctcpanel [::CTCPanel::CTCPanel [$swframe getframe].ctcpanel \
			-width $width -height $height]
    pack $ctcpanel -fill both -expand yes
    $main menu add view command \
		-label {Zoom In} \
		-accelerator {+} \
		-command "$ctcpanel zoomBy 2"
    set zoomMenu [menu [$main mainframe getmenu view].zoom -tearoff no]
    $main menu add view cascade \
		-label Zoom \
		-menu $zoomMenu
    $main menu add view command \
		-label {Zoom Out} \
		-accelerator {-} \
		-command "$ctcpanel zoomBy .5"
    $zoomMenu add command -label {16:1} -command "$ctcpanel setZoom 16"
    $zoomMenu add command -label {8:1} -command "$ctcpanel setZoom 8"
    $zoomMenu add command -label {4:1} -command "$ctcpanel setZoom 4"
    $zoomMenu add command -label {2:1} -command "$ctcpanel setZoom 2"
    $zoomMenu add command -label {1:1} -command "$ctcpanel setZoom 1"
    $zoomMenu add command -label {1:2} -command "$ctcpanel setZoom .5"
    $zoomMenu add command -label {1:4} -command "$ctcpanel setZoom .25"
    $zoomMenu add command -label {1:8} -command "$ctcpanel setZoom .125"
    $zoomMenu add command -label {1:16} -command "$ctcpanel setZoom .0625"

    $main showit
  }
  typemethod CarefulExit {{answer no}} {
    if {!$answer} {
      set answer [tk_messageBox -default no -icon question \
			-message {Really Quit?} -title {Careful Exit} \
			-type yesno -parent $main]
      if {$answer} {exit}
    }
  }  
}

MainWindow createwindow -name {Fox Yard} -width 780 -height 550
# CTCPanelObjects
MainWindow ctcpanel create SWPlate TG11Plate \
	-x 290.0 \
	-y 100 \
	-label 11 \
	-controlpoint FOX \
	-normalcommand {} \
	-reversecommand {}
MainWindow ctcpanel create StraightBlock FOXYard-1 \
	-x1 387.0 \
	-y1 168.0 \
	-x2 430.0 \
	-y2 168.0 \
	-controlpoint FOX \
	-label {} \
	-position above \
	-occupiedcommand {}
MainWindow ctcpanel create Lamp DOT3-East \
	-x 204.0 \
	-y 78.0 \
	-controlpoint Main \
	-color white \
	-label East
MainWindow ctcpanel create StraightBlock BK18-1 \
	-x1 370.0 \
	-y1 210.0 \
	-x2 590.0 \
	-y2 210.0 \
	-controlpoint FOX \
	-label BK18 \
	-position above \
	-occupiedcommand {BK18 occupiedp}
MainWindow ctcpanel create Switch TG10 \
	-x 50.0 \
	-y 210.0 \
	-label 10 \
	-controlpoint DONALDSON \
	-orientation 4 \
	-flipped no \
	-statecommand {sm10 pointsense} \
	-occupiedcommand {sm10 occupiedp}
MainWindow ctcpanel create StraightBlock FOXYard-2 \
	-x1 367.0 \
	-y1 188.0 \
	-x2 387.0 \
	-y2 168.0 \
	-controlpoint FOX \
	-label {} \
	-position above \
	-occupiedcommand {}
MainWindow ctcpanel create CurvedBlock BK18-2 \
	-x1 590.0 \
	-y1 210.0 \
	-x2 630.0 \
	-y2 170.0 \
	-radius 40 \
	-controlpoint FOX \
	-label {} \
	-position above \
	-occupiedcommand {BK18 occupiedp}
MainWindow ctcpanel create Switch TF12 \
	-x 325.0 \
	-y 210.0 \
	-label 12 \
	-controlpoint FOX \
	-orientation 0 \
	-flipped yes \
	-statecommand {TF12 pointsense} \
	-occupiedcommand {TF12 occupiedp}
MainWindow ctcpanel create Switch TG11 \
	-x 280.0 \
	-y 210.0 \
	-label 11 \
	-controlpoint FOX \
	-orientation 0 \
	-flipped yes \
	-statecommand {sm11 pointsense} \
	-occupiedcommand {sm11 occupiedp}
MainWindow ctcpanel create Signal SIG20RABC \
	-x 275.0 \
	-y 225.0 \
	-label {} \
	-controlpoint FOX \
	-orientation 0 \
	-heads 3
MainWindow ctcpanel create StraightBlock BK18-3 \
	-x1 630 \
	-y1 170 \
	-x2 630.0 \
	-y2 80.0 \
	-controlpoint FOX \
	-label {} \
	-position above \
	-occupiedcommand {BK18 occupiedp}
MainWindow ctcpanel create CurvedBlock BK18-4 \
	-x1 630 \
	-y1 80 \
	-x2 590 \
	-y2 40 \
	-radius 40 \
	-controlpoint FOX \
	-label {} \
	-position above \
	-occupiedcommand {BK18 occupiedp}
MainWindow ctcpanel create Signal SIG16LA \
	-x 136.0 \
	-y 196.0 \
	-label {} \
	-controlpoint BK16 \
	-orientation 4 \
	-heads 1
MainWindow ctcpanel create StraightBlock BK18-5 \
	-x1 590.0 \
	-y1 40.0 \
	-x2 470.0 \
	-y2 40.0 \
	-controlpoint FOX \
	-label {} \
	-position above \
	-occupiedcommand {BK18 occupiedp}
MainWindow ctcpanel create StraightBlock BK18-6 \
	-x1 470.0 \
	-y1 40.0 \
	-x2 320.0 \
	-y2 190.0 \
	-controlpoint FOX \
	-label {} \
	-position above \
	-occupiedcommand {BK18 occupiedp}
MainWindow ctcpanel create Signal SIG18LA \
	-x 219.0 \
	-y 197.0 \
	-label {} \
	-controlpoint BK17 \
	-orientation 4 \
	-heads 1
MainWindow ctcpanel create Lamp DOT3-West \
	-x 147.0 \
	-y 78.0 \
	-controlpoint Main \
	-color white \
	-label West
MainWindow ctcpanel create SWPlate TG10Plate \
	-x 40.0 \
	-y 100 \
	-label 10 \
	-controlpoint DONALDSON \
	-normalcommand {sm10 motor normal} \
	-reversecommand {sm10 motor reverse}
MainWindow ctcpanel create Signal SIG20LA \
	-x 420.0 \
	-y 200.0 \
	-label {} \
	-controlpoint FOX \
	-orientation 4 \
	-heads 1
MainWindow ctcpanel create StraightBlock BK15 \
	-x1 55.0 \
	-y1 210.0 \
	-x2 135.0 \
	-y2 210.0 \
	-controlpoint DONALDSON \
	-label BK15 \
	-position above \
	-occupiedcommand {BK15 occupiedp}
MainWindow ctcpanel create Signal SIG20LB \
	-x 335.0 \
	-y 155.0 \
	-label {} \
	-controlpoint FOX \
	-orientation 3 \
	-heads 1
MainWindow ctcpanel create StraightBlock BK16 \
	-x1 138.0 \
	-y1 210.0 \
	-x2 220.0 \
	-y2 210.0 \
	-controlpoint BK16 \
	-label BK16 \
	-position above \
	-occupiedcommand {BK16 occupiedp}
MainWindow ctcpanel create StraightBlock BK17 \
	-x1 225.0 \
	-y1 210.0 \
	-x2 275.0 \
	-y2 210.0 \
	-controlpoint BK17 \
	-label BK17 \
	-position above \
	-occupiedcommand {BK17 occupiedp}
MainWindow ctcpanel create StubYard FOXYard \
	-x 431.0 \
	-y 168.0 \
	-label {} \
	-controlpoint FOX \
	-orientation 0 \
	-flipped yes \
	-occupiedcommand {} \
	-position below
MainWindow ctcpanel create Signal SIG20LD \
	-x 372.0 \
	-y 168.0 \
	-label {} \
	-controlpoint FOX \
	-orientation 3 \
	-heads 1
MainWindow ctcpanel create Signal SIG16RA \
	-x 137.0 \
	-y 225.0 \
	-label {} \
	-controlpoint BK16 \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create Signal SIG18RA \
	-x 225.0 \
	-y 225.0 \
	-label {} \
	-controlpoint BK11 \
	-orientation 0 \
	-heads 1
MainWindow ctcpanel create Signal SIG14LAB \
	-x 53.0 \
	-y 197.0 \
	-label {} \
	-controlpoint DONALDSON \
	-orientation 4 \
	-heads 2

# Add User code after this line
package require CmriSupport;# require the Cmri Support package
package require snit;#    require the SNIT OO framework

snit::enum signalcolors -values {
    ## @enum signalcolors
    # @brief Basic signal colors.
    # The four values are dark, red, yellow, and green.
    
    dark
    ## Dark, all lamps off, implies red.
    
    red
    ## Red, generally stop or stop and proceed.
    
    yellow
    ## Yellow, generally approach.
    
    green
    ## Green, generally clear.
}

snit::type OneHead3Color {
    ## @brief Single head signals, 3 color.
    #
    # Typically used for simple block signals. Three bits of one output port
    # connected top (green) to bottom (red).
    #
    # Typical usage:
    #
    # @code
    # # Connect to the cmribus through a USB RS485 adapter at /dev/ttyUSB0
    # CmriSupport::CmriNode openport /dev/ttyUSB0
    # # SMINI board at address 0
    # CmriSupport::CmriNode SMINI0 -type SMINI -address 0
    # # Block signal 1 on the low three bits of output port 0
    # chubb_signals::OneHead3Color blocksignal1 -nodeobj SMINI0 -port 0 \
    # -bit 0 -signalname Signal1
    # # Block signal 2 on the low next three bits of output port 0
    # chubb_signals::OneHead3Color blocksignal2 -nodeobj SMINI0 -port 0 \
    # -bit 3 -signalname Signal2
    # @endcode
    #
    #
    # @author Robert Heller \<heller\@deepsoft.com\>
    
    # SMINI related options
    # Node object
    option -nodeobj -readonly yes -default {}
    # Output port and bits for signal control
    option -port -readonly yes -default 0 -type {snit::integer -min 0}
    option -bit  -readonly yes -default 0 -type {snit::integer -min 0 -max 5}
    # Signal name
    option -signalname -readonly yes -default {}
    
    component node
    ## @private SMINI node object
    typevariable aspectbits -array {
        dark   0x00
        green  0x01
        yellow 0x02
        red    0x04
    }
    ## @private Aspect bits.
    typevariable aspectmask 0x07
    ## @private Aspect mask
    
    
    typemethod validate {object} {
        ## Type validating code
        # Raises an error if object is not either the empty string or a 
        # OneHead3Color type object.
        # @param object Some object.
        
        if {$object eq ""} {
            return $object;# Empty or null objects are OK
        } elseif {[catch {$object info type} itstype]} {
            error "$object is not a $type";# object is not a SNIT type
        } elseif {$itstype eq $type} {
            return $object;# Object is of our type.
        } else {
            error "$object is not a $type";# object is something else
        }
    }
    
    constructor {args} {
        ## @brief Constructor: initialize the signal object.
        #
        # Create a low level actuator object and install it as a component.
        #
        # @param name Name of the signal object.
        # @param ... Options:
        # @arg -nodeobj Cmri node object.
        # @arg -port  Output port number.
        # @arg -bit   Bit offset for signal.
        # @arg -signalname Name of the signal on the track work schematic.
        # @par
        
        # Prefetch the -nodeobj option.
        set options(-nodeobj) [from args -nodeobj]
        if {$options(-nodeobj) eq {}} {
            error "The -nodeobj option is required!"
        }
        set node $options(-nodeobj)
        CmriSupport::CmriNode validate $node
        $self setaspect dark
    }
    
    method setaspect {aspect} {
        ## Set signal aspect.
        #
        # @param aspect New aspect color.
        
        signalcolors validate $aspect
        set bits [expr {$aspectbits($aspect) << [$self cget -bit]}]
        set mask [expr {$aspectmask << [$self cget -bit]}]
        $node setbitfield [$self cget -port] $mask $bits
        set sig [$self cget -signalname]
        if {$sig ne {}} {MainWindow ctcpanel setv $sig $aspect}
    }
}

snit::listtype twoaspectlist -minlen 2 -maxlen 2 -type signalcolors
## @typedef twoaspectlist
# @brief Aspects for two headed signals.
# This is a list of two aspect colors, the first element for the upper head 
# and the second element for the lower head.


snit::type TwoHead3over2 {
    ## @brief Two head signals, 3 over 2.
    #
    # Typically used for simple interlocking signals.  Five bits of one output
    # port from top to bottom, hit bit to low bit.
    #
    # Typical usage:
    #
    # @code
    # # Connect to the cmribus through a USB RS485 adapter at /dev/ttyUSB0
    # CmriSupport::CmriNode openport /dev/ttyUSB0
    # # SMINI board at address 0
    # CmriSupport::CmriNode SMINI0 -type SMINI -address 0
    # # Three over two Interlocking Signal interlocksignal1
    # chubb_signals::TwoHead3over2 interlocksignal1 -nodeobj SMINI0 -port 0 \
    #                                -bit 0 -signalname Signal1
    # @endcode
    #
    # @author Robert Heller \<heller\@deepsoft.com\>
    
    # SMINI related options
    # Node object
    option -nodeobj -readonly yes -default {}
    # Output port and bits for signal control
    option -port -readonly yes -default 0 -type {snit::integer -min 0}
    option -bit  -readonly yes -default 0 -type {snit::integer -min 0 -max 3}
    # Signal name
    option -signalname -readonly yes -default {}
    
    component node
    ## @private SMINI node object
    typevariable aspectbits -array {
        dark         0x00
        dark-dark    0x00
        red-red      0x0C
        red-yellow   0x06
        yellow-red   0x12
        green-red    0x11
    }
    ## @private Aspect bits.
    typevariable aspectmask 0x1f
    ## @private Aspect mask
    
    typemethod validate {object} {
        ## Type validating code
        # Raises an error if object is not either the empty string or a 
        # TwoHead3over2 type object.
        # @param object Some object.
        
        if {$object eq ""} {
            return $object;# Empty or null objects are OK
        } elseif {[catch {$object info type} itstype]} {
            error "$object is not a $type";# object is not a SNIT type
        } elseif {$itstype eq $type} {
            return $object;# Object is of our type.
        } else {
            error "$object is not a $type";# object is something else
        }
    }
    
    constructor {args} {
        ## @brief Constructor: initialize the signal object.
        #
        # Create a low level actuator object and install it as a component.
        #
        # @param name Name of the signal object.
        # @param ... Options:
        # @arg -nodeobj Cmri node object.
        # @arg -port  Output port number.
        # @arg -bit   Bit offset for signal.
        # @arg -signalname Name of the signal on the track work schematic.
        # @par
        
        # Prefetch the -nodeobj option.
        set options(-nodeobj) [from args -nodeobj]
        if {$options(-nodeobj) eq {}} {
            error "The -nodeobj option is required!"
        }
        set node $options(-nodeobj)
        CmriSupport::CmriNode validate $node
        $self setaspect dark
    }
    
    method setaspect {aspect} {
        ## Set signal aspect.
        #
        # @param aspect New aspect color.
        
        twoaspectlist validate $aspect
        set jaspect [join $aspect -]
        if {![info exists aspectbits($jaspect)]} {
            error "Undefined aspect: $aspect
        }
        set bits [expr {$aspectbits($jaspect) << [$self cget -bit]}]
        set mask [expr {$aspectmask << [$self cget -bit]}]
        $node setbitfield [$self cget -port] $mask $bits
        set sig [$self cget -signalname]
        if {$sig ne {}} {MainWindow ctcpanel setv $sig $aspect}
    }
    
}

snit::listtype threeaspectlist -minlen 3 -maxlen 3 -type signalcolors
## @typedef threeaspectlist
# @brief Aspects for three headed signals.
# This is a list of three aspect colors, the first element for the upper head 
# and the second element for the middle head, and finally the third element
# for the bottom head.

snit::type ThreeHead3over2over2 {
    ## @brief Three head signals, 3 over 2 over 2.
    #
    # Typically used for simple interlocking signals.  Seven bits of one
    # output port from top to bottom, hit bit to low bit.
    #
    # Typical usage:
    #
    # @code
    # # Connect to the cmribus through a USB RS485 adapter at /dev/ttyUSB0
    # CmriSupport::CmriNode openport /dev/ttyUSB0
    # # SMINI board at address 0
    # CmriSupport::CmriNode SMINI0 -type SMINI -address 0
    # # Three over two over two Interlocking Signal interlocksignal1
    # chubb_signals::TwoHead3over2over2 interlocksignal1 -nodeobj SMINI0 \
    #                                -port 0 -bit 0 \
    #                                -signalname Signal1
    # @endcode
    #
    # @author Robert Heller \<heller\@deepsoft.com\>
    # SMINI related options
    # Node object
    option -nodeobj -readonly yes -default {}
    # Output port and bits for signal control
    option -port -readonly yes -default 0 -type {snit::integer -min 0}
    option -bit  -readonly yes -default 0 -type {snit::integer -min 0 -max 1}
    
    component node
    ## @private SMINI node object
    typevariable aspectbits -array {
        dark           0x00
        dark-dark      0x00
        dark-dark-dark 0x00
        red-red-red    0x54
        red-red-yellow 0x34
        red-yellow-red 0x4C
        yellow-red-red 0x52
        green-red-red  0x51
    }
    ## @private Aspect bits.
    typevariable aspectmask 0x7f
    ## @private Aspect mask
    
    typemethod validate {object} {
        ## Type validating code
        # Raises an error if object is not either the empty string or a 
        # TwoHead2over2over2 type object.
        # @param object Some object.
        
        if {$object eq ""} {
            return $object;# Empty or null objects are OK
        } elseif {[catch {$object info type} itstype]} {
            error "$object is not a $type";# object is not a SNIT type
        } elseif {$itstype eq $type} {
            return $object;# Object is of our type.
        } else {
            error "$object is not a $type";# object is something else
        }
    }
    
    constructor {args} {
        ## @brief Constructor: initialize the signal object.
        #
        # Create a low level actuator object and install it as a component.
        #
        # @param name Name of the signal object.
        # @param ... Options:
        # @arg -nodeobj Cmri node object.
        # @arg -port  Output port number.
        # @arg -bit   Bit offset for signal.
        # @arg -signalname Name of the signal on the track work schematic.
        # @par
        
        # Prefetch the -nodeobj option.
        set options(-nodeobj) [from args -nodeobj]
        if {$options(-nodeobj) eq {}} {
            error "The -nodeobj option is required!"
        }
        set node $options(-nodeobj)
        CmriSupport::CmriNode validate $node
        $self setaspect dark
    }
    
    method setaspect {aspect} {
        ## Set signal aspect.
        #
        # @param aspect New aspect color.
        
        twoaspectlist validate $aspect
        set jaspect [join $aspect -]
        if {![info exists aspectbits($jaspect)]} {
            error "Undefined aspect: $aspect
        }
        set bits [expr {$aspectbits($jaspect) << [$self cget -bit]}]
        set mask [expr {$aspectmask << [$self cget -bit]}]
        $node setbitfield [$self cget -port] $mask $bits
        set sig [$self cget -signalname]
        if {$sig ne {}} {MainWindow ctcpanel setv $sig $aspect}
    }
}

snit::type C4TSMINI_Switch {
    ##
    # @brief Switch (turnout) operation using a Chubb SMINI board and a Circuits4Tracks Quad OD for OS detection
    #
    # @image html switch-C4TSMINI-thumb.png
    # @image latex switch-C4TSMINI.png "Switch controlled by a Chubb SMINI board with a Circuits4Tracks OS detection" width=5in
    #
    # Above is a typical switch (turnout) using an Chubb SMINI board to 
    # control a Circuitron Tortoise Switch Machine and to sense the point 
    # position and a Circuits4Track quad occupancy detector to sense 
    # occupation of the switch.
    #
    # Typical usage:
    #
    # @code
    # # Connect to the cmribus through a USB RS485 adapter at /dev/ttyUSB0
    # CmriSupport::CmriNode openport /dev/ttyUSB0
    # # SMINI board at address 0
    # CmriSupport::CmriNode SMINI0 -type SMINI -address 0
    # # Switch 1 is controled by bits 0 and 1 of output port 0
    # # Switch 1 points are sensed by bits 0 and 1 of input port 0
    # # Switch 1 OS is detected on bit 0 of input port 1
    # C4TSMINI_Switch switch1 -nodeobj SMINI0 -motorport 0 -motorbit 0 \
    #                       -plate SwitchPlate1 \
    #                       -ossensorport 1 -osbit 0
    # # Switch 2 is controled by bits 0 and 1 of output port 1
    # # Switch 2 points are sensed by bits 2 and 3 of input port 0
    # # Switch 2 OS is detected on bit 1 of input port 1
    # C4TSMINI_Switch switch2 -nodeobj SMINI0 -motorport 1 -motorbit 0 \
    #                       -plate SwitchPlate2 \
    #                       -ossensorport 1 -osbit 1
    # @endcode
    #
    # For the track work elements use "switchN occupiedp" for the track work
    # elements' occupied script and use "switchN pointstate" for the track 
    # work elements' state script. For the switch plate use 
    # "switchN motor normal" for the normal script and "switchN motor reverse"
    # for the reverse script.
    #
    # Then in the Main Loop, you would have:
    # @code
    # while {true} {
    #     MainWindow ctcpanel invoke Switch1
    #     MainWindow ctcpanel invoke Switch2
    #     MainWindow ctcpanel invoke SwitchPlate1
    #     MainWindow ctcpanel invoke SwitchPlate2
    #     update;# Update display
    # }
    # @endcode
    #
    # @author Robert Heller \<heller\@deepsoft.com\>
    
    # SMINI related options
    # Node object
    option -nodeobj -readonly yes -default {}
    # Output port and bits for motor control
    option -motorport -readonly yes -default 0 -type {snit::integer -min 0}
    option -motorbit  -readonly yes -default 0 -type {snit::integer -min 0 -max 6}
    # Input port and bit for OS sense
    option -ossensorport -readonly yes -default 0 -type {snit::integer -min 0}
    option -osbit  -readonly yes -default 0 -type {snit::integer -min 0 -max 7}
    
    # Switch Plate name (if any).
    option -plate -default {}
    
    component node
    ## @private SMINI node object
    variable isoccupied no
    ## @private Saved occupation state.
    typevariable _motorbits -array {
        normal  0
        reverse 1
    }
    ## @private Motor bit values
    
    variable motorstate -1
    ## @private Saved motor state
    
    typemethod validate {object} {
        ## Type validating code
        # Raises an error if object is not either the empty string or a SR4_C4TSR4_Switch
        # type.
        # @param object Some object.
        
        if {$object eq ""} {
            return $object;# Empty or null objects are OK
        } elseif {[catch {$object info type} itstype]} {
            error "$object is not a $type";# object is not a SNIT type
        } elseif {$itstype eq $type} {
            return $object;# Object is of our type (SR4_C4TSR4_Switch)
        } else {
            error "$object is not a $type";# object is something else
        }
    }
    
    constructor {args} {
        ## @brief Constructor: initialize the switch object.
        #
        # Create a low level sensor object and install it as a component.
        # Install the switch's signals, motor, and point sense objects.
        #
        # @param name Name of the switch object
        # @param ... Options:
        # @arg -nodeobj Cmri node object
        # @arg -motorport Output port number for motor control.
        # @arg -motorbit Motor control bit.
        # @arg -ossensorport Input port for OS sense.
        # @arg -osbit This defines the input bit on the input port for OS 
        # sense.
        # @arg -plate The name of the switch plate for this switch.
        # @par
        
        ## Process any other options
        $self configurelist $args
        set node [$self cget -nodeobj]
        if {$node eq {}} {
            error "The -nodeobj option is required!"
        }
        CmriSupport::CmriNode validate $node
    }
    
    method occupiedp {} {
        ## The occupiedp method returns yes or no (true or false) indicating
        # block (OS) occupation.
        # @returns Yes or no, indicating whether the OS is occupied.
        
        # First read the current sensor state.
        set inputs [$node inputs]
        set port [lindex $inputs [$self cget -ossensorport]]
        set bit  [expr {($port >> [$self cget -osbit]) & 0x01}]
        # The outputs of the OD are active negative, so we need to invert the
        # logic.
        set bit  [expr {(~$bit) & 0x01}]
        if {$bit == 1} {
            if {$isoccupied} {
                # Already entered the OS.
                return $isoccupied
            } else {
                # Just entered the OS
                set isoccupied yes
                $self _entering
                return $isoccupied
            }
        } else {
            if {$isoccupied} {
                # Just left the OS
                set isoccupied no
                $self _exiting
                return $isoccupied
            } else {
                # OS still unoccupied
                return $isoccupied
            }
        }
    }
    method pointstate {} {
        ## The pointstate method returns normal if the points are aligned to
        # the main route and reverse if the points are aligned to the divergent
        # route. If the state cannot be determined, a value of unknown is 
        # returned.
        # @returns Normal or reverse, indicating the point state.
        
        # Assume point state is unknown.
        set result unknown
        if {$motorstate == $_motorbits(normal)} {
            set result normal
        } elseif {$motorstate == $_motorbits(reverse)} {
            set result reverse
        }
        if {[$self cget -plate] ne {}} {
            set plate [$self cget -plate]
            switch $result {
                normal {
                    MainWindow ctcpanel seti $plate N on
                    MainWindow ctcpanel seti $plate C off
                    MainWindow ctcpanel seti $plate R off
                }
                reverse {
                    MainWindow ctcpanel seti $plate N off
                    MainWindow ctcpanel seti $plate C off
                    MainWindow ctcpanel seti $plate R on
                }
                unknown {
                    MainWindow ctcpanel seti $plate N off
                    MainWindow ctcpanel seti $plate C on
                    MainWindow ctcpanel seti $plate R off
                }
            }
        }
        return $result
    }
    typevariable _routes 
    ## @private Route check validation object.
    typeconstructor {
        set _routes [snit::enum _routes -values {normal reverse}]
    }
    
    method motor {route} {
        ## The motor method sets the switch motor to align the points for the
        # specificed route.
        # @param route The desired route.  A value of normal means align the
        # points to the main (straight) route and a value of reverse means 
        # align the points to the divergent route.
        
        $_routes validate $route
        set mask [expr {0x01 << [$self cget -motorbit]}]
        set bits [expr {$_motorbits($route) << [$self cget -motorbit]}]
        $node setbitfield [$self cget -motorport] $mask $bits
    }
    method _entering {} {
        ## @protected Code to run when just entering the OS
        
    }
    method _exiting {} {
        ## @protected Code to run when about to exit the OS
    }
}

snit::type C4TSMINI_ManualSwitch {
    ##
    # @brief Manual Switch (turnout) operation using a Chubb SMINI board 
    # for turnout position sensing (ground throw) and a Circuits 4 Tracks 
    # Quad OD for OS detection
    #
    # @image html switch-C4TSMINI-thumb.png
    # @image latex switch-C4TSMINI.png "Switch controlled by a Chubb SMINI board with a Circuits4Tracks OS detection" width=5in
    #
    # Above is a typical switch (turnout) using an Chubb SMINI board to 
    # control a Circuitron Tortoise Switch Machine and to sense the point 
    # position and a Circuits4Track quad occupancy detector to sense 
    # occupation of the switch.
    #
    # Typical usage:
    #
    # @code
    # # Connect to the cmribus through a USB RS485 adapter at /dev/ttyUSB0
    # CmriSupport::CmriNode openport /dev/ttyUSB0
    # # SMINI board at address 0
    # CmriSupport::CmriNode SMINI0 -type SMINI -address 0
    # # Switch 1 position is sensed by bit 0 of output port 0
    # # Switch 1 OS is detected on bit 0 of input port 1
    # C4TSMINI_Switch switch1 -nodeobj SMINI0 -pointsensport 0 \
    #                       -pointsenebit 0 \
    #                       -plate SwitchPlate1 \
    #                       -ossensorport 1 -osbit 0
    # @endcode
    #
    # For the track work elements use "switchN occupiedp" for the track work
    # elements' occupied script and use "switchN pointstate" for the track 
    # work elements' state script. For the switch plate use 
    # "switchN motor normal" for the normal script and "switchN motor reverse"
    # for the reverse script.
    #
    # Then in the Main Loop, you would have:
    # @code
    # while {true} {
    #     MainWindow ctcpanel invoke Switch1
    #     MainWindow ctcpanel invoke Switch2
    #     MainWindow ctcpanel invoke SwitchPlate1
    #     MainWindow ctcpanel invoke SwitchPlate2
    #     update;# Update display
    # }
    # @endcode
    #
    # @author Robert Heller \<heller\@deepsoft.com\>
    
    # SMINI related options
    # Node object
    option -nodeobj -readonly yes -default {}
    # Output port and bits for motor control
    option -pointsensport -readonly yes -default 0 -type {snit::integer -min 0}
    option -pointsensebit  -readonly yes -default 0 -type {snit::integer -min 0 -max 6}
    # Input port and bit for OS sense
    option -ossensorport -readonly yes -default 0 -type {snit::integer -min 0}
    option -osbit  -readonly yes -default 0 -type {snit::integer -min 0 -max 7}
    
    # Switch Plate name (if any).
    option -plate -default {}
    
    component node
    ## @private SMINI node object
    variable isoccupied no
    ## @private Saved occupation state.
    typevariable _pointsensebits -array {
        0 normal
        1 reverse
    }
    ## @private Pointsense  bit values
    
    variable motorstate -1
    ## @private Saved motor state
    
    typemethod validate {object} {
        ## Type validating code
        # Raises an error if object is not either the empty string or a SR4_C4TSR4_Switch
        # type.
        # @param object Some object.
        
        if {$object eq ""} {
            return $object;# Empty or null objects are OK
        } elseif {[catch {$object info type} itstype]} {
            error "$object is not a $type";# object is not a SNIT type
        } elseif {$itstype eq $type} {
            return $object;# Object is of our type (SR4_C4TSR4_Switch)
        } else {
            error "$object is not a $type";# object is something else
        }
    }
    
    constructor {args} {
        ## @brief Constructor: initialize the switch object.
        #
        # Create a low level sensor object and install it as a component.
        # Install the switch's signals, motor, and point sense objects.
        #
        # @param name Name of the switch object
        # @param ... Options:
        # @arg -nodeobj Cmri node object
        # @arg -motorport Output port number for motor control.
        # @arg -motorbit Motor control bit.
        # @arg -ossensorport Input port for OS sense.
        # @arg -osbit This defines the input bit on the input port for OS 
        # sense.
        # @arg -plate The name of the switch plate for this switch.
        # @par
        
        ## Process any other options
        $self configurelist $args
        set node [$self cget -nodeobj]
        if {$node eq {}} {
            error "The -nodeobj option is required!"
        }
        CmriSupport::CmriNode validate $node
    }
    
    method occupiedp {} {
        ## The occupiedp method returns yes or no (true or false) indicating
        # block (OS) occupation.
        # @returns Yes or no, indicating whether the OS is occupied.
        
        # First read the current sensor state.
        set inputs [$node inputs]
        set port [lindex $inputs [$self cget -ossensorport]]
        set bit  [expr {($port >> [$self cget -osbit]) & 0x01}]
        # The outputs of the OD are active negative, so we need to invert the
        # logic.
        set bit  [expr {(~$bit) & 0x01}]
        if {$bit == 1} {
            if {$isoccupied} {
                # Already entered the OS.
                return $isoccupied
            } else {
                # Just entered the OS
                set isoccupied yes
                $self _entering
                return $isoccupied
            }
        } else {
            if {$isoccupied} {
                # Just left the OS
                set isoccupied no
                $self _exiting
                return $isoccupied
            } else {
                # OS still unoccupied
                return $isoccupied
            }
        }
    }
    method pointstate {} {
        ## The pointstate method returns normal if the points are aligned to
        # the main route and reverse if the points are aligned to the divergent
        # route. If the state cannot be determined, a value of unknown is 
        # returned.
        # @returns Normal or reverse, indicating the point state.
        
        # Assume point state is unknown.
        set result unknown
        set inputs [$node inputs]
        set port [lindex $inputs [$self cget -pointsenseport]]
        set bit  [expr {($port >> [$self cget -pointsensebit]) & 0x01}]
        set result $_pointsensebits($bit)
        if {[$self cget -plate] ne {}} {
            set plate [$self cget -plate]
            switch $result {
                normal {
                    MainWindow ctcpanel seti $plate N on
                    MainWindow ctcpanel seti $plate C off
                    MainWindow ctcpanel seti $plate R off
                }
                reverse {
                    MainWindow ctcpanel seti $plate N off
                    MainWindow ctcpanel seti $plate C off
                    MainWindow ctcpanel seti $plate R on
                }
                unknown {
                    MainWindow ctcpanel seti $plate N off
                    MainWindow ctcpanel seti $plate C on
                    MainWindow ctcpanel seti $plate R off
                }
            }
        }
        return $result
    }
    typevariable _routes 
    ## @private Route check validation object.
    typeconstructor {
        set _routes [snit::enum _routes -values {normal reverse}]
    }
    
    method motor {route} {
        ## The motor method sets the switch motor to align the points for the
        # specificed route.
        # @param route The desired route.  A value of normal means align the
        # points to the main (straight) route and a value of reverse means 
        # align the points to the divergent route.
        
        $_routes validate $route
        set mask [expr {0x01 << [$self cget -motorbit]}]
        set bits [expr {$_motorbits($route) << [$self cget -motorbit]}]
        $node setbitfield [$self cget -motorport] $mask $bits
    }
    method _entering {} {
        ## @protected Code to run when just entering the OS
        
    }
    method _exiting {} {
        ## @protected Code to run when about to exit the OS
    }
}


snit::type C4TSMINI_Block {
    ##
    # @brief Block occupation detection using Circuits4Tracks Quad Occupancy Detectors and Azatrax SR4s
    #
    # @image html C4TSMINI_Block-thumb.png
    # @image latex C4TSMINI_Block.png "Block detection with a Circuits4Tracks Quad Occupancy Detector and a Chubb SMINI card" width=5in
    #
    # Above is a simple diagram for using Circuits4Tracks Quad Occupancy 
    # Detectors for block occupation detection. A Circuits4Tracks Quad 
    # Occupancy board has four current sensors. One wires one side of the
    # track power (either DCC or DC) to a common rail and the other side
    # through the Circuits4Tracks Quad Occupancy Detector to rails isolated
    # with gaps (possibly with insulating rail joiners).  This code uses
    # a Chubb SMINI board to connect a Circuits4Tracks Quad Occupancy Detectors
    # to the computer via a serial interface.
    #
    # Typical usage:
    #
    #
    # Four blocks in a loop:
    #
    # @code
    # # Connect to the cmribus through a USB RS485 adapter at /dev/ttyUSB0
    # CmriSupport::CmriNode openport /dev/ttyUSB0
    # # SMINI board at address 0
    # CmriSupport::CmriNode SMINI0 -type SMINI -address 0
    # # The first four bits of the first port are wired to the Circuits4Tracks 
    # # Quad Occupancy Detector
    # C4TSR4_Block block1 -nodeobj SMINI0 -port 0 -bit 0 -signalobj signal1
    # C4TSR4_Block block2 -nodeobj SMINI0 -port 0 -bit 1 -signalobj signal2 -previousblock block1
    # C4TSR4_Block block3 -nodeobj SMINI0 -port 0 -bit 2 -signalobj signal3 -previousblock block2
    # C4TSR4_Block block4 -nodeobj SMINI0 -port 0 -bit 3 -signalobj signal4 -previousblock block3
    # block1 configure -previousblock block4
    # @endcode
    # A Schematic of the layout would look like this:    
    # @image html 4circleblocks.png
    # @image latex 4circleblocks.png "Four block circle" width=3in
    # For the track work elements use "blockN occupiedp" for the track work 
    # elements' occupied command:
    # eg Block1 would have 'block1 occupiedp' as its occupied command, that is 
    # its edit window would look like:
    # @image html EditingBlock1.png
    # @image latex EditingBlock1.png "Editing Block1" width=5in
    # The other three blocks would be similar.
    #
    # 
    # Then in the Main Loop, you would have:
    # @code
    # while {true} { 
    #     MainWindow ctcpanel invoke Block1
    #     MainWindow ctcpanel invoke Block2
    #     MainWindow ctcpanel invoke Block3
    #     MainWindow ctcpanel invoke Block4
    #     update;# Update display
    # }
    # @endcode
    #
    # @author Robert Heller \<heller\@deepsoft.com\>
    
    option -nodeobj -readonly yes -default {} -type ::CmriSupport::CmriNode
    option -port -readonly yes -default 0 -type {snit::integer -min 0}
    option -bit -readonly yes -default 0 -type {snit::integer -min 0 -max 7}
    typemethod validate {object} {
        ## Type validating code
        # Raises an error if object is not either the empty string or a C4TSMINI_Block
        # type.
        
        if {$object eq ""} {
            return $object;# Empty or null objects are OK
        } elseif {[catch {$object info type} itstype]} {
            error "$object is not a $type";# object is not a SNIT type
        } elseif {$itstype eq $type} {
            return $object;# Object is of our type (Block)
        } else {
            error "$object is not a $type";# object is something else
        }
    }
    component node
    ## @privatesection SMINI node object
    variable isoccupied no
    ## Saved occupation state.
    
    
    constructor {args} {
        ## @publicsection @brief Constructor: initialize the block object.
        #
        # Create a lowlevel node object and install it as a component.
        # Install the blocks signal (created elsewhere).
        #
        # @param name Name of the block object
        # @param ... Options:
        # @arg -nodeobj This is the Cmri node for this block.  This is a 
        # CmriNode object, defined in the Control Support package. This option
        # is read-only and must be set at creation time.
        # @arg -port    The input port on the Cmri node. This is an integer
        # greater or equal to 0.  This option is read-only and can only be
        # set at creation time.  The default is 0.
        # @arg -bit This defines the input bit on the input port for this 
        # block. This is an integer from 0 to 7 inclusive and is read-only
        # and can only be set at creation time.  The default is 0.
        # @arg -direction Current running direction, either the word forward
        # or reverse.  The default is forward.
        # @par
        
        ## Process any options 
        $self configurelist $args
        # Install the node
        set node [$self cget -nodeobj]
        if {$node eq {}} {
            error "The -nodeobj is required!"
        }
    }
    method occupiedp {} {
        ## The occupiedp method returns yes or no (true or false) indicating 
        # block occupation.
        
        # First read the current sensor state.
        set inputs [$node inputs]
        set port [lindex $inputs [$self cget -port]]
        set bit  [expr {($port >> [$self cget -bit]) & 0x01}]
        # The outputs of the OD are active negative, so we need to invert the
        # logic.
        set bit  [expr {(~$bit) & 0x01}]
        if {$bit == 1} {
            if {$isoccupied} {
                # Already entered the block.
                return $isoccupied
            } else {
                # Just entered the block
                set isoccupied yes
                $self _entering
                return $isoccupied
            }
        } else {
            if {$isoccupied} {
                # Just left the block
                set isoccupied no
                $self _exiting
                return $isoccupied
            } else {
                # Block still unoccupied
                return $isoccupied
            }
        }
    }
    method _entering {} {
        ## @privatesection Method for entering a block.
        
    }
    method _exiting {} {
        ## Method for exiting a block.
        
        # Nothing here -- could be used for any sort of exit handling.
    }
}

## Connect to the Chubb CmriNet
CmriSupport::CmriNode openport /dev/ttyUSB0
# Two SMINI nodes -- see Chapter 14 of The Computer / Model Railroad Interface 
# User's Manual for details -- note: this is only a subset of Figure 14-3.
CmriSupport::CmriNode EvertJct -type SMINI -address 3
CmriSupport::CmriNode Donaldson -type SMINI -address 2

## Create all abstract objects for all trackwork.
C4TSMINI_Switch sm10 -nodeobj Donaldson -motorport 4 -motorbit 6 \
      -plate TG10Plate -ossensorport 0 -osbit 3
TwoHead3over2 SIG14LAB -nodeobj Donaldson -port 3 -bit 0 -signalname SIG14LAB
C4TSMINI_Block BK15 -nodeobj Donaldson -port 0 -bit 4
OneHead3Color SIG16LA -nodeobj Donaldson -port 4 -bit 0 -signalname SIG16LA
OneHead3Color SIG16RA -nodeobj Donaldson -port 4 -bit 3 -signalname SIG16RA
C4TSMINI_Block BK16 -nodeobj EvertJct -port 0 -bit 0
OneHead3Color SIG18LA -nodeobj EvertJct -port 0 -bit 0 -signalname SIG18LA
OneHead3Color SIG18RA -nodeobj EvertJct -port 0 -bit 3 -signalname SIG18RA
C4TSMINI_Block BK17 -nodeobj EvertJct -port 0 -bit 1
ThreeHead3over2over2 SIG20RABC EvertJct -port 1 -bit 0 -signalname SIG20RABC
C4TSMINI_Switch sm11 -nodeobj EvertJct -motorport 0 -motorbit 6 \
      -plate TG11Plate -ossensorport 0 -osbit 2
OneHead3Color SIG20LB -nodeobj EvertJct -port 2 -bit 3 -signalname SIG20LB
OneHead3Color SIG20LD -nodeobj EvertJct -port 3 -bit 0 -signalname SIG20LD
OneHead3Color SIG20LA -nodeobj EvertJct -port 2 -bit 0 -signalname SIG20LA
C4TSMINI_ManualSwitch TF12 -nodeobj EvertJct -pointsenseport 0 \
      -pointsensebit 4 -ossensorport 0 -osbit 2
C4TSMINI_Block BK18 -nodeobj EvertJct -port 0 -bit 3

set DOT3 nodirection


# Main Loop Start
while {true} {
  # Invoke all trackwork and get occupicency
  MainWindow ctcpanel invoke FOXYard-1
  MainWindow ctcpanel invoke TG10
  MainWindow ctcpanel invoke FOXYard-2
  MainWindow ctcpanel invoke BK18-1
  MainWindow ctcpanel invoke TG11
  MainWindow ctcpanel invoke TF12
  MainWindow ctcpanel invoke BK18-2
  MainWindow ctcpanel invoke BK18-3
  MainWindow ctcpanel invoke BK18-4
  MainWindow ctcpanel invoke BK18-5
  MainWindow ctcpanel invoke BK18-6
  MainWindow ctcpanel invoke BK15
  MainWindow ctcpanel invoke BK16
  MainWindow ctcpanel invoke FOXYard
  MainWindow ctcpanel invoke BK17
  # Activate switch motors
  MainWindow ctcpanel invoke TG10Plate
  MainWindow ctcpanel invoke TG11Plate
  
  if {[sm10 occupied] && $DOT3 ne "Westbound"} {
      set DOT3 Eastbound
  } elseif {[sm10 occupied] && $DOT3 ne "Eastbound"} {
      set DOT3 Westbound
  }
  if {![sm10 occupiedp] &&
      ![BK15 occupiedp] &&
      ![BK16 occupiedp] &&
      ![BK17 occupiedp] &&
      ![sm11 occupiedp]} {
      set DOT3 nodirection
  }
  
  ## Calculate SIG20RABC
  SIG20RABC setaspect {red red red}
  if {![sm11 occupiedp]} {
      if {[sm11 pointsense] eq "normal" && [TF12 pointsense] eq "reverse"} {
          SIG20RABC setaspect {red red yellow}
      } elseif {![BK18 occupiedp]} {
          if {[sm11 pointsense] eq "normal"} {
              SIG20RABC setaspect {yellow red red}
          } else {
              SIG20RABC setaspect {red yellow red}
          }
      }
  }
  
  ## Calculate SIG18RA
  SIG18RA setaspect red
  if {$DOT3 ne "Westbound"} {
      if {![BK17 occupiedp]} {
          SIG18RA setaspect yellow
          if {[join [MainWindow ctcpanel getv SIG20RABC] -] ne "red-red-red"} {
              SIG18RA setaspect green
          }
      }
  }
  ## Calculate SIG16RA
  SIG16RA setaspect red
  if {$DOT3 ne "Westbound"} {
      if {![BK16 occupiedp]} {
          SIG16RA setaspect yellow
          if {[MainWindow ctcpanel getv SIG18RA] ne "red"} {
              SIG16RA setaspect green
          }
      }
  }
  ## Calculate SIG14LAB
  SIG14LAB setaspect {red red}
  if {![sm10 occupiedp]} {
      if {[sm10 pointsense] ne "reverse"} {
          SIG14LAB setaspect {green red}
      } else {
          SIG14LAB setaspect {red yellow}
      }
  }
  ## Calculate SIG16LA
  SIG16LA setaspect red
  if {$DOT3 ne "Eastbound"} {
      if {![BK15 occupiedp]} {
          SIG16LA setaspect yellow
      }
      if {[join [MainWindow ctcpanel getv SIG14LAB] -] ne "red-red"} {
          SIG16LA setaspect green
      }
  }
  ## Calculate SIG18LA
  SIG18LA setaspect red
  if {$DOT3 ne "Eastbound"} {
      if {![BK16 occupiedp]} {
          SIG18LA setaspect yellow
      }
      if {[MainWindow ctcpanel getv SIG16LA] ne "red"} {
          SIG18LA setaspect green
      }
  }
  ## Calculate SIG20LA, SIG20LB, SIG20LD
  SIG20LA setaspect red
  SIG20LB setaspect red
  SIG20LD setaspect red
  if {$DOT3 ne "Eastbound"} {
      if {![sm11 occupiedp]} {
          if {![BK17 occupiedp]} {
              set SIG20L yellow
              if {[MainWindow ctcpanel getv SIG18LA] eq "red"} {
                  set SIG20L green
              }
              if {[sm11 pointsense] eq "reverse"} {
                  SIG20LB setaspect $SIG20L
              } else {
                  if {[TF12 pointsense] eq "reverse"} {
                      SIG20LD setaspect $SIG20L
                  } else {
                      SIG20LA setaspect $SIG20L
                  }
              }
          }
      }
  }
  MainWindow ctcpanel setv DOT3-West off
  MainWindow ctcpanel setv DOT3-East off
  if {$DOT3 eq "Eastbound"} {
      MainWindow ctcpanel setv DOT3-East on
  }
  if {$DOT3 eq "Westbound"} {
      MainWindow ctcpanel setv DOT3-West on
  }
  update;# Update display
}
# Main Loop End



